/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.model;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.BasicModelObject;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class ModelViewConnector
implements BasicModelObject.IModelChangeListener,
Listener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(ModelViewConnector.class);
    private boolean handlingViewUpdate = false;
    private boolean handlingModelUpdate = false;
    private ArrayList<Control> trackedControls = new ArrayList();
    private ArrayList<BasicModelObject> trackedModels = new ArrayList();

    @Deprecated
    public static boolean unfocussed(Control control) {
        return !control.isFocusControl();
    }

    public static boolean focussed(Control control) {
        return control.isFocusControl();
    }

    public static boolean isEmpty(Text control) {
        if (control == null) {
            return true;
        }
        return control.getText().isEmpty();
    }

    public static boolean isEmpty(Combo control) {
        if (control == null) {
            return true;
        }
        return control.getText().isEmpty();
    }

    public static boolean isSelected(Control selectableWidget) {
        if (selectableWidget == null) {
            return false;
        }
        if (selectableWidget instanceof Button) {
            return ((Button)selectableWidget).getSelection();
        }
        throw new IllegalArgumentException();
    }

    public static void setSelected(Control selectableWidget, boolean selected) {
        if (selectableWidget == null) {
            return;
        }
        if (!(selectableWidget instanceof Button)) {
            throw new IllegalArgumentException();
        }
        ((Button)selectableWidget).setSelection(selected);
    }

    public static void setEnabledIf(Control widget, boolean enabled) {
        if (widget == null) {
            return;
        }
        widget.setEnabled(enabled);
    }

    public static void setText(Text widget, String text2) {
        Point sel = widget.getSelection();
        widget.setText(text2);
        widget.setSelection(sel);
    }

    public static void setText(Combo widget, String text2) {
        Point sel = widget.getSelection();
        widget.setText(text2);
        widget.setSelection(sel);
    }

    public static void guessFocus(Control c) {
        if (!ModelViewConnector.focusFirstTextOrCombo(c, true)) {
            ModelViewConnector.focusFirstTextOrCombo(c, false);
        }
    }

    private static boolean focusFirstTextOrCombo(Control c, boolean mustBeEmpty) {
        if (c instanceof Composite) {
            Control[] controls;
            Control[] controlArray = controls = ((Composite)c).getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                boolean childFocused;
                Control control = controlArray[n2];
                if ((control.getStyle() & 8) == 0) {
                    if (control instanceof Text) {
                        Text text2 = (Text)control;
                        if (!mustBeEmpty || text2.getText().isEmpty()) {
                            text2.setSelection(0);
                            text2.setFocus();
                            return true;
                        }
                    } else if (control instanceof Combo) {
                        Combo combo2 = (Combo)control;
                        if (!mustBeEmpty || combo2.getText().isEmpty()) {
                            combo2.setSelection(new Point(0, 0));
                            combo2.setFocus();
                            return true;
                        }
                    }
                }
                if (childFocused = ModelViewConnector.focusFirstTextOrCombo(control, mustBeEmpty)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void listenTo(Control control) {
        if (control instanceof Button) {
            ((Button)control).addListener(13, (Listener)this);
        } else if (control instanceof Text) {
            ((Text)control).addListener(24, (Listener)this);
        } else if (control instanceof Combo) {
            Combo combo2 = (Combo)control;
            if ((combo2.getStyle() & 8) == 8) {
                combo2.addListener(13, (Listener)this);
            } else {
                combo2.addListener(24, (Listener)this);
            }
        } else if (control instanceof DateTime) {
            ((DateTime)control).addListener(13, (Listener)this);
        }
        control.addListener(16, (Listener)this);
        this.trackedControls.add(control);
    }

    public void listenTo(BasicModelObject model) {
        model.addListener(this);
        this.trackedModels.add(model);
    }

    public void dispose() {
        for (Control control : this.trackedControls) {
            control.removeListener(13, (Listener)this);
            control.removeListener(24, (Listener)this);
            control.removeListener(16, (Listener)this);
        }
        for (BasicModelObject modelObject : this.trackedModels) {
            modelObject.removeListener(this);
        }
    }

    public void handleEvent(Event event) {
        if (!this.isHandlingModelUpdate()) {
            this.updateModelFromView();
        }
    }

    private void updateModelFromView() {
        if (this.isHandlingViewUpdate()) {
            return;
        }
        this.setHandlingViewUpdate(true);
        this.updateModelFromViewImpl();
        this.onModelUpdated();
        this.setHandlingViewUpdate(false);
    }

    protected abstract void updateModelFromViewImpl();

    protected abstract void updateViewFromModelImpl();

    @Override
    public void onModelUpdated() {
        if (this.isHandlingModelUpdate()) {
            return;
        }
        this.setHandlingModelUpdate(true);
        this.updateViewFromModelImpl();
        this.setHandlingModelUpdate(false);
    }

    public void doManualViewUpdate() {
        this.setHandlingViewUpdate(true);
        this.onModelUpdated();
        this.setHandlingViewUpdate(false);
    }

    public boolean isHandlingViewUpdate() {
        return this.handlingViewUpdate;
    }

    public void setHandlingViewUpdate(boolean avoidingModelUpdate) {
        this.handlingViewUpdate = avoidingModelUpdate;
    }

    public boolean isHandlingModelUpdate() {
        return this.handlingModelUpdate;
    }

    public void setHandlingModelUpdate(boolean handlingModelUpdateEvent) {
        this.handlingModelUpdate = handlingModelUpdateEvent;
    }

    protected void updateComboFromModelIfNeeded(Combo combo2, String modelText) {
        if (ModelViewConnector.unfocussed((Control)combo2) && !combo2.getText().equals(modelText)) {
            combo2.setText(modelText);
        }
    }

    protected void updateButtonSelectionFromModelIfNeeded(Button button2, boolean modelSelection) {
        if (ModelViewConnector.unfocussed((Control)button2) && button2.getSelection() != modelSelection) {
            button2.setSelection(modelSelection);
        }
    }

    protected void updateTextFromModelIfNeeded(Text text2, String modelText) {
        if (ModelViewConnector.unfocussed((Control)text2) && !text2.getText().equals(modelText)) {
            text2.setText(modelText);
        }
    }
}

