/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.logging;

import java.io.UnsupportedEncodingException;
import java.util.Formatter;

public abstract class DumpFormatter {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int CHAR_WIDTH = 48;

    public static String format(byte[] bytes, int start, int length, String codePage) {
        StringBuilder sb = new StringBuilder(10000);
        Throwable throwable = null;
        Object var6_7 = null;
        try (Formatter f = new Formatter(sb);){
            int counter = 0;
            while (counter < length) {
                if (counter + 48 < length) {
                    DumpFormatter.writeLine(bytes, start + counter, 48, 48, f, codePage);
                    counter += 48;
                    continue;
                }
                DumpFormatter.writeLine(bytes, start + counter, length - counter, 48, f, codePage);
                counter = length;
            }
            f.format("%n", new Object[0]);
            return f.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void writeLine(byte[] buffer, int start, int length, int maxLength, Formatter f, String codePage) {
        int count = 0;
        int i = 0;
        while (i < length) {
            f.format("%02X", buffer[start + i]);
            if (++count == 4) {
                f.format(" ", new Object[0]);
                count = 0;
            }
            ++i;
        }
        if (length < maxLength) {
            i = 0;
            while (i < maxLength - length) {
                f.format("  ", new Object[0]);
                if (++count == 4) {
                    f.format(" ", new Object[0]);
                    count = 0;
                }
                ++i;
            }
        }
        try {
            if (length < maxLength) {
                f.format("  *%s", new String(buffer, start, length, codePage));
                int appendLen = maxLength - length;
                int i2 = 0;
                while (i2 < appendLen) {
                    f.format("%c", Character.valueOf(' '));
                    ++i2;
                }
                f.format("*%n", new Object[0]);
            } else {
                f.format("  *%s*%n", new String(buffer, start, length, codePage));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

