/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.integration;

import com.ibm.pdtools.common.component.core.integration.PDAdapterHelper;
import com.ibm.pdtools.common.component.core.integration.PDMVSConnection;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.text.MessageFormat;

public class PDMVSResource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(PDMVSResource.class);
    private final PDMVSConnection famvsConnection;
    private final String name;
    private final String recordFormat;
    private final int recordLength;
    private final boolean isContainer;

    public PDMVSResource(PDMVSConnection famvsConnection, String name, String recordFormat, int recordLength, boolean isContainer) {
        this.famvsConnection = famvsConnection;
        this.name = name;
        this.recordFormat = recordFormat;
        this.recordLength = recordLength;
        this.isContainer = isContainer;
    }

    public String getRecordFormat() {
        return this.recordFormat;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public String getName() {
        return this.name;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public PDMVSConnection getConnection() {
        return this.famvsConnection;
    }

    public boolean isHistoryFile() {
        return this.getRecordLength() == 10000 && ("VB".equals(this.getRecordFormat()) || "FB".equals(this.getRecordFormat())) && this.isContainer();
    }

    public String toString() {
        return String.format("PDMVSResource [famvsConnection=%s, name=%s, recordFormat=%s, recordLength=%s, isContainer=%s]", this.famvsConnection, this.name, this.recordFormat, this.recordLength, this.isContainer);
    }

    public static PDMVSResource adapt(Object object) {
        PDMVSResource adapted = PDAdapterHelper.adapt(object, PDMVSResource.class);
        if (PDLogger.isTraceEnabled() && adapted != null) {
            logger.trace(MessageFormat.format("Successfully adapted specified object {0} PDMVSResource: {1}", object, adapted));
        }
        return adapted;
    }
}

