/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.integration;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.Platform;

public abstract class PDAdapterHelper {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(PDAdapterHelper.class);

    @Deprecated
    public static Object adapt(Object o, String type) {
        return PDAdapterHelper.adaptImpl(o, type);
    }

    private static Object adaptImpl(Object o, String type) {
        Objects.requireNonNull(o, "Object to adapt must not be null!");
        Objects.requireNonNull(type, "Type string must not be null!");
        Object adapter = null;
        if (Platform.getAdapterManager().hasAdapter(o, type)) {
            adapter = Platform.getAdapterManager().getAdapter(o, type);
            if (adapter == null) {
                adapter = Platform.getAdapterManager().loadAdapter(o, type);
            }
        } else if (PDLogger.isTraceEnabled()) {
            logger.trace(MessageFormat.format("There is no adapter registered / available to adapt  {0} to a {1}", o, type));
        }
        return adapter;
    }

    public static <T> T adapt(Object o, Class<T> type) {
        Object adapter;
        if (o != null && type.isInstance(adapter = PDAdapterHelper.adaptImpl(o, type.getCanonicalName()))) {
            return type.cast(adapter);
        }
        if (PDLogger.isTraceEnabled()) {
            logger.trace(MessageFormat.format("The object {0} (class: {1} could not be adapted into a {2}", o == null ? "null" : o, o != null ? o.getClass() : "(o is null)", type.getCanonicalName()));
        }
        return null;
    }
}

