/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.comms;

import com.ibm.cics.core.comm.AbstractConnection;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.comms.IPDCommonConnection;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.PDToolsCommonServerClientJhost;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.IConnectionUtilities2;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionRequestListener;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionRequestListener2;
import com.ibm.pdtools.common.component.jhost.comms.NewConnectionProviderJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class PDCommonConnectionProvider
extends AbstractConnection
implements IPDCommonConnection {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.pdtools.comms.cics.connection";
    public static final String CATEGORY = "com.ibm.pdtools.comms.cics.category";
    public static final String KEY_ENCODING = "keyDefaultEncoding";
    private static final String HOST_CONNECTION_VIEW_ID = "com.ibm.cics.explorer.connections_view";
    @Deprecated
    public static final String KEY_HOST_TYPE = "hostType";
    public static final String KEY_BIDI_FORMAT = "keyBidiFormat";
    private boolean connected = false;
    private boolean disconnectCC = true;
    private static boolean explicitConnectIssued = false;
    private static String changePwd = "";

    public static synchronized void setExplicitConnectIssued() {
        explicitConnectIssued = true;
    }

    private static synchronized void unsetExplicitConnectIssued() {
        explicitConnectIssued = false;
    }

    private static synchronized boolean getExplicitConnectIssued() {
        return explicitConnectIssued;
    }

    public static void setChangePassword(String changePwd) {
        PDCommonConnectionProvider.changePwd = changePwd;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void connect() throws ConnectionException {
        ArrayList listeners2;
        ArrayList listeners;
        if (PDCommonConnectionProvider.getExplicitConnectIssued()) {
            this.connected = true;
            PDCommonConnectionProvider.unsetExplicitConnectIssued();
            return;
        }
        ConnectionConfiguration aConfig = this.getConfiguration();
        final HostDetails details = ConnectionUtilities.getHostDetails(aConfig.getID());
        final AuthDetails authDetails = new AuthDetails(aConfig.getCredentialsID(), aConfig.getUserID(), aConfig.getPassword());
        final StringBuilder info = new StringBuilder();
        final ArrayList configs = new ArrayList();
        final AtomicBoolean result = new AtomicBoolean();
        final IWorkbench workbench = PlatformUI.getWorkbench();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    workbench.getProgressService().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InterruptedException {
                            monitor.beginTask(Messages.PDCommonConnectionProvider_3, 2);
                            monitor.worked(1);
                            try {
                                monitor.worked(1);
                                if (!changePwd.isEmpty()) {
                                    result.set(NewConnectionProviderJhost.checkConnectionToChangePass((HostDetails)details, (AuthDetails)authDetails, (StringBuilder)info, (List)configs, (IConnectionUtilities2)new ConnectionUtilities(), (String)changePwd, (IHowIsGoing)PDUtils.convertIprogressToIHowIsGoing(monitor)));
                                } else {
                                    result.set(NewConnectionProviderJhost.checkConnection((HostDetails)details, (AuthDetails)authDetails, (StringBuilder)info, (List)configs, (IConnectionUtilities2)new ConnectionUtilities(), (IHowIsGoing)PDUtils.convertIprogressToIHowIsGoing(monitor)));
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    PDLogger.get(this.getClass()).trace("Cancelled.", e);
                    info.append(MessageFormat.format(Messages.PDCommonConnectionProvider_5, details.getConnectionName()));
                    info.append("\n");
                    result.set(false);
                }
                catch (InvocationTargetException e) {
                    result.set(false);
                }
            }
        });
        if (!result.get()) {
            changePwd = "";
            ConnectionException connectionException = new ConnectionException(info.toString());
            StatusManager.getManager().handle((IStatus)new Status(4, "com.ibm.pdtools.common.component.core", Messages.PDCommonConnectionProvider_6, (Throwable)connectionException), 2);
            ConnectionUtilities.clearPassword(details.getHostID());
            throw connectionException;
        }
        if (!changePwd.isEmpty()) {
            changePwd = "";
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)workbench.getActiveWorkbenchWindow().getShell(), (String)"SUCCESS", (String)Messages.ChangeLoginPasswordDialog_PasswordChanged);
                }
            });
        }
        if ((listeners = PDToolsCommonServerClientJhost.getDefault().getListeners()) != null) {
            for (IPDToolsConnectionRequestListener aListener : listeners) {
                aListener.connect(this.getConfiguration().getID());
            }
        }
        if ((listeners2 = PDToolsCommonServerClientJhost.getDefault().getListeners2()) != null) {
            for (IPDToolsConnectionRequestListener2 aListener : listeners2) {
                aListener.connect(this.getConfiguration().getID(), configs);
            }
        }
        this.connected = true;
    }

    public void disconnect() throws ConnectionException {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorReference[] partRef = page.getEditorReferences();
                    String hostName = PDCommonConnectionProvider.this.getHost();
                    int port = PDCommonConnectionProvider.this.getPort();
                    String hostWithPort = hostName + "-" + port;
                    IEditorReference[] iEditorReferenceArray = partRef;
                    int n = partRef.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorReference part = iEditorReferenceArray[n2];
                        IEditorPart editorPart = part.getEditor(false);
                        String editorTitle = editorPart.getTitle();
                        int startIndex = editorTitle.indexOf("@");
                        int endIndex = editorTitle.indexOf(":", startIndex);
                        String editorHost = editorTitle.substring(startIndex + 1, endIndex);
                        if (editorPart.getClass().getName().contains("com.ibm.etools.fm.editor.formatted") && hostWithPort.equals(editorHost)) {
                            PDCommonConnectionProvider.this.disconnectCC = page.closeEditor(editorPart, true);
                            if (!PDCommonConnectionProvider.this.disconnectCC) break;
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    PDCommonConnectionProvider.this.disconnectCC = true;
                }
            }
        });
        if (!this.disconnectCC) {
            PDCommonConnectionProvider.doADFzConnect();
        } else {
            ArrayList listeners = PDToolsCommonServerClientJhost.getDefault().getListeners();
            if (listeners != null) {
                for (IPDToolsConnectionRequestListener aListener : listeners) {
                    aListener.disconnect(this.getConfiguration().getID());
                }
            }
            ArrayList listeners2 = PDToolsCommonServerClientJhost.getDefault().getListeners2();
            if (listeners != null) {
                for (IPDToolsConnectionRequestListener2 aListener : listeners2) {
                    aListener.disconnect(this.getConfiguration().getID());
                }
                this.connected = false;
            }
        }
    }

    public static void doADFzConnect() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewPart viewPart = page.findView(PDCommonConnectionProvider.HOST_CONNECTION_VIEW_ID);
                    if (viewPart == null) {
                        viewPart = page.showView(PDCommonConnectionProvider.HOST_CONNECTION_VIEW_ID);
                    }
                    if (viewPart != null) {
                        Method disconnectFld = viewPart.getClass().getDeclaredMethod("doConnect", null);
                        disconnectFld.setAccessible(true);
                        disconnectFld.invoke((Object)viewPart, null);
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean isConnected() {
        return this.connected;
    }
}

