/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.comms;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.connections.AbstractConnectionCustomizer;
import com.ibm.cics.core.connections.IConnectionCustomizerListener;
import com.ibm.pdtools.common.component.bidi.ui.BidiUI;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import java.text.MessageFormat;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PDCommonConnectionCustomizer
extends AbstractConnectionCustomizer {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static String[] layoutValues = new String[]{Messages.Connection_TEXT_LAYOUT_LOGICAL, Messages.Connection_TEXT_LAYOUT_VISUAL};
    private static String[] layoutValuesNonWindows = new String[]{Messages.Connection_TEXT_LAYOUT_LOGICAL};
    private static String[] directionValues = new String[]{Messages.Connection_TEXT_DIRECTION_LTR, Messages.Connection_TEXT_DIRECTION_RTL};
    private ConnectionConfiguration configuration = null;
    private Combo encodingCombo;
    private Combo textLayoutCombo;
    private Combo textDirectionCombo;

    public void createControl(Composite parent) {
        Composite composite = GUI.composite(parent, (Layout)GUI.grid.l.margins(2, false), GUI.grid.d.fillH(1));
        GUI.label.left(composite, Messages.Connection_ENCODING, GUI.grid.d.left1());
        this.encodingCombo = GUI.combo.editable(composite, GUI.grid.d.fillH(1));
        this.encodingCombo.setToolTipText(Messages.Connection_ENCODING_TIP);
        new ComboValueSaver(this.encodingCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "encoding");
        ComboValueSaver.getInstance(this.encodingCombo).setCustomItems(EncodingUtils.getDefaultEncodingValues(), false);
        this.encodingCombo.select(0);
        this.encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (IConnectionCustomizerListener listener : PDCommonConnectionCustomizer.this.getListeners()) {
                    listener.propertyChanged("keyDefaultEncoding", (Object)PDCommonConnectionCustomizer.this.encodingCombo.getText());
                }
                PDBiDiHelpers.enableBidiCombos(PDCommonConnectionCustomizer.this.encodingCombo.getText().toLowerCase(), PDCommonConnectionCustomizer.this.textLayoutCombo, PDCommonConnectionCustomizer.this.textDirectionCombo, false);
            }
        });
        GUI.label.left(composite, Messages.Connection_TEXT_LAYOUT, GUI.grid.d.left1());
        if (Util.isMac()) {
            this.textLayoutCombo = GUI.combo.readOnly(composite, GUI.grid.d.fillH(1), layoutValuesNonWindows);
            this.textLayoutCombo.setToolTipText(Messages.PDCommonConnectionCustomizer_MacBidiLimitationToolip);
        } else {
            this.textLayoutCombo = GUI.combo.readOnly(composite, GUI.grid.d.fillH(1), layoutValues);
            this.textLayoutCombo.setToolTipText(Messages.Connection_TEXT_LAYOUT_TIP);
        }
        this.textLayoutCombo.select(0);
        this.textLayoutCombo.setEnabled(false);
        GUI.label.left(composite, Messages.Connection_TEXT_DIRECTION, GUI.grid.d.left1());
        this.textDirectionCombo = GUI.combo.readOnly(composite, GUI.grid.d.fillH(1), directionValues);
        this.textDirectionCombo.setToolTipText(Messages.Connection_TEXT_DIRECTION_TIP);
        this.textDirectionCombo.select(0);
        this.textDirectionCombo.setEnabled(false);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String bidiFormat = PDBiDiHelpers.getBidiFormat(PDCommonConnectionCustomizer.this.textLayoutCombo.getText(), PDCommonConnectionCustomizer.this.textDirectionCombo.getText());
                for (IConnectionCustomizerListener listener : PDCommonConnectionCustomizer.this.getListeners()) {
                    listener.propertyChanged("keyBidiFormat", (Object)bidiFormat);
                }
            }
        };
        this.textLayoutCombo.addModifyListener(modifyListener);
        this.textDirectionCombo.addModifyListener(modifyListener);
        PDBiDiHelpers.enableBidiCombos(this.encodingCombo.getText().toLowerCase(), this.textLayoutCombo, this.textDirectionCombo, true);
    }

    public void updateCurrentConfiguration() {
        if (this.configuration != null) {
            String encodingValue = EncodingUtils.parseCodePage((String)this.encodingCombo.getText().trim());
            this.configuration.setExtendedAttribute("keyDefaultEncoding", encodingValue);
            ComboValueSaver.getInstance(this.encodingCombo).forceSaveCurrentValue();
            String bidiFormat = PDBiDiHelpers.getBidiFormat(this.textLayoutCombo.getText(), this.textDirectionCombo.getText());
            this.configuration.setExtendedAttribute("keyBidiFormat", bidiFormat);
        }
    }

    public void setConfiguration(ConnectionConfiguration configuration) {
        this.configuration = configuration;
        if (this.configuration == null) {
            return;
        }
        String value = configuration.getExtendedAttribute("keyDefaultEncoding");
        if (value != null && !this.encodingCombo.getText().equals(value)) {
            this.encodingCombo.setText(value);
        }
        String bidiFormat = configuration.getExtendedAttribute("keyBidiFormat");
        BidiUI.setCombo((Combo)this.textLayoutCombo, (Combo)this.textDirectionCombo, (String)bidiFormat);
    }

    public String validateEnteredData() {
        String encodingValue = EncodingUtils.parseCodePage((String)this.encodingCombo.getText().trim());
        if (EncodingUtils.isValidCodePage((String)encodingValue)) {
            return null;
        }
        return MessageFormat.format(Messages.Connection_INVALID_ENCODING, encodingValue);
    }

    public void clear() {
    }

    public void performDefaults() {
        this.encodingCombo.setText(HostType.getDefaultHostType().getDefaultEncoding());
    }

    @Deprecated
    public static boolean isEnableFmd() {
        return false;
    }
}

