/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.comms;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.PDTCCcore;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.DialogUtils;
import com.ibm.pdtools.common.component.jhost.PDToolsCommonServerClientJhost;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.AuthTokenExpiredException;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.ConnectionUtilitiesJhost;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.comms.IConnectionUtilities2;
import com.ibm.pdtools.common.component.jhost.comms.NewConnectionProviderJhost;
import com.ibm.pdtools.common.component.jhost.comms.NonBlockingSocketIOJhost;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.prefs.PDCommonPreferencePageJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.TimeUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;

public class NewConnectionProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int MAX_INITIAL_SERVER_RESPONSE_MSG_LEN = 65536;
    private static final PDLogger logger = PDLogger.get(NewConnectionProvider.class);

    public static NonBlockingSocketIOJhost newConnection(HostDetails hostDetails, String configName, Map<Object, String> options, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        if (configName == null) {
            throw new IllegalArgumentException("Must provide a non-null configName.");
        }
        Objects.requireNonNull(hostDetails, "Must provide a non-null hostDetails.");
        logger.debug("Connecting to " + hostDetails.getConnectionName() + ". CONFIG=" + configName);
        NonBlockingSocketIOJhost socketIO = null;
        String userName = "";
        try {
            AuthDetails login = ConnectionUtilities.getLogin(new TheHost(hostDetails), monitor);
            if (login == null) {
                throw new CommunicationException(Messages.CommunicationSecurityException_INVALID_CREDENTIALS);
            }
            userName = login.getUsername();
            String hostName = hostDetails.getHostname();
            boolean mfaEnabled = PDToolsCommonServerClientJhost.getAuthDetailsFetcher().mfaEnabled(userName, hostName);
            PDToolsCommonServerClientJhost.getAuthTokenManager().startHandshake(hostDetails, login.getUsername(), monitor);
            socketIO = new NonBlockingSocketIOJhost(hostDetails.getHostname(), hostDetails.getPortNumber(), hostDetails.getHostType(), hostDetails.getCommunicationCodePage(), monitor);
            Map<String, String> serverProps = NewConnectionProvider.parseServerResponse(socketIO, hostDetails, monitor);
            hostDetails.setServerProperties(serverProps);
            NewConnectionProvider.checkProtocolVersion(hostDetails, null);
            if (hostDetails.isSecured()) {
                Calendar beforeFirstHandshake = Calendar.getInstance();
                socketIO.doHandshake(hostDetails);
                if (PDLogger.isTraceEnabled()) {
                    Calendar afterFirstHandshake = Calendar.getInstance();
                    logger.trace(new Object[]{"Time for first handshake: ", TimeUtils.formatDifference((Calendar)beforeFirstHandshake, (Calendar)afterFirstHandshake)});
                }
            }
            String auth = "config=" + configName;
            if (options != null && options.size() > 0) {
                for (Map.Entry<Object, String> entry : options.entrySet()) {
                    auth = auth + " " + String.valueOf(entry.getKey()) + "=" + entry.getValue();
                }
            }
            logger.debug("Connecting for user=" + login.getUsername() + ": " + auth);
            auth = PDTCCcore.getDefault().getPreferenceStore().getBoolean("ipv.debug") ? auth + " DEBUG=YES" : auth + " DEBUG=NO";
            if (serverProps.containsKey("PASSTK") && serverProps.get("PASSTK").equals("YES")) {
                PDToolsCommonServerClientJhost.getAuthTokenManager().setConnectionIdUsingTokens(hostDetails.getHostname(), Integer.valueOf(hostDetails.getPortNumber()));
                if (PDToolsCommonServerClientJhost.getAuthTokenManager().hasAuthToken(hostDetails, login.getUsername(), monitor)) {
                    login.setPassToken(PDToolsCommonServerClientJhost.getAuthTokenManager().getAuthToken(hostDetails, login.getUsername(), monitor));
                }
            }
            if (login.getPassToken() == null) {
                if (serverProps.containsKey("PASSTK") && serverProps.get("PASSTK").equals("YES")) {
                    auth = auth + " PASSTK=YES";
                }
                if (mfaEnabled) {
                    PDToolsCommonServerClientJhost.getAuthDetailsFetcher().invokeLoginDialog(login);
                }
                auth = "user=" + login.getUsername() + " pass=" + NewConnectionProvider.passwordOrPassphrase(login.getPassword()) + " " + auth;
            } else {
                auth = auth + " PASSTK=" + login.getPassToken();
            }
            if (hostDetails.isUsingATTLS()) {
                auth = auth + " CLNTVER=2 ";
            }
            ByteBuffer buf = ByteBuffer.allocate(4 + auth.length());
            buf.putInt(auth.length());
            buf.put(auth.getBytes(ConnectionUtilitiesJhost.getEncoding((HostDetails)hostDetails)));
            socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
            Map<String, String> authResultsProps = null;
            try {
                authResultsProps = NewConnectionProvider.parseServerResponse(socketIO, hostDetails, monitor);
            }
            catch (AuthTokenExpiredException e) {
                socketIO.close();
                PDToolsCommonServerClientJhost.getAuthTokenManager().removeAuthToken(hostDetails, login.getUsername());
                PDToolsCommonServerClientJhost.getAuthDetailsFetcher().clearPassword(hostDetails.getHostID());
                throw new CommunicationException(Messages.AuthenticationTokenExpired);
            }
            String authStatus = authResultsProps.get("AUTH");
            if (!"Y".equals(authStatus)) {
                String err = authResultsProps.get("ERROR");
                if (err == null) {
                    String errMsg = MessageFormat.format(Messages.Connection_UnknownErr, login.getUsername());
                    DialogUtils.openErrorThreadSafe(Messages.ERROR_TITLE, errMsg);
                    throw new CommunicationException(errMsg);
                }
                if ("'INVALID PASSWORD'".equals(err)) {
                    String errMsg = MessageFormat.format(Messages.Connection_InvalidPassword, login.getUsername());
                    PDToolsCommonServerClientJhost.getAuthDetailsFetcher().setMFAFailureHostDetails(hostDetails.getHostID() + ":" + login.getUsername());
                    DialogUtils.openErrorThreadSafe(Messages.ERROR_TITLE, errMsg);
                    ConnectionUtilities.clearPassword(hostDetails.getHostID());
                    throw new CommunicationException(errMsg);
                }
                if ("'EXPIRED PASSWORD'".equals(err)) {
                    NonBlockingSocketIOJhost nonBlockingSocketIOJhost = NewConnectionProvider.newConnectionChangePasswordFirst(hostDetails, configName, options, login.getPassword(), monitor);
                    return nonBlockingSocketIOJhost;
                }
                if ("'UNKNOWN USER'".equals(err)) {
                    String errMsg = MessageFormat.format(Messages.Connection_UnknownUserErr, login.getUsername());
                    DialogUtils.openErrorThreadSafe(Messages.ERROR_TITLE, errMsg);
                    throw new CommunicationException(errMsg);
                }
                String errMsg = MessageFormat.format(Messages.Connection_OtherErr, login.getUsername(), configName, err);
                PDToolsCommonServerClientJhost.getAuthDetailsFetcher().setMFAFailureHostDetails(hostDetails.getHostID() + ":" + login.getUsername());
                DialogUtils.openErrorThreadSafe(Messages.ERROR_TITLE, errMsg);
                ConnectionUtilities.clearPassword(hostDetails.getHostID());
                throw new CommunicationException(errMsg);
            }
            PDToolsCommonServerClientJhost.getAuthDetailsFetcher().setMFAFailureHostDetails(null);
            if (authResultsProps.containsKey("PASSTK")) {
                login.setPassToken(authResultsProps.get("PASSTK"));
                PDToolsCommonServerClientJhost.getAuthTokenManager().setAuthToken(hostDetails, login.getUsername(), login.getPassToken());
            }
            if (hostDetails.getHostType() == HostType.ZOS && !hostDetails.isUsingATTLS()) {
                if (hostDetails.isSecured()) {
                    logger.debug("Hand-shaking with the spawned address space.");
                    Calendar beforeFirstHandshake = Calendar.getInstance();
                    socketIO.doHandshake(hostDetails);
                    if (PDLogger.isTraceEnabled()) {
                        Calendar afterFirstHandshake = Calendar.getInstance();
                        logger.trace(new Object[]{"Time for Second handshake: ", TimeUtils.formatDifference((Calendar)beforeFirstHandshake, (Calendar)afterFirstHandshake)});
                    }
                }
            } else {
                logger.trace("Skipping second handshake as AT-TLS is in use.");
            }
            NonBlockingSocketIOJhost nonBlockingSocketIOJhost = socketIO;
            return nonBlockingSocketIOJhost;
        }
        catch (CommunicationException | InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
        finally {
            PDToolsCommonServerClientJhost.getAuthTokenManager().endHandshake(hostDetails, userName);
        }
    }

    @Deprecated
    public static void checkConnection(HostDetails hostDetails, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(hostDetails, "Must specify a non-null hostDetails.");
        ArrayList extensions = new ArrayList();
        StringBuilder result = new StringBuilder();
        if (NewConnectionProviderJhost.checkConnection((HostDetails)hostDetails, null, (StringBuilder)result, extensions, (IConnectionUtilities2)new ConnectionUtilities(), (IHowIsGoing)monitor)) {
            DialogUtils.openInfoThreadSafe(Messages.INFO_TITLE, Messages.NewConnectionProvider_0, result.toString());
        } else {
            DialogUtils.openErrorThreadSafe(Messages.ERROR_TITLE, Messages.NewConnectionProvider_1, result.toString());
        }
    }

    public static Result<StringBuilder> checkConnection2(HostDetails hostDetails, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(hostDetails, "Must specify a non-null hostDetails.");
        ArrayList extensions = new ArrayList();
        StringBuilder out = new StringBuilder();
        boolean isOk = NewConnectionProviderJhost.checkConnection((HostDetails)hostDetails, null, (StringBuilder)out, extensions, (IConnectionUtilities2)new ConnectionUtilities(), (IHowIsGoing)monitor);
        Result resultt = new Result();
        if (isOk) {
            resultt.setRC(0);
            resultt.add(Messages.NewConnectionProvider_0);
        } else {
            resultt.setRC(8);
            resultt.add(Messages.NewConnectionProvider_1);
        }
        resultt.setOutput((Object)out);
        return resultt;
    }

    private static void checkCancel(NonBlockingSocketIOJhost socketIO, IHowIsGoing monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            if (socketIO != null) {
                socketIO.closeConnection();
            }
            throw new InterruptedException();
        }
    }

    private static void parseServerExtensionInfo(String extensionsStr, List<String> extensions) {
        StringTokenizer st = new StringTokenizer(extensionsStr, "\n");
        st.nextToken();
        while (st.hasMoreTokens()) {
            String aConfig = st.nextToken();
            String extName = aConfig.substring(aConfig.indexOf(61) + 1);
            extensions.add(extName);
        }
    }

    private static String dumpException(Exception exception) {
        StringWriter writer = new StringWriter();
        writer.write(MessageFormat.format(Messages.NewConnectionProvider_41, exception.getMessage()));
        writer.write(System.lineSeparator());
        exception.printStackTrace(new PrintWriter(writer));
        return writer.getBuffer().toString() + "\n";
    }

    private static NonBlockingSocketIOJhost newConnectionChangePasswordFirst(HostDetails hostDetails, String configName, Map<Object, String> options, String oldPassword, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        if (configName == null) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(hostDetails, "Must provide a non-null hostDetails.");
        logger.debug("Connecting to " + hostDetails.getConnectionName() + " and want to change password first. CONFIG=" + configName);
        NonBlockingSocketIOJhost socketIO = null;
        try {
            AuthDetails login = ConnectionUtilities.getLogin(new TheHost(hostDetails), monitor);
            if (login == null) {
                throw new CommunicationException(Messages.CommunicationSecurityException_INVALID_CREDENTIALS);
            }
            String newPassword = ConnectionUtilities.changeAndReturnNewPwd(hostDetails.getHostID(), oldPassword, login.getUsername());
            if (newPassword == null) {
                throw new CommunicationException(Messages.Connection_ChangePasswordCancelled);
            }
            socketIO = new NonBlockingSocketIOJhost(hostDetails.getHostname(), hostDetails.getPortNumber(), hostDetails.getHostType(), hostDetails.getCommunicationCodePage(), monitor);
            Map<String, String> serverProps = NewConnectionProvider.parseServerResponse(socketIO, hostDetails, monitor);
            hostDetails.setServerProperties(serverProps);
            NewConnectionProvider.checkProtocolVersion(hostDetails, null);
            if (hostDetails.isSecured()) {
                Calendar beforeFirstHandshake = Calendar.getInstance();
                socketIO.doHandshake(hostDetails);
                if (PDLogger.isTraceEnabled()) {
                    Calendar afterFirstHandshake = Calendar.getInstance();
                    logger.trace(new Object[]{"Time for first handshake while changing password: ", TimeUtils.formatDifference((Calendar)beforeFirstHandshake, (Calendar)afterFirstHandshake)});
                }
            }
            String auth = "config=" + configName;
            if (options != null && options.size() > 0) {
                for (Map.Entry<Object, String> entry : options.entrySet()) {
                    auth = auth + " " + String.valueOf(entry.getKey()) + "=" + entry.getValue();
                }
            }
            logger.debug("Connecting and changing password for user=" + login.getUsername() + ": " + auth);
            auth = PDCommonPreferencePageJhost.getDebugMode() ? auth + " DEBUG=YES" : auth + " DEBUG=NO";
            if (serverProps.containsKey("PASSTK") && serverProps.get("PASSTK").equals("YES")) {
                PDToolsCommonServerClientJhost.getAuthTokenManager().setConnectionIdUsingTokens(hostDetails.getHostname(), Integer.valueOf(hostDetails.getPortNumber()));
                if (PDToolsCommonServerClientJhost.getAuthTokenManager().hasAuthToken(hostDetails, login.getUsername(), monitor)) {
                    login.setPassToken(PDToolsCommonServerClientJhost.getAuthTokenManager().getAuthToken(hostDetails, login.getUsername(), monitor));
                }
            }
            if (login.getPassToken() == null) {
                if (serverProps.containsKey("PASSTK")) {
                    auth = auth + " PASSTK=YES";
                }
                auth = !newPassword.isEmpty() ? "user=" + login.getUsername() + " pass=" + NewConnectionProvider.passwordOrPassphrase(login.getPassword()) + " " + auth + " NEWPASS=" + NewConnectionProvider.passwordOrPassphrase(newPassword) : "user=" + login.getUsername() + " pass=" + NewConnectionProvider.passwordOrPassphrase(login.getPassword()) + " " + auth;
            } else {
                auth = !newPassword.isEmpty() ? auth + " PASSTK=" + login.getPassToken() + " NEWPASS=" + NewConnectionProvider.passwordOrPassphrase(newPassword) : auth + " PASSTK=" + login.getPassToken();
            }
            if (hostDetails.isUsingATTLS()) {
                auth = auth + " CLNTVER=2 ";
            }
            ByteBuffer buf = ByteBuffer.allocate(4 + auth.length());
            buf.putInt(auth.length());
            buf.put(auth.getBytes(ConnectionUtilitiesJhost.getEncoding((HostDetails)hostDetails)));
            socketIO.writeBytes(buf.array(), 0, buf.position(), monitor);
            Map<String, String> authResultsProps = NewConnectionProvider.parseServerResponse(socketIO, hostDetails, monitor);
            String authStatus = authResultsProps.get("AUTH");
            if (!"Y".equals(authStatus)) {
                PDToolsCommonServerClientJhost.getAuthTokenManager().endHandshake(hostDetails, login.getUsername());
                String err = authResultsProps.get("ERROR");
                if (err == null) {
                    String errMsg = MessageFormat.format(Messages.Connection_UnknownErr_whileChangePassword, login.getUsername());
                    if (DialogUtils.openQuestionThreadSafe(errMsg)) {
                        logger.error("Failed to change password with unknown error. Trying again.");
                        return NewConnectionProvider.newConnectionChangePasswordFirst(hostDetails, configName, options, oldPassword, monitor);
                    }
                    logger.error("Failed to change password with unknown error. Quit.");
                    throw new CommunicationException(errMsg);
                }
                if ("'NEW PASSWORD INVALID'".equals(err)) {
                    logger.error("New password is invalid. Trying again.");
                    DialogUtils.openErrorThreadSafe(Messages.ERROR_TITLE, Messages.Connection_InvalidNewPassword);
                    return NewConnectionProvider.newConnectionChangePasswordFirst(hostDetails, configName, options, oldPassword, monitor);
                }
                String errMsg = MessageFormat.format(Messages.Connection_OtherErr_whileChangePassword, login.getUsername(), err);
                if (DialogUtils.openQuestionThreadSafe(errMsg)) {
                    logger.error("Failed to change password. Trying again. Msg: " + err);
                    return NewConnectionProvider.newConnectionChangePasswordFirst(hostDetails, configName, options, oldPassword, monitor);
                }
                logger.error("Failed to change password. Quit. Msg: " + err);
                throw new CommunicationException(errMsg);
            }
            logger.debug("Managed to change password.");
            if (hostDetails.isSecured() && !hostDetails.isUsingATTLS()) {
                logger.debug("Hand-shaking with the spawned address space.");
                Calendar beforeFirstHandshake = Calendar.getInstance();
                socketIO.doHandshake(hostDetails);
                if (PDLogger.isTraceEnabled()) {
                    Calendar afterFirstHandshake = Calendar.getInstance();
                    logger.trace(new Object[]{"Time for Second handshake: ", TimeUtils.formatDifference((Calendar)beforeFirstHandshake, (Calendar)afterFirstHandshake)});
                }
            } else {
                logger.trace("Skipping second handshake as AT-TLS is in use.");
            }
            ConnectionUtilities.clearPassword(hostDetails.getHostID());
            return socketIO;
        }
        catch (CommunicationException | InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    private static String passwordOrPassphrase(String aPassword) {
        if (aPassword == null || aPassword.length() <= 8) {
            return aPassword;
        }
        return "'" + aPassword + "'";
    }

    private static void checkProtocolVersion(HostDetails hostDetails, StringBuilder infoBuffer) throws CommunicationException {
        String serverProtocolVersion = (String)hostDetails.getServerProperties().get("SERVERVERSION");
        try {
            int major = Integer.parseInt(serverProtocolVersion.substring(0, serverProtocolVersion.indexOf(46)));
            int minor = Integer.parseInt(serverProtocolVersion.substring(serverProtocolVersion.indexOf(46) + 1));
            if (major == 1) {
                if (minor == 3) {
                    if (infoBuffer != null) {
                        infoBuffer.append(Messages.NewConnectionProvider_44 + "\n");
                        return;
                    }
                    return;
                }
                if (minor < 3) {
                    String msg = MessageFormat.format(Messages.Connection_ServerUseOlderProtocol, "V1.6", "PM67623");
                    logger.debug(msg);
                    if (infoBuffer != null) {
                        infoBuffer.append(msg + "\n");
                        return;
                    }
                    if (PDCommonPreferencePageJhost.isReportingVersionIncompatibleProblems()) {
                        boolean warnIncompatibility = DialogUtils.openWarningWithToggleThreadSafe(Messages.NewConnectionProvider_WARNING, msg, Messages.PDCommonPreferencePage_REPORT_VER_ERR, PDCommonPreferencePageJhost.isReportingVersionIncompatibleProblems());
                        PDCommonPreferencePageJhost.setReportVersionIncompatibleProblems((boolean)warnIncompatibility);
                    }
                    return;
                }
                String msg = Messages.Connection_ServerUseNewerProtocol;
                logger.debug(msg);
                if (infoBuffer != null) {
                    infoBuffer.append(msg + "\n");
                    return;
                }
                if (PDCommonPreferencePageJhost.isReportingVersionIncompatibleProblems()) {
                    boolean warnIncompatibility = DialogUtils.openWarningWithToggleThreadSafe(Messages.NewConnectionProvider_WARNING, msg, Messages.PDCommonPreferencePage_REPORT_VER_ERR, PDCommonPreferencePageJhost.isReportingVersionIncompatibleProblems());
                    PDCommonPreferencePageJhost.setReportVersionIncompatibleProblems((boolean)warnIncompatibility);
                }
                return;
            }
            String errMsg = MessageFormat.format(Messages.Connection_IncompatibleProtocol, "V1.6", "PM67623");
            logger.debug(errMsg);
            if (infoBuffer != null) {
                infoBuffer.append(errMsg + "\n");
                return;
            }
            DialogUtils.openErrorThreadSafe(Messages.ERROR_TITLE, errMsg);
            throw new CommunicationException(errMsg);
        }
        catch (CommunicationException ce) {
            throw ce;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.Connection_UnknwonServerProtocol, "V1.6", "PM67623");
            logger.error(errMsg);
            if (infoBuffer != null) {
                infoBuffer.append(errMsg + "\n");
                return;
            }
            DialogUtils.openErrorThreadSafe(Messages.ERROR_TITLE, errMsg);
            throw new CommunicationException(errMsg);
        }
    }

    private static boolean supportDetailedDiagnosis(HostDetails hostDetails) throws CommunicationException {
        String serverProtocolVersion = (String)hostDetails.getServerProperties().get("SERVERVERSION");
        try {
            int major = Integer.parseInt(serverProtocolVersion.substring(0, serverProtocolVersion.indexOf(46)));
            int minor = Integer.parseInt(serverProtocolVersion.substring(serverProtocolVersion.indexOf(46) + 1));
            return major >= 1 && minor >= 3;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, String> parseServerResponse(NonBlockingSocketIOJhost socketIO, HostDetails hostDetails, IHowIsGoing monitor) throws CommunicationException, InterruptedException, AuthTokenExpiredException, IOException {
        responses = new HashMap<String, String>();
        responseLength = socketIO.readUnsignedInt(monitor);
        if (responseLength == -1 || responseLength > 65536) {
            msg = "Invalid message length from server of " + responseLength + " - client may not be talking to the Common Server; perhaps a third party is intercepting the connection?";
            NewConnectionProvider.logger.error(msg);
            throw new CommunicationException(Messages.Connection_InvalidResponseLengthFromHost + " " + msg);
        }
        data = new byte[responseLength];
        socketIO.readBytes(data, responseLength, monitor);
        serverResponse = new String(data, hostDetails.getHostType().getCommunicationEncoding());
        st = new StringTokenizer(serverResponse, ",");
        if (!"PASSTK token invalid or expired".equals(serverResponse.trim())) ** GOTO lbl22
        throw new AuthTokenExpiredException();
lbl-1000:
        // 1 sources

        {
            keyValuePair = st.nextToken();
            equalindex = keyValuePair.indexOf(61);
            if (equalindex == -1) {
                throw new CommunicationException(MessageFormat.format(Messages.Connection_InvalidResponseDataFromHost, new Object[]{serverResponse}));
            }
            key = keyValuePair.substring(0, equalindex).trim();
            value = keyValuePair.substring(equalindex + 1).trim();
            responses.put(key, value);
lbl22:
            // 2 sources

            ** while (st.hasMoreTokens())
        }
lbl23:
        // 1 sources

        return responses;
    }
}

