/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.comms;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.base.PDTCCcoreBase;
import com.ibm.pdtools.common.component.core.comms.AuthenticationFrameworkUtilities;
import com.ibm.pdtools.common.component.core.comms.ChangeLoginPasswordDialog;
import com.ibm.pdtools.common.component.core.comms.NewConnectionProvider;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.IConnectionUtilities2;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionChangeListener;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionRequestListener;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionRequestListener2;
import com.ibm.pdtools.common.component.jhost.comms.NonBlockingSocketIOJhost;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ConnectionUtilities
implements IConnectionUtilities2 {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String CONNECTION_CATEGORY_ID = "com.ibm.pdtools.comms.cics.category";
    private static final Map<String, CountDownLatch> activeLoginDialogs = Collections.synchronizedMap(new HashMap());

    public static Collection<HostDetails> getSystemInformation() {
        return AuthenticationFrameworkUtilities.getSystemInformation(CONNECTION_CATEGORY_ID);
    }

    public static HostDetails getConnection(String rdzDesc, String hostName, int portNumber, String userName, String password) {
        Objects.requireNonNull(userName, "Must provide a non-null userName.");
        Objects.requireNonNull(password, "Must provide a non-null password.");
        return AuthenticationFrameworkUtilities.getSystemInformation(CONNECTION_CATEGORY_ID, "com.ibm.pdtools.comms.cics.connection", rdzDesc, hostName, portNumber, userName, password);
    }

    public static void openDialogForNewConnection() {
        AuthenticationFrameworkUtilities.openDialogForNewConnection("com.ibm.pdtools.comms.cics.connection");
    }

    public static void openDialogForEditConnection(String hostID) {
        AuthenticationFrameworkUtilities.openDialogForModifyConnection(hostID, CONNECTION_CATEGORY_ID, "com.ibm.pdtools.comms.cics.connection");
    }

    public static void deleteConnection(String hostID) {
        if (!ConnectionUtilities.canDelete(hostID)) {
            return;
        }
        AuthenticationFrameworkUtilities.deleteConnection(hostID, PDTCCcoreBase.isEclipseV3() ? "com.ibm.pdtools.comms.cics.connection" : CONNECTION_CATEGORY_ID);
    }

    public static boolean canDelete(String hostID) {
        return AuthenticationFrameworkUtilities.canDelete(hostID, CONNECTION_CATEGORY_ID);
    }

    public static synchronized NonBlockingSocketIOJhost newConnection(HostDetails hostDetails, String configName, Map<Object, String> options, IHowIsGoing monitor) throws CommunicationException, InterruptedException {
        return NewConnectionProvider.newConnection(hostDetails, configName, options, monitor);
    }

    @Deprecated
    public static synchronized void checkConnection(HostDetails hostDetails, IHowIsGoing monitor) throws InterruptedException {
        NewConnectionProvider.checkConnection(hostDetails, monitor);
    }

    public static synchronized Result<StringBuilder> checkConnection2(HostDetails hostDetails, IHowIsGoing monitor) throws InterruptedException {
        return NewConnectionProvider.checkConnection2(hostDetails, monitor);
    }

    private static void awaitLatchWithoutBlockingUi(CountDownLatch latch, Display display, IHowIsGoing monitor) throws InterruptedException {
        if (display.getThread() == Thread.currentThread()) {
            while (!latch.await(1L, TimeUnit.MILLISECONDS)) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new InterruptedException(Messages.ConnectionUtilities_CancelledWhileWaitingForLoginDetails);
                }
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        } else {
            latch.await();
        }
    }

    @Deprecated
    public static AuthDetails getLogin(String host) throws InterruptedException {
        return ConnectionUtilities.getLogin(new TheHost(host, host), null);
    }

    @Deprecated
    public static AuthDetails getLogin(TheHost theHost) throws InterruptedException {
        return ConnectionUtilities.getLogin(theHost, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthDetails getLogin(final TheHost theHost, IHowIsGoing monitor) throws InterruptedException {
        CountDownLatch loginWaiter;
        Objects.requireNonNull(theHost, "Please provide a non-null TheHost.");
        final AtomicReference<Object> refToLogin = new AtomicReference<Object>(null);
        Map<String, CountDownLatch> map = activeLoginDialogs;
        synchronized (map) {
            loginWaiter = activeLoginDialogs.get(theHost.getConnectionName());
            if (loginWaiter == null) {
                activeLoginDialogs.put(theHost.getConnectionName(), new CountDownLatch(1));
            } else {
                refToLogin.set(AuthenticationFrameworkUtilities.getUserNameAndPassword(theHost, CONNECTION_CATEGORY_ID, true));
            }
        }
        Display display = Display.getDefault();
        if (loginWaiter == null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    refToLogin.set(AuthenticationFrameworkUtilities.getUserNameAndPasswordDialogIfRequired(theHost, ConnectionUtilities.CONNECTION_CATEGORY_ID));
                }
            });
            activeLoginDialogs.remove(theHost.getConnectionName()).countDown();
        }
        if (refToLogin.get() == null || ((AuthDetails)refToLogin.get()).getPassword() == null) {
            throw new InterruptedException(Messages.CommHost_NO_LOGIN_DETAILS_PROVIDED);
        }
        return refToLogin.get();
    }

    @Deprecated
    public static AuthDetails hasLogin(TheHost theHost) throws InterruptedException {
        return ConnectionUtilities.hasLogin(theHost, null);
    }

    public static AuthDetails hasLogin(final TheHost theHost, IHowIsGoing monitor) throws InterruptedException {
        final AtomicReference<Object> refToLogin = new AtomicReference<Object>(null);
        CountDownLatch loginWaiter = activeLoginDialogs.get(theHost.getConnectionName());
        Display display = Display.getDefault();
        if (loginWaiter != null) {
            ConnectionUtilities.awaitLatchWithoutBlockingUi(loginWaiter, display, monitor);
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                refToLogin.set(AuthenticationFrameworkUtilities.getUserNameAndPassword(theHost, ConnectionUtilities.CONNECTION_CATEGORY_ID, true));
            }
        });
        return refToLogin.get();
    }

    @Deprecated
    public static AuthDetails hasLogin(String hostID) throws InterruptedException {
        for (HostDetails hd : ConnectionUtilities.getSystemInformation()) {
            if (!hd.getHostID().equals(hostID)) continue;
            return ConnectionUtilities.hasLogin(new TheHost(hd), null);
        }
        return null;
    }

    public static boolean clearPassword(final String hostID) {
        final AtomicBoolean result = new AtomicBoolean(false);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result.set(PDTCCcoreBase.isEclipseV3() ? AuthenticationFrameworkUtilities.clearPassword(ConnectionUtilities.CONNECTION_CATEGORY_ID, "com.ibm.pdtools.comms.cics.connection", hostID) : AuthenticationFrameworkUtilities.clearPassword(ConnectionUtilities.CONNECTION_CATEGORY_ID, hostID));
            }
        });
        return result.get();
    }

    public static boolean setPassword(final String hostID, final String newPassword) {
        final AtomicBoolean result = new AtomicBoolean(false);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result.set(AuthenticationFrameworkUtilities.setPassword(newPassword, ConnectionUtilities.CONNECTION_CATEGORY_ID, "com.ibm.pdtools.comms.cics.connection", hostID));
            }
        });
        return result.get();
    }

    public static boolean invokeChangePasswordDialog(final String hostID) {
        final AtomicBoolean executed = new AtomicBoolean(false);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                executed.set(AuthenticationFrameworkUtilities.invokeChangePasswordDialog(ConnectionUtilities.CONNECTION_CATEGORY_ID, "com.ibm.pdtools.comms.cics.connection", hostID));
            }
        });
        return executed.get();
    }

    public static void addPDConnectionChangeListener(IPDToolsConnectionChangeListener listener) {
        AuthenticationFrameworkUtilities.addPDConnectionChangeListener(listener, CONNECTION_CATEGORY_ID);
    }

    @Deprecated
    public static void addPDConnectionRequestListener(IPDToolsConnectionRequestListener aListener) {
        AuthenticationFrameworkUtilities.addPDConnectionRequestListener(aListener);
    }

    public static void addPDConnectionRequestListener2(IPDToolsConnectionRequestListener2 aListener) {
        AuthenticationFrameworkUtilities.addPDConnectionRequestListener2(aListener);
    }

    public static boolean connectionExists(String hostID) {
        return AuthenticationFrameworkUtilities.connectionExists(hostID, CONNECTION_CATEGORY_ID);
    }

    public static HostDetails getHostDetails(String hostID) {
        return AuthenticationFrameworkUtilities.getHostDetails(hostID, CONNECTION_CATEGORY_ID);
    }

    public AuthDetails getLoginCall(TheHost theHost, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(theHost, "Please provide a non-null TheHost.");
        return ConnectionUtilities.getLogin(theHost, monitor);
    }

    @Deprecated
    public AuthDetails getLoginCall(TheHost theHost) throws InterruptedException {
        Objects.requireNonNull(theHost, "Please provide a non-null TheHost.");
        return ConnectionUtilities.getLogin(theHost, null);
    }

    public boolean clearPasswordCall(String hostID) {
        return ConnectionUtilities.clearPassword(hostID);
    }

    public static String changeAndReturnNewPwd(final String hostID, final String oldPassword, final String userName) {
        final AtomicReference<Object> newPass = new AtomicReference<Object>(null);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ChangeLoginPasswordDialog loginPwdDialog = new ChangeLoginPasswordDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), userName, oldPassword);
                loginPwdDialog.setPasswordExpiryTitle(true);
                if (loginPwdDialog.open() == 1) {
                    ConnectionUtilities.setPassword(hostID, oldPassword);
                }
                newPass.set(loginPwdDialog.getNewPassword());
            }
        });
        String newPassword = newPass.get();
        return newPassword;
    }
}

