/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.comms;

import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.util.GUI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChangeLoginPasswordDialog
extends TitleAreaDialog
implements ModifyListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private Text userIDText;
    private Text currentPasswordText;
    private Text newPasswordText;
    private Text confirmPasswordText;
    private String userId;
    private String currentPassword;
    private String newPassword;
    public static final String NEWPASS = "NEWPASSWORD";
    public static final String CONFIRMPASS = "CONFIRMPASSWORD";
    private boolean passwordExpiryTitle = false;

    public ChangeLoginPasswordDialog(Shell parentShell, String userId, String currentPassword) {
        super(parentShell);
        this.userId = userId;
        this.currentPassword = currentPassword;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ConnectionsImages.getImage((String)"PASSWORD_WIZ_BAN"));
        this.getShell().setText(Messages.ChangeLoginPasswordDialog_Title);
        this.setTitle(Messages.ChangeLoginPasswordDialog_Title);
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(1808);
        childArea.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginRight = 20;
        gridLayout.marginLeft = 20;
        childArea.setLayout((Layout)gridLayout);
        GUI.label.left(childArea, Messages.ChangeLoginPasswordDialog_UserID, GUI.grid.d.left1());
        this.userIDText = GUI.text.field(childArea, GUI.grid.d.fillH(1));
        this.userIDText.setText(this.userId);
        this.userIDText.setEnabled(false);
        GUI.label.left(childArea, Messages.ChangeLoginPasswordDialog_ExistingPassword, GUI.grid.d.left1());
        this.currentPasswordText = GUI.text(childArea, GUI.grid.d.fillH(1), 0x400800);
        this.currentPasswordText.setText(this.currentPassword);
        this.currentPasswordText.setEnabled(false);
        GUI.label.left(childArea, Messages.ChangeLoginPasswordDialog_NewPassword, GUI.grid.d.left1());
        this.newPasswordText = GUI.text(childArea, GUI.grid.d.fillH(1), 0x400800);
        this.newPasswordText.setData((Object)NEWPASS);
        this.newPasswordText.addModifyListener((ModifyListener)this);
        GUI.label.left(childArea, Messages.ChangeLoginPasswordDialog_ConfirmPassword, GUI.grid.d.left1());
        this.confirmPasswordText = GUI.text(childArea, GUI.grid.d.fillH(1), 0x400800);
        this.confirmPasswordText.setData((Object)CONFIRMPASS);
        this.confirmPasswordText.addModifyListener((ModifyListener)this);
        if (this.passwordExpiryTitle) {
            super.setErrorMessage(Messages.ChangeLoginPasswordDialog_PasswordExpiryMsg);
        } else {
            super.setErrorMessage(null);
        }
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        this.userId = this.userIDText.getText().trim();
        this.currentPassword = this.currentPasswordText.getText();
        this.newPassword = this.newPasswordText.getText();
        String confirmPassword = this.confirmPasswordText.getText();
        if (!this.newPassword.equals(confirmPassword)) {
            this.setErrorMessage(Messages.ChangeLoginPasswordDialog_ConfirmPasswordMismatch);
            return;
        }
        this.setErrorMessage(null);
        super.okPressed();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public void modifyText(ModifyEvent event) {
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
        Text text2 = (Text)event.widget;
        if (text2.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.ChangeLoginPasswordDialog_BlankField);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (text2.getData().equals(NEWPASS) && text2.getText().trim().equals(this.currentPasswordText.getText())) {
            this.setErrorMessage(Messages.ChangeLoginPasswordDialog_ExistingPasswordMatch);
            this.getButton(0).setEnabled(false);
            return;
        }
        if (text2.getData().equals(CONFIRMPASS) && !text2.getText().trim().equals(this.newPasswordText.getText())) {
            this.setErrorMessage(Messages.ChangeLoginPasswordDialog_ConfirmPasswordMismatch);
            this.getButton(0).setEnabled(false);
            return;
        }
    }

    public void setPasswordExpiryTitle(boolean passwordExpiryTitle) {
        this.passwordExpiryTitle = passwordExpiryTitle;
    }
}

