/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.comms;

import com.ibm.pdtools.common.component.core.base.auth.AuthenticationFrameworkUtilitiesImp;
import com.ibm.pdtools.common.component.core.comms.PDCommonConnectionProvider;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.PDToolsCommonServerClientJhost;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionChangeListener;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionRequestListener;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionRequestListener2;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;

public class AuthenticationFrameworkUtilities {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static Collection<HostDetails> getSystemInformation(String connCategory) {
        return AuthenticationFrameworkUtilitiesImp.getSystemInformation((String)connCategory, (String)"keyDefaultEncoding", (String)"hostType", (String)"keyBidiFormat");
    }

    public static HostDetails getSystemInformation(String connCategory, String connID, String rdzDesc, String hostName, int portNumber, String userName, String password) {
        return AuthenticationFrameworkUtilitiesImp.getSystemInformation((String)connCategory, (String)connID, (String)rdzDesc, (String)hostName, (int)portNumber, (String)userName, (String)password, (String)"keyDefaultEncoding", (String)"hostType");
    }

    public static boolean clearPassword(String connCategory, String hostID) {
        return AuthenticationFrameworkUtilitiesImp.clearPassword((String)connCategory, (String)hostID);
    }

    public static boolean clearPassword(String connCategory, String connID, String hostID) {
        return AuthenticationFrameworkUtilitiesImp.clearPassword((String)connCategory, (String)connID, (String)hostID);
    }

    public static boolean setPassword(String newPassword, String connCategory, String connID, String hostID) {
        return AuthenticationFrameworkUtilitiesImp.setPassword((String)newPassword, (String)connCategory, (String)connID, (String)hostID);
    }

    public static boolean invokeChangePasswordDialog(String connCategory, String connID, String hostID) {
        return AuthenticationFrameworkUtilitiesImp.invokeChangePasswordDialog((String)connCategory, (String)connID, (String)hostID);
    }

    public static HostDetails getHostDetails(String hostID, String connCategory) {
        return AuthenticationFrameworkUtilitiesImp.getHostDetails((String)hostID, (String)connCategory, (String)"keyDefaultEncoding", (String)"hostType", (String)"keyBidiFormat");
    }

    public static void openDialogForNewConnection(String connID) {
        AuthenticationFrameworkUtilitiesImp.openDialogForNewConnection((String)connID);
    }

    public static void openDialogForModifyConnection(String hostID, String connCategory, String connID) {
        AuthenticationFrameworkUtilitiesImp.openDialogForModifyConnection((String)hostID, (String)connCategory, (String)connID);
    }

    public static boolean deleteConnection(String hostID, String connCategory) {
        return AuthenticationFrameworkUtilitiesImp.deleteConnection((String)hostID, (String)connCategory);
    }

    public static boolean canDelete(String hostID, String connCategory) {
        return AuthenticationFrameworkUtilitiesImp.canDelete((String)hostID, (String)connCategory);
    }

    public static AuthDetails getUserNameAndPasswordDialogIfRequired(TheHost theHost, String connCategory) {
        Objects.requireNonNull(theHost, "Please provide a non-null TheHost.");
        try {
            return AuthenticationFrameworkUtilitiesImp.getUserNameAndPasswordDialogIfRequired((TheHost)theHost, (String)connCategory, (Method)PDCommonConnectionProvider.class.getMethod("setExplicitConnectIssued", new Class[0]), (PDLoggerJhost)PDLogger.get(AuthenticationFrameworkUtilities.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            PDLogger.get(AuthenticationFrameworkUtilities.class).error(e);
            return null;
        }
    }

    public static AuthDetails getUserNameAndPassword(TheHost theHost, String connCategory, boolean connectedOnly) {
        return AuthenticationFrameworkUtilitiesImp.getUserNameAndPassword((TheHost)theHost, (String)connCategory, (boolean)connectedOnly);
    }

    public static boolean connectionExists(String hostID, String connCategory) {
        return AuthenticationFrameworkUtilitiesImp.connectionExists((String)hostID, (String)connCategory);
    }

    public static void addPDConnectionChangeListener(IPDToolsConnectionChangeListener listener, String connCategory) {
        AuthenticationFrameworkUtilitiesImp.addPDConnectionChangeListener((IPDToolsConnectionChangeListener)listener, (String)connCategory, (String)"keyDefaultEncoding", (String)"hostType", (String)"keyBidiFormat");
    }

    @Deprecated
    public static void addPDConnectionRequestListener(IPDToolsConnectionRequestListener listener) {
        PDToolsCommonServerClientJhost.getDefault().addConnectionListener(listener);
    }

    @Deprecated
    public static void addPDConnectionRequestListener2(IPDToolsConnectionRequestListener2 listener) {
        PDToolsCommonServerClientJhost.getDefault().addConnectionListener2(listener);
    }
}

