/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view.sax;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.sax.PDSaxParser;
import com.ibm.pdtools.common.component.lookup.Messages;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CategoryTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationAbend;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationMessage;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationOther;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.RootTreeNote;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.TypeTreeNode;
import com.ibm.pdtools.common.component.lookup.view.sax.LookupAttributeTagNames;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LookupDataParser
extends PDSaxParser {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int APPROX_NUMBER_OF_SHIPPED_LOOKUP_CODE_EXPLANATIONS = 60000;
    private static final PDLogger logger = PDLogger.get(LookupDataParser.class);

    public static void parseLookupData(RootTreeNote rootNote, URL fileName, IProgressMonitor monitor) {
        LookupDataParser.parseLookupDataImpl(rootNote, fileName, (IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
    }

    public static void parseLookupDataImpl(RootTreeNote rootNote, URL fileName, final IProgressMonitor monitor) {
        monitor.beginTask(Messages.LookupDataParser_ReadingLocal, 100);
        LookupDataParser.parse((URL)fileName, (DefaultHandler)new DefaultHandler(rootNote){
            private int numLoaded = 0;
            final TypeTreeNode abendTypeNode;
            final TypeTreeNode otherTypeNode;
            final TypeTreeNode messageTypeNode;
            boolean abend;
            boolean abendId;
            StringBuilder abendIdStr;
            StringBuilder abendDescStr;
            boolean abendDescription;
            boolean message;
            boolean messageId;
            StringBuilder messageIdStr;
            StringBuilder messageDescStr;
            boolean messageDescription;
            boolean other;
            boolean otherId;
            StringBuilder otherIdStr;
            StringBuilder otherDescStr;
            boolean otherDescription;
            {
                this.abendTypeNode = rootTreeNote.addOrGetChildNode(LookupAttributeTagNames.ABENDS);
                this.otherTypeNode = rootTreeNote.addOrGetChildNode(LookupAttributeTagNames.OTHERS);
                this.messageTypeNode = rootTreeNote.addOrGetChildNode(LookupAttributeTagNames.MESSAGES);
                this.abendIdStr = new StringBuilder();
                this.abendDescStr = new StringBuilder();
                this.messageIdStr = new StringBuilder();
                this.messageDescStr = new StringBuilder();
                this.otherIdStr = new StringBuilder();
                this.otherDescStr = new StringBuilder();
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                LookupAttributeTagNames type = LookupAttributeTagNames.parse(qName = qName.toUpperCase().trim());
                if (type != null) {
                    switch (type) {
                        case ABEND: {
                            this.abendIdStr = new StringBuilder();
                            this.abendDescStr = new StringBuilder();
                            this.abend = true;
                            break;
                        }
                        case MESSAGE: {
                            this.messageIdStr = new StringBuilder();
                            this.messageDescStr = new StringBuilder();
                            this.message = true;
                            break;
                        }
                        case OTHER: {
                            this.otherIdStr = new StringBuilder();
                            this.otherDescStr = new StringBuilder();
                            this.other = true;
                            break;
                        }
                        case ID: {
                            if (this.abend) {
                                this.abendId = true;
                                break;
                            }
                            if (this.message) {
                                this.messageId = true;
                                break;
                            }
                            if (!this.other) break;
                            this.otherId = true;
                            break;
                        }
                        case DESCRIPTION: {
                            if (this.abend) {
                                this.abendDescription = true;
                                break;
                            }
                            if (this.message) {
                                this.messageDescription = true;
                                break;
                            }
                            if (!this.other) break;
                            this.otherDescription = true;
                            break;
                        }
                        default: {
                            logger.trace((Object)("Start Element :" + qName));
                        }
                    }
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                LookupAttributeTagNames type = LookupAttributeTagNames.parse(qName = qName.toUpperCase().trim());
                if (type != null) {
                    switch (type) {
                        case ABEND: {
                            String abendIdStrTemp = this.abendIdStr.toString().trim();
                            if (abendIdStrTemp.contains("_")) {
                                this.abendTypeNode.addOrGetChildNode(CategoryTreeNode.getCategoryFromId(type, abendIdStrTemp)).addOrGetChildNode(new CodeExplanationAbend(abendIdStrTemp, this.abendDescStr.toString()));
                                this.reportLoadPorgress(monitor);
                            } else {
                                logger.trace((Object)("Invalid id: " + String.valueOf(this.abendIdStr)));
                            }
                            this.abend = false;
                            break;
                        }
                        case MESSAGE: {
                            String messageIdStrTemp = this.messageIdStr.toString().trim();
                            if (messageIdStrTemp.contains("_")) {
                                this.messageTypeNode.addOrGetChildNode(CategoryTreeNode.getCategoryFromId(type, messageIdStrTemp)).addOrGetChildNode(new CodeExplanationMessage(messageIdStrTemp, this.messageDescStr.toString()));
                                this.reportLoadPorgress(monitor);
                            } else {
                                logger.trace((Object)("Invalid id: " + messageIdStrTemp));
                            }
                            this.message = false;
                            break;
                        }
                        case OTHER: {
                            String otherIdStrTemp = this.otherIdStr.toString().trim();
                            if (otherIdStrTemp.contains("_")) {
                                this.otherTypeNode.addOrGetChildNode(CategoryTreeNode.getCategoryFromId(type, otherIdStrTemp)).addOrGetChildNode(new CodeExplanationOther(otherIdStrTemp, this.otherDescStr.toString()));
                                this.reportLoadPorgress(monitor);
                            } else {
                                logger.trace((Object)("Invalid id: " + String.valueOf(this.otherIdStr)));
                            }
                            this.other = false;
                            break;
                        }
                        case ID: {
                            if (this.abend) {
                                this.abendId = false;
                                break;
                            }
                            if (this.message) {
                                this.messageId = false;
                                break;
                            }
                            if (!this.other) break;
                            this.otherId = false;
                            break;
                        }
                        case DESCRIPTION: {
                            if (this.abend) {
                                this.abendDescription = false;
                                break;
                            }
                            if (this.message) {
                                this.messageDescription = false;
                                break;
                            }
                            if (!this.other) break;
                            this.otherDescription = false;
                            break;
                        }
                        default: {
                            logger.trace((Object)("End Element :" + String.valueOf((Object)type)));
                        }
                    }
                }
            }

            private void reportLoadPorgress(IProgressMonitor monitor2) {
                ++this.numLoaded;
                if ((double)this.numLoaded / 60000.0 * 100.0 % 1.0 == 0.0) {
                    monitor2.worked(1);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                String string = new String(ch, start, length);
                if (this.abendId) {
                    this.abendIdStr.append(string);
                } else if (this.abendDescription) {
                    this.abendDescStr.append(string);
                } else if (this.messageId) {
                    this.messageIdStr.append(string);
                } else if (this.messageDescription) {
                    this.messageDescStr.append(string);
                } else if (this.otherId) {
                    this.otherIdStr.append(string);
                } else if (this.otherDescription) {
                    this.otherDescStr.append(string);
                }
            }
        });
    }
}

