/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view.internal.tree.handler;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.lookup.view.LookupView;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.AbstractCodeExplanation;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.AbstractCodeExplanationTreeNode;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyExplanationHandler
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection ss;
        Object firstElement;
        ISelection currentSelectionChecked = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (currentSelectionChecked instanceof TextSelection) {
            AbstractCodeExplanation u = LookupView.showView().getCurrentlyDisplayedExplanation();
            if (u != null) {
                CopyExplanationHandler.copyToClipboard(u);
            }
        } else if (currentSelectionChecked instanceof IStructuredSelection && (firstElement = (ss = (IStructuredSelection)currentSelectionChecked).getFirstElement()) instanceof AbstractCodeExplanationTreeNode) {
            CopyExplanationHandler.copyToClipboard((AbstractCodeExplanation)((AbstractCodeExplanationTreeNode)firstElement).getData());
        }
    }

    private static void copyToClipboard(AbstractCodeExplanation u) {
        Clipboard cb = new Clipboard(Display.getDefault());
        TextTransfer textTransfer = TextTransfer.getInstance();
        String stringToCopy = u.getCode() + System.lineSeparator() + u.getExplanation();
        try {
            try {
                cb.setContents(new Object[]{stringToCopy}, new Transfer[]{textTransfer});
            }
            catch (SWTError e) {
                PDDialogWithText.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.Error, (String)Messages.CopyName_COPY_OF_BELOW_NAMES_FAILED, (String)stringToCopy);
                cb.dispose();
            }
        }
        finally {
            cb.dispose();
        }
    }
}

