/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view.internal.tree;

import com.ibm.pdtools.common.component.lookup.view.internal.tree.ITreeNodeChildProvider;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.ITreeNodeLabelProvider;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.ITreeNodeParentProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public abstract class TreeNode<PARENT, DATA, CHILDREN>
implements ITreeNodeParentProvider<PARENT>,
ITreeNodeChildProvider<CHILDREN>,
ITreeNodeLabelProvider {
    private PARENT parent;
    private DATA data;
    private Collection<CHILDREN> children;

    TreeNode(PARENT parent, DATA data) {
        this(Objects.requireNonNull(parent, "Must provide a non-null parent  node."), Objects.requireNonNull(data, "Must provide a non-null data item."), Collections.EMPTY_SET);
    }

    TreeNode(PARENT parent, DATA data, Collection<CHILDREN> children) {
        this.parent = parent;
        this.data = data;
        this.children = children;
    }

    TreeNode(Collection<CHILDREN> children) {
        this(null, null, Objects.requireNonNull(children, "Must provide a non-null Collection<Children>"));
    }

    CHILDREN addChild(CHILDREN c) {
        Objects.requireNonNull(c, "Must provide a non-null child.");
        this.children.add(c);
        return c;
    }

    @Override
    public PARENT getParent() {
        return this.parent;
    }

    @Override
    public Collection<CHILDREN> getChildren() {
        return this.children;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public DATA getData() {
        return this.data;
    }

    CHILDREN addOrGet(CHILDREN ttn) {
        Objects.requireNonNull(ttn, "Must provide a non-null child.");
        if (this.getChildren().contains(ttn)) {
            for (CHILDREN c : this.getChildren()) {
                if (!c.equals(ttn)) continue;
                return c;
            }
        }
        return this.addChild(ttn);
    }

    @Override
    public String getLabel() {
        return this.data.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNode other = (TreeNode)obj;
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public String toString() {
        return this.data.toString();
    }

    void removeAllChildren() {
        if (this.hasChildren()) {
            this.children.clear();
        }
    }

    void removeChild(CHILDREN c) {
        Objects.requireNonNull(c, "Must provide a non-null child to remove.");
        if (this.children != null) {
            this.children.remove(c);
        }
    }
}

