/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view.internal.tree;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CodeExplanationUser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

class CSVLoader {
    CSVLoader() {
    }

    static Collection<CodeExplanationUser> loadAsCSV(InputStream is) throws IOException {
        Objects.requireNonNull(is, "Please provide a non-null FileInputStream.");
        CSVParserBuilder parserBuilder = new CSVParserBuilder();
        parserBuilder.withSeparator(',');
        parserBuilder.withQuoteChar('\"');
        parserBuilder.withIgnoreLeadingWhiteSpace(true);
        CSVReaderBuilder rb = new CSVReaderBuilder((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        rb.withCSVParser((ICSVParser)parserBuilder.build());
        rb.withSkipLines(0);
        rb.withKeepCarriageReturn(false);
        ArrayList<CodeExplanationUser> userCodeExplanation = new ArrayList<CodeExplanationUser>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (CSVReader reader = rb.build();){
                for (Object[] line : reader.readAll()) {
                    if (line.length > 1) {
                        userCodeExplanation.add(new CodeExplanationUser(line[0], line[1]));
                        continue;
                    }
                    PDLogger.get(CSVLoader.class).error((Object)MessageFormat.format("Malformed CSV detected: ''{0}'' was expecting a \"<code>\",\"<value>\"", Arrays.toString(line)));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            PDLogger.get(CSVLoader.class).error((Object)MessageFormat.format("Exception reading CSV file: {0}", ex.getMessage()));
        }
        return userCodeExplanation;
    }
}

