/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.lookup.view.LookupView;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class OpenCodeHandler
extends AbstractHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(OpenCodeHandler.class);
    public static final String ID = "com.ibm.pdtools.common.component.lookup.view.OpenCodeHandler";
    @Deprecated
    public static final String PARAM_TYPE = "com.ibm.pdtools.common.component.lookup.view.OpenCodeHandler.param.type";
    @Deprecated
    public static final String PARAM_SUBTYPE = "com.ibm.pdtools.common.component.lookup.view.OpenCodeHandler.param.subtype";
    public static final String PARAM_CODE = "com.ibm.pdtools.common.component.lookup.view.OpenCodeHandler.param.code";
    public static final String TYPE_ABEND = "ABEND";
    public static final String TYPE_MESSAGE = "MESSAGE";
    public static final String TYPE_OTHER = "OTHER";
    public static final String SUBTYPE_LE = "CEE";
    public static final String SUBTYPE_CICS = "CICS";
    public static final String SUBTYPE_IMS = "DFS";
    public static final String SUBTYPE_MVS = "SYS";
    public static final String SUBTYPE_COBOL_FILE_STATUS = "COBOL_FILE_STATUS";
    public static final String SUBTYPE_IMS_AIB = "IMS_AIB";
    public static final String SUBTYPE_IMS_DIB_STATUS = "IMS_DIB_STATUS";
    public static final String SUBTYPE_IMS_STATUS = "IMS_STATUS";
    public static final String SUBTYPE_IMS_UIB_STATUS = "IMS_UIB_STATUS";
    public static final String SUBTYPE_MQS = "MQS";
    public static final String SUBTYPE_MQSERIES_REASON = "MQSERIES_REASON";
    public static final String SUBTYPE_PIC = "PIC";
    public static final String SUBTYPE_SQLCODE = "SQLCODE";
    public static final String SUBTYPE_SQLREAS = "SQLREAS";
    public static final String SUBTYPE_SQLSTATE = "SQLSTATE";
    public static final String SUBTYPE_VSAM_FEEDBACK = "VSAM_FEEDBACK";

    public static Map<String, String> openCode(String messageCode) {
        Objects.requireNonNull(messageCode, "Please provide a non-null messageCode to search for.");
        try {
            LookupView view2 = LookupView.showView();
            if (view2 != null) {
                return view2.performSearch(messageCode, true, null);
            }
            logger.info((Object)"The lookupView didn't / couldn't open. searching headlessly...");
            return new LookupView().performSearchHeadless(messageCode);
        }
        catch (Exception e) {
            logger.error((Object)"Exception thrown while searching in lookup view", (Throwable)e);
            return Collections.EMPTY_MAP;
        }
    }

    public Map<String, String> execute(ExecutionEvent event) throws ExecutionException {
        Objects.requireNonNull(event, "Must provide a non-null executionEvent.");
        Map parameters = event.getParameters();
        String arg = "";
        if (parameters.get(PARAM_CODE) != null && !((String)parameters.get(PARAM_CODE)).isEmpty()) {
            arg = (String)parameters.get(PARAM_CODE);
        }
        return OpenCodeHandler.openCode(arg);
    }
}

