/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view;

import com.ibm.pdtools.common.component.core.Messages;
import com.ibm.pdtools.common.component.core.PDTCCcore;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.lookup.view.BrowserSupport;
import com.ibm.pdtools.common.component.lookup.view.LookedUpMessage;
import com.ibm.pdtools.common.component.lookup.view.LookupContentProvider;
import com.ibm.pdtools.common.component.lookup.view.LookupPreferencePage;
import com.ibm.pdtools.common.component.lookup.view.LookupViewListener;
import com.ibm.pdtools.common.component.lookup.view.LookupViewRemoteSearchSupport;
import com.ibm.pdtools.common.component.lookup.view.LookupViewToolTipColumnLabelProvider;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.AbstractCodeExplanation;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.AbstractCodeExplanationTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.CategoryTreeNode;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.ITreeNodeLabelProvider;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.LookupViewTree;
import com.ibm.pdtools.common.component.lookup.view.internal.tree.RootTreeNote;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import com.ibm.pdtools.common.component.ui.util.PDUserTask;
import com.ibm.pdtools.common.component.ui.util.SelectionProviderMediator;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class LookupView
extends ViewPart {
    private static final String EXPLANATION_DATA_INPUT_KEY = "input";
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.pdtools.common.component.lookup.view.LookupView";
    private static final String RESULT_TABLE_MENU_ID = "com.ibm.pdtools.common.component.lookup.view.LookupView.resultTableMenu";
    private static final String EXPLANATION_TEXT_MENU = "com.ibm.pdtools.common.component.lookup.view.LookupView.explanationTextMenu";
    private static final String CODE_TREE_MENU_ID = "com.ibm.pdtools.common.component.lookup.view.LookupView.codeTreeMenu";
    public static final String LOOKUP_ICON = "icons/lookup.gif";
    private TabFolder folder;
    private TabItem explanation;
    private TextViewer message;
    private TabItem results;
    private TableViewer table;
    private TreeViewer tree;
    private TableViewerColumn value_column;
    private TableViewerColumn type_column;
    private List<LookupViewListener> lookupViewListeners = new ArrayList<LookupViewListener>();
    private static String VALUE_COLUMN = "Value";
    private static String TYPE_COLUMN = "Type";
    private static final PDLogger logger = PDLogger.get(LookupView.class);
    private TabItem browseOnline;
    private Browser browser;
    private Link fallbackUrl;
    private ProgressIndicator indicator;
    private Combo combo;
    private LookupViewTree lvt;

    public void dispose() {
        Job.getJobManager().cancel((Object)this.browser);
    }

    public void createPartControl(Composite parent) {
        Button button2;
        block4: {
            SashForm composite = new SashForm(parent, 256);
            composite.setLayoutData((Object)GUI.grid.d.fillAll());
            Composite left = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
            Composite right = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
            composite.setWeights(new int[]{40, 60});
            Composite search = GUI.composite((Composite)left, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
            GUI.label.left((Composite)search, (String)Messages.LookupView_2, (Object)GUI.grid.d.left1());
            this.combo = GUI.combo.editable((Composite)search, (Object)GUI.grid.d.fillH((int)1));
            new ComboValueSaver(this.combo, ((Object)((Object)this)).getClass().getCanonicalName() + "search");
            button2 = GUI.button.push((Composite)search, (Image)PDTCCcore.getDefault().getImageRegistry().get(LOOKUP_ICON), (String)Messages.LookupView_0, (Object)GUI.grid.d.left1());
            this.combo.setToolTipText(Messages.LookupView_6);
            this.tree = new TreeViewer(left, 268437508);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tree);
            this.tree.getTree().setLayoutData((Object)GUI.grid.d.fillAll());
            this.tree.setLabelProvider((IBaseLabelProvider)new LookupViewToolTipColumnLabelProvider(){

                public void update(ViewerCell cell) {
                    cell.setText(cell.getElement() instanceof ITreeNodeLabelProvider ? ((ITreeNodeLabelProvider)cell.getElement()).getLabel() : cell.getElement().toString());
                }

                public String getText(Object element) {
                    return element instanceof ITreeNodeLabelProvider ? ((ITreeNodeLabelProvider)element).getLabel() : super.getText(element);
                }
            });
            this.tree.setUseHashlookup(true);
            this.tree.setContentProvider((IContentProvider)new LookupContentProvider());
            this.tree.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    if (e1 instanceof ITreeNodeLabelProvider) {
                        return ((ITreeNodeLabelProvider)e1).getLabel().compareTo(((ITreeNodeLabelProvider)e2).getLabel());
                    }
                    return super.compare(viewer, e1, e2);
                }
            });
            this.tree.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    TreeViewer treeViewer;
                    Object element = ((TreeSelection)event.getSelection()).getFirstElement();
                    if (element instanceof AbstractCodeExplanationTreeNode) {
                        LookupView.this.set_selection((AbstractCodeExplanationTreeNode)element);
                    }
                    if ((treeViewer = (TreeViewer)event.getViewer()).getExpandedState(element)) {
                        treeViewer.collapseToLevel(element, 1);
                    } else {
                        treeViewer.expandToLevel(element, 1);
                    }
                }
            });
            this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent arg0) {
                }
            });
            this.reloadCodeExplanations();
            this.folder = new TabFolder(right, 128);
            this.folder.setLayoutData((Object)GUI.grid.d.fillAll());
            this.explanation = new TabItem(this.folder, 0, 0);
            this.explanation.setText(Messages.LookupView_4);
            this.message = new TextViewer((Composite)this.folder, 2826);
            GridData d2 = GUI.grid.d.fillAll();
            this.message.getTextWidget().setLayoutData((Object)d2);
            this.message.getTextWidget().setBackground(Display.getCurrent().getSystemColor(1));
            this.explanation.setControl((Control)this.message.getTextWidget());
            this.results = new TabItem(this.folder, 0, 1);
            this.results.setText(Messages.LookupView_5);
            Composite resultsComposite = GUI.composite((Composite)this.folder, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
            Composite resultsCount = GUI.composite((Composite)resultsComposite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
            GUI.label((Composite)resultsCount, (String)Messages.LookupView_1, (Object)GUI.grid.d.left1(), (int)16384);
            final Text resultCount = GUI.text((Composite)resultsCount, (Object)GUI.grid.d.fillH((int)1), (int)8);
            this.table = new TableViewer(resultsComposite, 68100);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.table);
            this.table.setUseHashlookup(true);
            this.table.getTable().setLayoutData((Object)GUI.grid.d.fillAll());
            this.table.getTable().setHeaderVisible(true);
            this.table.getTable().setLinesVisible(true);
            this.table.getTable().setSortDirection(128);
            this.table.setContentProvider((IContentProvider)new ArrayContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    if (newInput != null) {
                        resultCount.setText("" + ((Collection)newInput).size());
                        LookupView.this.table.getTable().setSortDirection(128);
                        LookupView.this.table.getTable().setSortColumn(LookupView.this.value_column.getColumn());
                        LookupView.this.folder.setSelection(LookupView.this.results);
                        if (((Collection)newInput).isEmpty() && LookupPreferencePage.isRemoteSearchEnabled() && LookupView.this.browseOnline != null) {
                            LookupView.this.folder.setSelection(LookupView.this.browseOnline);
                        }
                    }
                    super.inputChanged(viewer, oldInput, newInput);
                }
            });
            this.table.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    String left_id = ((AbstractCodeExplanation)((AbstractCodeExplanationTreeNode)e1).getData()).getCode();
                    String right_id = ((AbstractCodeExplanation)((AbstractCodeExplanationTreeNode)e2).getData()).getCode();
                    if (LookupView.this.table.getTable().getSortDirection() == 1024) {
                        String temp = left_id;
                        left_id = right_id;
                        right_id = temp;
                    }
                    if (LookupView.this.table.getTable().getSortColumn().equals(LookupView.this.value_column.getColumn())) {
                        return left_id.substring(left_id.lastIndexOf("_") + 1).compareTo(right_id.substring(right_id.lastIndexOf("_") + 1));
                    }
                    if (LookupView.this.table.getTable().getSortColumn().equals(LookupView.this.type_column.getColumn())) {
                        return left_id.substring(0, left_id.lastIndexOf("_")).compareTo(right_id.substring(0, right_id.lastIndexOf("_")));
                    }
                    return 0;
                }
            });
            this.table.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    Object element = ((StructuredSelection)event.getSelection()).getFirstElement();
                    if (element instanceof AbstractCodeExplanationTreeNode) {
                        LookupView.this.set_selection((AbstractCodeExplanationTreeNode)element);
                    }
                }
            });
            this.value_column = new TableViewerColumn(this.table, 2048);
            this.value_column.getColumn().setText(VALUE_COLUMN);
            this.value_column.getColumn().setWidth(200);
            this.value_column.setLabelProvider((CellLabelProvider)new LookupViewToolTipColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof AbstractCodeExplanationTreeNode) {
                        return ((AbstractCodeExplanationTreeNode)element).getLabel();
                    }
                    return super.getText(element);
                }
            });
            this.value_column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LookupView.this.table.getTable().setSortColumn((TableColumn)e.widget);
                    if (LookupView.this.table.getTable().getSortDirection() == 128) {
                        LookupView.this.table.getTable().setSortDirection(1024);
                    } else {
                        LookupView.this.table.getTable().setSortDirection(128);
                    }
                    LookupView.this.table.refresh();
                }
            });
            this.table.getTable().setSortColumn(this.value_column.getColumn());
            this.type_column = new TableViewerColumn(this.table, 2048);
            this.type_column.getColumn().setText(TYPE_COLUMN);
            this.type_column.getColumn().setWidth(400);
            this.type_column.setLabelProvider((CellLabelProvider)new LookupViewToolTipColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof AbstractCodeExplanationTreeNode) {
                        return ((CategoryTreeNode)((AbstractCodeExplanationTreeNode)element).getParent()).getLabel();
                    }
                    return super.getText(element);
                }
            });
            this.type_column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LookupView.this.table.getTable().setSortColumn((TableColumn)e.widget);
                    if (LookupView.this.table.getTable().getSortDirection() == 128) {
                        LookupView.this.table.getTable().setSortDirection(1024);
                    } else {
                        LookupView.this.table.getTable().setSortDirection(128);
                    }
                    LookupView.this.table.refresh();
                }
            });
            this.results.setControl((Control)resultsComposite);
            Composite browseComposite = GUI.composite((Composite)this.folder, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
            this.browseOnline = new TabItem(this.folder, 0, 2);
            this.browseOnline.setControl((Control)browseComposite);
            this.browseOnline.setText(Messages.LookupView_3);
            this.indicator = new ProgressIndicator(browseComposite);
            this.indicator.setLayoutData((Object)GUI.grid.d.fillH((int)1));
            Composite addressbar = new Composite(browseComposite, 2048);
            addressbar.setLayout((Layout)GUI.grid.l.noMargins((int)2, (boolean)false));
            addressbar.setLayoutData((Object)GUI.grid.d.fillH((int)1));
            addressbar.setFont(browseComposite.getFont());
            this.fallbackUrl = new Link(addressbar, 0);
            GridData gd = GUI.grid.d.fillH((int)1);
            gd.grabExcessHorizontalSpace = true;
            this.fallbackUrl.setLayoutData((Object)gd);
            this.fallbackUrl.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.go();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.go();
                }

                private void go() {
                    final String text2 = LookupView.this.fallbackUrl.getData().toString();
                    if (text2 != null) {
                        logger.trace((Object)("Launching " + text2));
                        PDSafeUIRunner.syncExec((Callable)new Callable<Void>(){

                            @Override
                            public Void call() throws PartInitException, MalformedURLException {
                                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(URI.create(text2).toURL());
                                return null;
                            }
                        });
                    }
                }
            });
            try {
                this.browser = new Browser(browseComposite, 0);
                BrowserSupport.initialize(PlatformUI.getWorkbench().getDisplay(), this.browser);
                this.browser.addLocationListener(new LocationListener(){

                    public void changing(LocationEvent event) {
                    }

                    public void changed(LocationEvent event) {
                        LookupView.this.setAddressBarText(event.location);
                    }
                });
                GridData d1 = GUI.grid.d.fillAll();
                d1.heightHint = 500;
                this.browser.setLayoutData((Object)d1);
            }
            catch (SWTError e3) {
                logger.info((Object)"The Eclipse embedded web browser could not be created.");
                if (!"gtk".equals(SWT.getPlatform())) break block4;
                StyledText st = new StyledText(browseComposite, 72);
                st.setText(Messages.LookupView_CantCreateEmbeddedBrowser);
                st.setLayoutData((Object)GUI.grid.d.fillAll());
                this.setAddressBarText(Messages.LookupView_InstallRegsForBrowserOnLinux);
            }
        }
        SelectionAdapter search_listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String term = LookupView.this.combo.getText().trim();
                PDUserTask.createAndRunJob((String)Messages.LookupView_Searching, (PDUserTask.PDUserJobFunction)new PDUserTask.PDUserJobFunction(){

                    public void run(IProgressMonitor monitor) {
                        LookupView.this.performSearch(term, true, monitor);
                    }
                }, (boolean)true, (JobChangeAdapter)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ComboValueSaver.getInstance((Combo)((this).this).LookupView.this.combo).forceSaveCurrentValue();
                                ComboValueSaver.getInstance((Combo)((this).this).LookupView.this.combo).setCustomItems(new String[0], false, false);
                                ((this).this).LookupView.this.combo.select(0);
                            }
                        });
                    }
                });
            }
        };
        this.combo.addSelectionListener((SelectionListener)search_listener);
        this.combo.addKeyListener((KeyListener)new KeyAdapter((SelectionListener)search_listener){
            private final /* synthetic */ SelectionListener val$search_listener;
            {
                this.val$search_listener = selectionListener;
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r' || e.character == '\n') {
                    this.val$search_listener.widgetSelected(null);
                    LookupView.this.table.getTable().setFocus();
                }
            }
        });
        button2.addSelectionListener((SelectionListener)search_listener);
        if (this.getSite() != null) {
            MenuManager menuManager = new MenuManager(null, CODE_TREE_MENU_ID);
            this.tree.getTree().setMenu(menuManager.createContextMenu((Control)this.tree.getTree()));
            this.getSite().registerContextMenu(CODE_TREE_MENU_ID, menuManager, (ISelectionProvider)this.tree);
            MenuManager menuManager2 = new MenuManager(null, EXPLANATION_TEXT_MENU);
            this.message.getTextWidget().setMenu(menuManager2.createContextMenu((Control)this.message.getTextWidget()));
            this.getSite().registerContextMenu(EXPLANATION_TEXT_MENU, menuManager2, (ISelectionProvider)this.message);
            MenuManager menuManager3 = new MenuManager(null, RESULT_TABLE_MENU_ID);
            this.table.getTable().setMenu(menuManager3.createContextMenu((Control)this.table.getTable()));
            this.getSite().registerContextMenu(RESULT_TABLE_MENU_ID, menuManager3, (ISelectionProvider)this.table);
            this.getSite().setSelectionProvider((ISelectionProvider)new SelectionProviderMediator(null, Arrays.asList(this.tree, this.table, this.message)));
        } else {
            logger.error((Object)"Failed to set selection provider since site was null during initialization.");
        }
    }

    public void reloadCodeExplanations() {
        final AtomicReference nodeRef = new AtomicReference();
        PDUserTask.createAndRunJob((String)Messages.LookupView_LoadingLocal, (PDUserTask.PDUserJobFunction)new PDUserTask.PDUserJobFunction(){

            public void run(IProgressMonitor monitor) {
                nodeRef.set(LookupView.this.loadLookupData(monitor));
            }
        }, (boolean)true, (JobChangeAdapter)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Object[] expandedElements = (this).LookupView.this.tree.getExpandedElements();
                        (this).LookupView.this.tree.setInput(nodeRef.get());
                        (this).LookupView.this.tree.refresh();
                        (this).LookupView.this.tree.setExpandedElements(expandedElements);
                        LookupView.this.fireExplanationsLoaded();
                    }
                });
            }
        });
    }

    private RootTreeNote loadLookupData(IProgressMonitor monitor) {
        if (this.lvt == null) {
            this.lvt = new LookupViewTree(monitor);
        }
        return this.lvt.reloadUserCodeExplanations();
    }

    public void addExplanationAndDisplayIt(LookedUpMessage message) {
        this.set_selection(this.lvt.addExplanation(message));
    }

    public Map<String, String> performSearchHeadless(String messageCode) {
        return LookupView.messagesToStringMap(this.searchInternal(messageCode, true, true, null));
    }

    private Collection<AbstractCodeExplanationTreeNode> searchInternal(String messageCode, boolean headless, boolean quotePatternOnErrors, IProgressMonitor monitor) {
        Objects.requireNonNull(messageCode, "Please provide a non-null search term.");
        if (this.lvt == null) {
            this.loadLookupData(monitor);
        }
        ArrayList<AbstractCodeExplanationTreeNode> search_results = new ArrayList<AbstractCodeExplanationTreeNode>();
        Collection<AbstractCodeExplanationTreeNode> search = this.lvt.search(messageCode, headless, quotePatternOnErrors, monitor);
        search_results.addAll(search);
        if (search_results.isEmpty()) {
            search_results.addAll(this.lvt.search("*" + messageCode + "*", headless, quotePatternOnErrors, monitor));
        }
        if (search_results.isEmpty() && messageCode.contains("-")) {
            search_results.addAll(this.lvt.search("*" + messageCode.split("-")[0] + "*", headless, quotePatternOnErrors, monitor));
        }
        return search_results;
    }

    @Deprecated
    public Map<String, String> performSearch(String messageCode) {
        return this.performSearch(messageCode, true, null);
    }

    @Deprecated
    public Map<String, String> performSearch(String messageCode, boolean quotePatternOnErrors) {
        return this.performSearch(messageCode, quotePatternOnErrors, null);
    }

    public Map<String, String> performSearch(final String messageCode, boolean quotePatternOnErrors, IProgressMonitor monitor) {
        Objects.requireNonNull(messageCode, "Please provide a non-null messageCode to search for.");
        if (messageCode.trim().isEmpty()) {
            logger.info((Object)"Sorry Can't search for an empty string. No Matches found.");
            return Collections.emptyMap();
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LookupView.this.combo.setText(messageCode);
            }
        });
        final Collection<AbstractCodeExplanationTreeNode> search_results = this.searchInternal(messageCode, false, quotePatternOnErrors, monitor);
        PDSafeUIRunner.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                LookupView.this.tree.refresh();
                LookupView.this.table.setInput((Object)search_results);
                if (search_results.size() == 1) {
                    LookupView.this.set_selection((AbstractCodeExplanationTreeNode)search_results.iterator().next());
                } else if (LookupView.this.browser != null) {
                    logger.trace((Object)("Searching: " + messageCode));
                    LookupViewRemoteSearchSupport.searchFromStringInBrowser(LookupView.this.browser, LookupView.this.indicator, messageCode);
                }
                LookupView.this.setAddressBarText(messageCode);
            }
        });
        return LookupView.messagesToStringMap(search_results);
    }

    private static Map<String, String> messagesToStringMap(Collection<AbstractCodeExplanationTreeNode> search_results) {
        HashMap<String, String> searchResultMap = new HashMap<String, String>();
        for (AbstractCodeExplanationTreeNode result : search_results) {
            searchResultMap.put(((AbstractCodeExplanation)result.getData()).getCode(), ((AbstractCodeExplanation)result.getData()).getExplanation());
        }
        return searchResultMap;
    }

    public void setFocus() {
    }

    public AbstractCodeExplanation getCurrentlyDisplayedExplanation() {
        Object o;
        if (this.message != null && (o = this.message.getData(EXPLANATION_DATA_INPUT_KEY)) instanceof AbstractCodeExplanation) {
            return (AbstractCodeExplanation)o;
        }
        return null;
    }

    private void set_selection(final AbstractCodeExplanationTreeNode m) {
        PDSafeUIRunner.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                LookupView.this.message.setData(LookupView.EXPLANATION_DATA_INPUT_KEY, m.getData());
                LookupView.this.message.setDocument((IDocument)new Document(((AbstractCodeExplanation)m.getData()).getExplanation()));
                if (!LookupView.this.folder.isDisposed() && !LookupView.this.explanation.isDisposed()) {
                    LookupView.this.folder.setSelection(LookupView.this.explanation);
                }
                LookupView.this.tree.setSelection((ISelection)new StructuredSelection((Object)m), true);
                String searchTerm = ((AbstractCodeExplanation)m.getData()).getCode().replace("_", " ").replace("-", " ").trim();
                LookupView.this.setAddressBarText(searchTerm);
            }
        });
    }

    public static LookupView showView() {
        return Platform.isRunning() ? (LookupView)PDPlatformUIUtils.view.showView((String)ID, LookupView.class, null, (PDPlatformUIUtils.view.ViewMode)PDPlatformUIUtils.view.ViewMode.VIEW_VISIBLE) : null;
    }

    public static LookupView getView() {
        if (Platform.isRunning()) {
            LookupView view2 = (LookupView)PDPlatformUIUtils.view.findView((String)ID, LookupView.class);
            return view2 == null ? LookupView.showView() : view2;
        }
        return null;
    }

    public void addLookupViewListener(LookupViewListener listener) {
        if (!this.lookupViewListeners.contains(listener)) {
            this.lookupViewListeners.add(listener);
        }
    }

    public void removeLookupViewListener(LookupViewListener listener) {
        if (this.lookupViewListeners.contains(listener)) {
            this.lookupViewListeners.remove(listener);
        }
    }

    public void fireExplanationsLoaded() {
        this.lookupViewListeners.forEach(listener -> listener.explanationsLoaded());
    }

    private void setAddressBarText(final String searchTerm) {
        PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!searchTerm.equals(LookupView.this.fallbackUrl.getData())) {
                    String url = LookupPreferencePage.getRemoteSearchURL() + LookupView.sanitizeSearTerm(searchTerm);
                    LookupView.this.fallbackUrl.setText("<a>" + url + "</a>");
                    LookupView.this.fallbackUrl.setData((Object)url);
                    LookupView.this.fallbackUrl.pack();
                }
            }
        });
    }

    private static String sanitizeSearTerm(String searchCleaned) {
        try {
            searchCleaned = URLEncoder.encode(searchCleaned, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return searchCleaned;
    }

    public boolean addUserExplanationsFromCachedFile(IFile cachedMessageFile) {
        boolean status = this.lvt.addUserExplanationsFromCachedFile(cachedMessageFile);
        PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                LookupView.this.tree.refresh();
            }
        });
        return status;
    }
}

