/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view;

import com.ibm.pdtools.common.component.lookup.view.LookupView;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class FixLookupData {
    private static final URL lookupJa = LookupView.class.getResource("nl" + File.separator + "ja" + File.separator + "lookup.xml");
    private static final URL lookupEn = LookupView.class.getResource("lookup.xml");

    public static void main(String[] args) {
        new File("nl" + File.separator + "ja").mkdirs();
        FixLookupData.cleanText("nl" + File.separator + "ja" + File.separator + "lookup.cleaned.xml", lookupJa, "/nl/ja");
        FixLookupData.cleanText("lookup.cleaned.xml", lookupEn, "");
    }

    private static void cleanText(String outName, URL resource, String outDir) {
        try {
            File file = new File(outName);
            System.out.println(file.getAbsolutePath());
            String string = new String(FixLookupData.readURL(resource), StandardCharsets.UTF_8);
            Files.write(file.toPath(), FixLookupData.stripNonValidXMLCharacters(string).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            System.out.println("Please rename " + file.getAbsolutePath() + " to lookup.xml and then copy to " + FixLookupData.class.getPackage().getName() + outDir);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private static byte[] readURL(URL url) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = url.openStream();){
                int nRead;
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toByteArray();
    }

    public static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        int i = 0;
        while (i < in.length()) {
            char current = in.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
                out.append(current);
            }
            ++i;
        }
        return out.toString();
    }
}

