/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.lookup.view;

import com.ibm.pdtools.common.component.core.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BrowserSupport {
    static void initialize(final Display display, Browser browser) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (!event.required) {
                    return;
                }
                Shell shell = new Shell(display);
                shell.setText(Messages.BrowserSupport_NewWindow);
                shell.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
                Browser browser = new Browser((Composite)shell, 0);
                browser.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
                BrowserSupport.initialize(display, browser);
                event.browser = browser;
            }
        });
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                if (!(event.addressBar || event.menuBar || event.statusBar)) {
                    boolean cfr_ignored_0 = event.toolBar;
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
    }
}

