/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.core.model;

import com.ibm.etools.fa.pdtclient.core.model.FAPlatformObject;
import com.ibm.etools.fa.pdtclient.core.model.SystemsViewFault;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;

public class SystemsViewHistoryFile
extends FAPlatformObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String hfName;
    private String hfLocalPath;

    public SystemsViewHistoryFile(IPDHost system, String hfName, String hfLocalPath) {
        super(system);
        this.hfName = hfName;
        this.hfLocalPath = hfLocalPath;
    }

    public String getName() {
        return this.hfName;
    }

    public String getHFLocalPath() {
        return this.hfLocalPath.replace(".hfml", "");
    }

    public Result<List<SystemsViewFault>> loadInfo() {
        File[] faDirEntries;
        ArrayList<SystemsViewFault> faFaultList = new ArrayList<SystemsViewFault>();
        Result refreshResult = new Result();
        File faDir = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().concat("/FaultAnalyzer/").concat(this.getHFLocalPath()));
        if (faDir.exists() && (faDirEntries = faDir.listFiles()) != null) {
            File[] fileArray = faDirEntries;
            int n = faDirEntries.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.getName().endsWith(".hfml")) {
                    faFaultList.add(new SystemsViewFault(this.getSystem(), file.getName()));
                }
                ++n2;
            }
        }
        refreshResult.setOutput(faFaultList);
        return refreshResult;
    }

    public String getPDImageName() {
        return "IMG_OBJ_FILE";
    }

    public String toString() {
        return MessageFormat.format("SystemsViewHistoryFile [name: {0}, Local Path: {1}]", this.hfName, this.hfLocalPath);
    }
}

