/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.core;

import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.jhost.util.PDSafeRunner;
import com.ibm.pdtools.common.component.jhost.util.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.XMLMemento;

public class MementoUtils {
    private static PDLogger logger = PDLogger.get(MementoUtils.class);

    public static XMLMemento loadXMLMementoFromIFile(IFile ifile, boolean force, Charset charset) {
        return MementoUtils.loadXMLMementoFromIFile(ifile, force, charset, (IProgressMonitor)new NullProgressMonitor());
    }

    public static XMLMemento loadXMLMementoFromIFile(IFile ifile, boolean force, Charset charset, IProgressMonitor monitor) {
        Objects.requireNonNull(ifile, "Must provide a non-null ifile.");
        Objects.requireNonNull(charset, "Must provide a non-null charset.");
        if (ifile.exists()) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStreamReader isr = new InputStreamReader(ifile.getContents(true), charset);){
                    return XMLMemento.createReadRoot((Reader)isr);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException e) {
                logger.error((Object)"An error occurred while loading the XMLMemento from the IFile: ", e);
            }
        } else {
            logger.error(new Object[]{"The specified iFile does not exist: ", ifile, " ", PDLogger.filteredTrace((StackTraceElement[])Thread.currentThread().getStackTrace())});
        }
        return null;
    }

    public static XMLMemento loadXMLMementoFromString(String string) {
        Objects.requireNonNull(string, "Must provide a non-null string.");
        string = XMLUtils.replaceIllegalXMLCharacters((String)string);
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (StringReader isr = new StringReader(string);){
                return XMLMemento.createReadRoot((Reader)isr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            logger.error((Object)"An error occurred while loading the XMLMemento from the String: ", (Throwable)e);
            return null;
        }
    }

    public static boolean saveXMLMementoToIFileAsUTF8(XMLMemento memento, IFile file, Charset charset, boolean force, boolean keepHistory, IProgressMonitor monitor) {
        block4: {
            Objects.requireNonNull(memento, "Must provide a non-null memento.");
            Objects.requireNonNull(file, "Must provide a non-null file.");
            Objects.requireNonNull(charset, "Must provide a non-null charset.");
            try {
                String temp = MementoUtils.saveXMLMementoToString(memento);
                if (temp == null) break block4;
                if (!IResourceUtils.existsCaseInsensitive((IResource)file, (IProgressMonitor)monitor, (boolean)false)) {
                    IResourceUtils.createEmptyIFile((IFile)file, (boolean)true, (IProgressMonitor)monitor, (boolean)false);
                }
                file.setContents((InputStream)new ByteArrayInputStream(temp.getBytes(charset)), force, keepHistory, monitor);
                return true;
            }
            catch (CoreException e) {
                logger.error((Object)"An error occurred while saving the XMLMemento the IFile: ", (Throwable)e);
                return false;
            }
        }
        logger.error((Object)"Save memento to string was null.");
        return false;
    }

    public static String saveXMLMementoToString(final XMLMemento memento) {
        Objects.requireNonNull(memento, "Must provide a non-null memento.");
        return (String)PDSafeRunner.call((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                StringWriter writer = new StringWriter();
                memento.save((Writer)writer);
                return XMLUtils.replaceIllegalXMLCharacters((String)writer.toString());
            }
        });
    }
}

