/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.core;

import com.ibm.etools.fa.pdtclient.core.FACorePlugin;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class FAResourceUtils {
    public static IFolder getFaultEntryFolder(String host, String port, String hf, String fe) {
        Objects.requireNonNull(fe, "Must specify a non-null fe.");
        return FAResourceUtils.getHistoryFileFolder(host, port, hf).getFolder(fe);
    }

    public static IFile getSpecifiedLocalViewHFMLFile(String host, String port, String view) {
        return FAResourceUtils.getFaultEntryHFMLFile(host, port, "local.views", view);
    }

    public static IFile getFaultEntryHFMLFile(String host, String port, String hf, String fe) {
        Objects.requireNonNull(fe, "Must specify a non-null fe.");
        Objects.requireNonNull(hf, "Must specify a non-null hf.");
        return FAResourceUtils.getSystemFolder(host, port).getFile(MessageFormat.format("{0}({1}).hfml", hf, fe));
    }

    public static IFile getFaultEntryFAMLFile(String host, String port, String hf, String fe) {
        return FAResourceUtils.getFaultEntryFolder(host, port, hf, fe).getFile(MessageFormat.format("{0}.faml", fe));
    }

    public static IFile getSavedReportFile(String host, String port, String hf, String fe) {
        return FAResourceUtils.getFaultEntryFolder(host, port, hf, fe).getFile("Saved Report.txt");
    }

    public static IFile getFaultEntryMDMLFile(String host, String port, String hf, String fe) {
        return FAResourceUtils.getFaultEntryFolder(host, port, hf, fe).getFile(MessageFormat.format("{0}.mdml", fe));
    }

    public static String getProjectRelativePath(String host, String port, String hf, String fe) {
        String path = FAResourceUtils.getHistoryFileFolderRelativePath(host, port, hf).toString();
        if (fe != null && !fe.trim().isEmpty()) {
            path = MessageFormat.format("{0}({1})", path, fe);
        }
        path = MessageFormat.format("{0}.hfml", path);
        return path;
    }

    public static IFile getHistoryFileIndexFile(String host, String port, String hf) {
        return FAResourceUtils.getHistoryFileFolder(host, port, hf).getFile("index.hfml");
    }

    public static IFolder getHistoryFileFolder(String host, String port, String hf) {
        Objects.requireNonNull(hf, "Must specify a non-null hf.");
        return FAResourceUtils.getSystemFolder(host, port).getFolder(hf);
    }

    public static IPath getHistoryFileFolderRelativePath(String host, String port, String hf) {
        return FAResourceUtils.getHistoryFileFolder(host, port, hf).getProjectRelativePath();
    }

    public static IPath getHistoryFileHFMLFileRelativePath(String host, String port, String hf) {
        return FAResourceUtils.getHistoryFileHFMLFile(host, port, hf).getProjectRelativePath();
    }

    public static IFile getHistoryFileHFMLFile(String host, String port, String hf) {
        Objects.requireNonNull(hf, "Must specify a non-null hf.");
        return FAResourceUtils.getSystemFolder(host, port).getFile(hf + ".hfml");
    }

    public static IFolder getSystemFolder(String host, String port) {
        Objects.requireNonNull(host, "Must specify a non-null host.");
        Objects.requireNonNull(port, "Must specify a non-null port.");
        if (!FACorePlugin.getRoot().isOpen()) {
            throw new RuntimeException("The 'FaultAnalyzer' project could not be opened.");
        }
        host = Ipv6Utils.encode((String)host);
        IFolder caseInsensitiveHost = (IFolder)IResourceUtils.getCaseInsensitive((IResource)FACorePlugin.getRoot().getFolder(host), (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        if (caseInsensitiveHost != null) {
            return caseInsensitiveHost.getFolder(port);
        }
        return FACorePlugin.getRoot().getFolder(host.toUpperCase()).getFolder(port);
    }

    public static boolean isFileExtension(IResource resource, String value) {
        Objects.requireNonNull(resource, "Must specify a non-null resource.");
        Objects.requireNonNull(value, "Must specify a non-null value.");
        return resource.getType() == 1 && resource.getFileExtension() != null && resource.getFileExtension().equals(value);
    }

    public static boolean isFileExtension(IPath path, String value) {
        Objects.requireNonNull(path, "Must specify a non-null path.");
        Objects.requireNonNull(value, "Must specify a non-null value.");
        return path.getFileExtension() != null && path.getFileExtension().equals(value);
    }
}

