/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.core;

import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.zusage.core.UsagePlugin;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.IResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class FACorePlugin
extends AbstractUIPlugin {
    private static final String FAULT_ANALYZER_PROJECT = "FaultAnalyzer";
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(FACorePlugin.class);
    public static final String PLUGIN_ID = "com.ibm.etools.fa.pdtclient.core";
    public static final String FaUIPluginId = "com.ibm.etools.fa.pdtclient.ui";
    private static FACorePlugin plugin;
    static boolean setDefaultCharset;

    static {
        setDefaultCharset = true;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        UsagePlugin.getOfferingRegistry().findOrRegisterOffering("5655Q41", Messages.AddMVSFileAsHistoryfile_FaultAnalyzer);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private static void log(Object _msg) {
        if (_msg instanceof IStatus) {
            FACorePlugin.getDefault().getLog().log((IStatus)_msg);
        }
        StackTraceElement ste = new Exception().getStackTrace()[1];
        String msg = String.valueOf(_msg) + ", " + ste.getClassName() + " " + ste.getMethodName() + " : " + ste.getLineNumber() + " @ " + String.valueOf(new Date()) + "\n";
        logger.debug((Object)msg);
        IFile log_file = FACorePlugin.getRoot().getFile(".log");
        if (!log_file.exists()) {
            IResourceUtils.createEmptyIFile((IFile)log_file, (boolean)true, null);
        }
        try {
            log_file.appendContents((InputStream)new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8)), true, false, null);
        }
        catch (CoreException e) {
            logger.warn((Object)e.getMessage());
        }
    }

    public static FACorePlugin getDefault() {
        return plugin;
    }

    public static IProject getRoot() {
        IProject root = ResourcesPlugin.getWorkspace().getRoot().getProject(FAULT_ANALYZER_PROJECT);
        if (!root.exists()) {
            try {
                root.create(null);
                setDefaultCharset = true;
            }
            catch (CoreException e) {
                logger.warn((Object)e.getMessage());
                FACorePlugin.repairFAProjectMetadata();
            }
        }
        if (!root.isOpen()) {
            try {
                root.open(null);
                setDefaultCharset = true;
            }
            catch (CoreException e) {
                logger.warn((Object)e.getMessage());
                FACorePlugin.repairFAProjectMetadata();
            }
        }
        try {
            if (setDefaultCharset) {
                if (!StandardCharsets.UTF_8.name().equals(root.getDefaultCharset())) {
                    root.setDefaultCharset(StandardCharsets.UTF_8.name(), null);
                }
                setDefaultCharset = false;
            }
        }
        catch (CoreException e) {
            logger.warn((Object)e.getMessage());
        }
        return root;
    }

    public static void repairFAProjectMetadata() {
        logger.info((Object)"Attempting to repair Fault Analyzer project metadata...");
        File folder = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        if (folder != null && folder.isDirectory()) {
            File[] files = folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname != null && pathname.getName().equals(FACorePlugin.FAULT_ANALYZER_PROJECT);
                }
            });
            if (files != null && files.length == 1) {
                if (files[0].isDirectory()) {
                    File[] projectFile = files[0].listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname != null && pathname.getName().equals(".project");
                        }
                    });
                    if (projectFile != null && projectFile.length == 1) {
                        if (projectFile[0].exists()) {
                            try {
                                File oldProjectFile = new File(projectFile[0].getParent() + File.separator + ".project.old" + System.currentTimeMillis());
                                Files.move(projectFile[0].toPath(), oldProjectFile.toPath(), new CopyOption[0]);
                            }
                            catch (IOException e) {
                                logger.error((Throwable)e);
                            }
                            logger.info((Object)"Renamed '.project' metadata file to '.project.old', creating new metadata...");
                        }
                    } else {
                        logger.info((Object)"The fault analyzer .project file is missing");
                    }
                }
            } else {
                logger.info((Object)"The fault analyzer project does not exist, attempting to create it...");
            }
        }
        IProject root = ResourcesPlugin.getWorkspace().getRoot().getProject(FAULT_ANALYZER_PROJECT);
        IResourceUtils.refreshLocalIResource((IResource)root, (int)0, (IProgressMonitor)new NullProgressMonitor());
        IResourceUtils.deleteIProject((IProject)root, (boolean)false, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
        IResourceUtils.createAnOpenProjectAsNeeded((IProject)root, (IProgressMonitor)new NullProgressMonitor());
    }
}

