/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.rse.adapter;

import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.zosphysical.ZOSResource;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSDataSet;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSPartitionedDataSet;
import com.ibm.pdtools.common.component.core.integration.PDMVSResource;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.rse.adapter.GetPortFromIhost;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.rse.core.model.IHost;

public class MVSFileResourceAF
implements IAdapterFactory {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(MVSFileResourceAF.class);

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof MVSFileResource && adapterType == PDMVSResource.class) {
            ZOSResource z = ((MVSFileResource)adaptableObject).getZOSResource();
            if (z instanceof ZOSDataSet) {
                String recFM = null;
                try {
                    recFM = ((ZOSDataSet)z).getCharacteristics().getRecordFormat().toString();
                }
                catch (Throwable t) {
                    logger.error(t);
                }
                int recLen = -1;
                try {
                    recLen = ((ZOSDataSet)z).getCharacteristics().getRecordLength();
                }
                catch (ClassCastException e) {
                    logger.info((Object)"(ClassCastError.): i.e Error loading Dataset information. Is the FEKDSI module in the RSE server STEPLIB or in LPA?");
                }
                catch (Throwable t) {
                    logger.error(t);
                }
                try {
                    IHost host = ((MVSFileResource)adaptableObject).getSubSystem().getHost();
                    return new PDMVSResource(GetPortFromIhost.createConnectionFromHost(host), ((MVSFileResource)adaptableObject).getName(), recFM == null ? "" : recFM.trim().toUpperCase(), recLen, z instanceof ZOSPartitionedDataSet);
                }
                catch (Throwable t) {
                    logger.error(t);
                }
            } else if (PDLogger.isTraceEnabled()) {
                logger.trace(new Object[]{"Selection: " + String.valueOf(adaptableObject) + " is not a ZOSDataSet; can't adapt with this adapter. It is a " + String.valueOf(z.getClass()) + ". returning null...", PDLogger.filteredTrace((StackTraceElement[])new Throwable().getStackTrace())});
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{MVSFileResource.class};
    }
}

