/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdtools.common.component.core.rse.adapter;

import com.ibm.etools.zos.system.zOSSystem;
import com.ibm.pdtools.common.component.core.integration.PDMVSConnection;
import com.ibm.pdtools.common.component.core.util.DialogUtils;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;

public abstract class GetPortFromIhost {
    public static final String PORT_VALUE_ENVVAR_NAME = "PD_SERVER_PORT";

    private static String checkIhostHasPDToolsPortDefined(IHost host) {
        Objects.requireNonNull(host, "A non-null host must be specified.");
        String value = "";
        IRemoteCmdSubSystem[] iRemoteCmdSubSystemArray = RemoteCommandHelpers.getCmdSubSystems((IHost)host);
        int n = iRemoteCmdSubSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteCmdSubSystem remoteCmdSubSystem = iRemoteCmdSubSystemArray[n2];
            if (remoteCmdSubSystem instanceof ShellServiceSubSystem) {
                List variables = ((ShellServiceSubSystem)remoteCmdSubSystem).getHostEnvironmentVariables();
                for (Object v : variables) {
                    if (v == null || !(value = (String)v).startsWith(PORT_VALUE_ENVVAR_NAME)) continue;
                    if (value.matches("\\w+\\=\\d+")) {
                        return value.split("\\=")[1].trim();
                    }
                    String msg = MessageFormat.format("The {0} environment value has been specified as ''{1}'' ; the common server port can not be determined from that value.", PORT_VALUE_ENVVAR_NAME, value);
                    DialogUtils.openErrorThreadSafe((String)"Error", (String)msg);
                }
            }
            ++n2;
        }
        return null;
    }

    public static PDMVSConnection createConnectionFromHost(IHost host) {
        return new PDMVSConnection(host.getHostName(), GetPortFromIhost.checkIhostHasPDToolsPortDefined(host), host.getAliasName() != null ? host.getAliasName() : host.getHostName(), ((zOSSystem)host).getUserInformation().getUserId(), ((zOSSystem)host).getUserInformation().getPassword());
    }
}

