/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pdtclient.analytics.integration.rse;

import com.ibm.etools.fa.pdtclient.analytics.handler.OpenAnalyticsViewFromReportsList;
import com.ibm.etools.fa.pdtclient.core.Messages;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.etools.fa.pdtclient.ui.util.QualifiedFaultEntry;
import com.ibm.etools.fa.pdtclient.ui.util.integration.OpenReportRSE;
import com.ibm.etools.fa.pdtclient.ui.views.reportslist.ReportsList;
import com.ibm.pdtools.common.component.core.integration.PDAdapterHelper;
import com.ibm.pdtools.common.component.core.integration.PDMVSConnection;
import com.ibm.pdtools.common.component.core.integration.PDMVSResource;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenAnalyticsFromMVSFile
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(OpenAnalyticsFromMVSFile.class);

    protected void handle(final ExecutionEvent event) {
        Job openJob = new Job(Messages.OpenAnalyticsFromMVSFile_OpeningAnalytics){

            protected IStatus run(IProgressMonitor monitor) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        ISelection s = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                        if (s instanceof StructuredSelection) {
                            PDMVSResource fa = (PDMVSResource)PDAdapterHelper.adapt((Object)((StructuredSelection)s).getFirstElement(), PDMVSResource.class);
                            if (fa != null && fa.isHistoryFile()) {
                                FATPJob openJob = OpenReportRSE.open((PDMVSConnection)fa.getConnection(), (QualifiedFaultEntry)new QualifiedFaultEntry(fa.getConnection().getHostName(), fa.getName(), null));
                                if (openJob != null && openJob.getResult() == null) {
                                    openJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                                        public void done(IJobChangeEvent event) {
                                            ReportsList.show((boolean)false);
                                            OpenAnalyticsViewFromReportsList.openAndLoadFromReportsList();
                                        }
                                    });
                                } else {
                                    ReportsList.show((boolean)false);
                                    OpenAnalyticsViewFromReportsList.openAndLoadFromReportsList();
                                }
                            } else {
                                logger.trace((Object)("Could not adapt the selection into a " + PDMVSResource.class.getCanonicalName() + " selction is " + (s == null ? "null" : s.getClass().getCanonicalName())));
                            }
                        } else {
                            PDDialogs.openInfoThreadSafe((String)Messages.OpenAnalyticsFromMVSFile_FaultAnalyzer, (String)Messages.OpenAnalyticsFromMVSFile_SelectedItemNotAHistFile);
                        }
                    }

                    public void handleException(Throwable exception) {
                        logger.error((Object)"Caught: ", exception);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        openJob.schedule();
    }
}

