/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.install.info.view;

import com.ibm.etools.fa.install.info.core.BackendRequests;
import com.ibm.etools.fa.install.info.core.Messages;
import com.ibm.etools.fa.install.info.model.HistoryFileInfo;
import com.ibm.etools.fa.install.info.model.InstallationInfo;
import com.ibm.etools.fa.install.info.model.InstallationInfoGeneralItem;
import com.ibm.etools.fa.install.info.model.LanguageEnvironmentExitStatus;
import com.ibm.etools.fa.install.info.model.LoadModuleInfo;
import com.ibm.etools.fa.install.info.model.OptlmEntry;
import com.ibm.etools.fa.install.info.model.SubsystemInfoItem;
import com.ibm.etools.fa.install.info.view.HistoryFileInfoFilter;
import com.ibm.etools.fa.install.info.view.HistoryFileTableViewerComparator;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import com.ibm.etools.fa.pdtclient.ui.faobjects.history.CharsetResponseHelper;
import com.ibm.etools.fa.pdtclient.ui.fatp.FATPJob;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.Ipv6Utils;
import com.ibm.pdtools.common.component.core.util.PDXMLMementoUtils;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class InstallInfoView
extends ViewPart {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(InstallInfoView.class);
    public static final String ID = "com.ibm.etools.fa.install.info.view.InstallInfoView";
    private InstallationInfo installInfo = new InstallationInfo();
    private HistoryFileTableViewerComparator comparatorManaged = new HistoryFileTableViewerComparator();
    private HistoryFileTableViewerComparator comparatorExcluded = new HistoryFileTableViewerComparator();
    private HistoryFileInfoFilter managedFilter = new HistoryFileInfoFilter();
    private HistoryFileInfoFilter excludedFilter = new HistoryFileInfoFilter();
    private String address;
    private int port;
    private TableViewer generalPropertiesTable;
    private Label whereFound;
    private TableViewer loadModulesTable;
    private TableViewer leExitTable;
    private TableViewer optlmTable;
    private TableViewer subsystemPropertiesTable;
    private TableViewer managedHistoryFileViewer;
    private TableViewer excludedHistoryFileViewer;

    private static TableViewer createAHistoryFileInfoTable(Composite managedHistComposite, String tooltip, HistoryFileTableViewerComparator comparator) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        managedHistComposite.setLayout((Layout)tableColumnLayout);
        TableViewer table = new TableViewer(managedHistComposite, 268503812);
        table.setUseHashlookup(true);
        table.getTable().setLinesVisible(true);
        table.getTable().setHeaderVisible(true);
        table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn module = new TableViewerColumn(table, 0);
        module.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof HistoryFileInfo) {
                    HistoryFileInfo l2 = (HistoryFileInfo)element;
                    return l2.getDsn();
                }
                return "";
            }
        });
        module.getColumn().setText(Messages.GetInstallationInformation_HistoryFileName);
        module.getColumn().setToolTipText(tooltip);
        module.getColumn().setResizable(true);
        module.getColumn().setMoveable(true);
        module.getColumn().addSelectionListener((SelectionListener)InstallInfoView.getSelectionAdapter(module.getColumn(), 0, comparator, table));
        tableColumnLayout.setColumnData((Widget)module.getColumn(), (ColumnLayoutData)new ColumnWeightData(3));
        TableViewerColumn dsnType = new TableViewerColumn(table, 0);
        dsnType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof HistoryFileInfo) {
                    HistoryFileInfo l2 = (HistoryFileInfo)element;
                    return l2.getDsnType();
                }
                return "";
            }
        });
        dsnType.getColumn().setText(Messages.GetInstallationInformation_DsnType);
        dsnType.getColumn().addSelectionListener((SelectionListener)InstallInfoView.getSelectionAdapter(dsnType.getColumn(), 1, comparator, table));
        dsnType.getColumn().setResizable(true);
        dsnType.getColumn().setMoveable(true);
        tableColumnLayout.setColumnData((Widget)dsnType.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn lrecl = new TableViewerColumn(table, 0);
        lrecl.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof HistoryFileInfo) {
                    HistoryFileInfo l2 = (HistoryFileInfo)element;
                    return l2.getLrecl();
                }
                return "";
            }
        });
        lrecl.getColumn().setText(Messages.GetInstallationInformation_Lrecl);
        lrecl.getColumn().addSelectionListener((SelectionListener)InstallInfoView.getSelectionAdapter(lrecl.getColumn(), 2, comparator, table));
        lrecl.getColumn().setResizable(true);
        lrecl.getColumn().setMoveable(true);
        tableColumnLayout.setColumnData((Widget)lrecl.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn recfm = new TableViewerColumn(table, 0);
        recfm.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof HistoryFileInfo) {
                    HistoryFileInfo l2 = (HistoryFileInfo)element;
                    return l2.getRecfm();
                }
                return "";
            }
        });
        recfm.getColumn().setText(Messages.GetInstallationInformation_Recfm);
        recfm.getColumn().addSelectionListener((SelectionListener)InstallInfoView.getSelectionAdapter(recfm.getColumn(), 3, comparator, table));
        recfm.getColumn().setResizable(true);
        recfm.getColumn().setMoveable(true);
        tableColumnLayout.setColumnData((Widget)recfm.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn volser = new TableViewerColumn(table, 0);
        volser.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof HistoryFileInfo) {
                    return ((HistoryFileInfo)element).getVolser();
                }
                return "";
            }
        });
        volser.getColumn().setText(Messages.GetInstallationInformation_VolSer);
        volser.getColumn().addSelectionListener((SelectionListener)InstallInfoView.getSelectionAdapter(volser.getColumn(), 4, comparator, table));
        volser.getColumn().setResizable(true);
        volser.getColumn().setMoveable(true);
        tableColumnLayout.setColumnData((Widget)volser.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn secondaryAllocation = InstallInfoView.createColumn(table, Messages.GetInstallationInformation_SecondaryAllocation, "", new ColumnLabelProvider(){

            public String getText(Object element) {
                return element instanceof HistoryFileInfo ? ((HistoryFileInfo)element).getSecondaryAllocation() : "";
            }
        });
        secondaryAllocation.getColumn().addSelectionListener((SelectionListener)InstallInfoView.getSelectionAdapter(secondaryAllocation.getColumn(), 5, comparator, table));
        tableColumnLayout.setColumnData((Widget)secondaryAllocation.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn accessLevel = InstallInfoView.createColumn(table, Messages.InstallInfoView_AccessLevel, "", new ColumnLabelProvider(){

            public String getText(Object element) {
                return element instanceof HistoryFileInfo ? ((HistoryFileInfo)element).getAccessLevel() : "";
            }
        });
        accessLevel.getColumn().addSelectionListener((SelectionListener)InstallInfoView.getSelectionAdapter(accessLevel.getColumn(), 6, comparator, table));
        tableColumnLayout.setColumnData((Widget)accessLevel.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        return table;
    }

    private static TableViewerColumn createColumn(TableViewer table, String label2, String toolTip, ColumnLabelProvider labelProvider) {
        TableViewerColumn column = new TableViewerColumn(table, 0);
        column.setLabelProvider((CellLabelProvider)labelProvider);
        column.getColumn().setText(label2);
        column.getColumn().setToolTipText(toolTip);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(true);
        return column;
    }

    private static TableViewer createLEExitsTable(Composite leExitsComposite) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        leExitsComposite.setLayout((Layout)tableColumnLayout);
        TableViewer table = InstallInfoView.createTableViewer(leExitsComposite);
        TableViewerColumn module = new TableViewerColumn(table, 0);
        module.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LanguageEnvironmentExitStatus) {
                    return ((LanguageEnvironmentExitStatus)element).getName();
                }
                return "";
            }
        });
        module.getColumn().setText("Module");
        module.getColumn().setToolTipText(Messages.GetInstallationInformation_leExitsTooltip);
        tableColumnLayout.setColumnData((Widget)module.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn status = new TableViewerColumn(table, 0);
        status.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LanguageEnvironmentExitStatus) {
                    return ((LanguageEnvironmentExitStatus)element).getStatus();
                }
                return "";
            }
        });
        status.getColumn().setText(Messages.GetInstallationInformation_Status);
        tableColumnLayout.setColumnData((Widget)status.getColumn(), (ColumnLayoutData)new ColumnWeightData(2));
        TableViewerColumn type = new TableViewerColumn(table, 0);
        type.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LanguageEnvironmentExitStatus) {
                    return ((LanguageEnvironmentExitStatus)element).getType();
                }
                return "";
            }
        });
        type.getColumn().setText("LE Exit (type)");
        tableColumnLayout.setColumnData((Widget)type.getColumn(), (ColumnLayoutData)new ColumnWeightData(3));
        TableViewerColumn installer = new TableViewerColumn(table, 0);
        installer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LanguageEnvironmentExitStatus) {
                    return ((LanguageEnvironmentExitStatus)element).getInstaller();
                }
                return "";
            }
        });
        installer.getColumn().setText("Installer");
        tableColumnLayout.setColumnData((Widget)installer.getColumn(), (ColumnLayoutData)new ColumnWeightData(4));
        return table;
    }

    private static TableViewer createLoadModulesTable(Composite loadModuleComposite) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        loadModuleComposite.setLayout((Layout)tableColumnLayout);
        TableViewer loadModulesTable = InstallInfoView.createTableViewer(loadModuleComposite);
        TableViewerColumn loadModuleNameColumn = new TableViewerColumn(loadModulesTable, 0);
        loadModuleNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LoadModuleInfo) {
                    return ((LoadModuleInfo)element).getName();
                }
                return "";
            }
        });
        loadModuleNameColumn.getColumn().setText(Messages.GetInstallationInformation_Module);
        loadModuleNameColumn.getColumn().setToolTipText(Messages.GetInstallationInformation_loadModulesTooltip);
        tableColumnLayout.setColumnData((Widget)loadModuleNameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn versionColumn = new TableViewerColumn(loadModulesTable, 0);
        versionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LoadModuleInfo) {
                    return ((LoadModuleInfo)element).getVersion();
                }
                return "";
            }
        });
        versionColumn.getColumn().setText(Messages.GetInstallationInformation_Version);
        tableColumnLayout.setColumnData((Widget)versionColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn serviceColumn = new TableViewerColumn(loadModulesTable, 0);
        serviceColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LoadModuleInfo) {
                    return ((LoadModuleInfo)element).getService();
                }
                return "";
            }
        });
        serviceColumn.getColumn().setText(Messages.GetInstallationInformation_Service);
        tableColumnLayout.setColumnData((Widget)serviceColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn dateColumn = new TableViewerColumn(loadModulesTable, 0);
        dateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LoadModuleInfo) {
                    return ((LoadModuleInfo)element).getDate();
                }
                return "";
            }
        });
        dateColumn.getColumn().setText(Messages.GetInstallationInformation_Date);
        tableColumnLayout.setColumnData((Widget)dateColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn loadModuleAPFColumn = new TableViewerColumn(loadModulesTable, 0);
        loadModuleAPFColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LoadModuleInfo) {
                    return ((LoadModuleInfo)element).getModuleAPF();
                }
                return "";
            }
        });
        loadModuleAPFColumn.getColumn().setText(Messages.GetInstallationInformation_LoadModuleAPF);
        tableColumnLayout.setColumnData((Widget)loadModuleAPFColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn lpaColumn = new TableViewerColumn(loadModulesTable, 0);
        lpaColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LoadModuleInfo) {
                    return ((LoadModuleInfo)element).getLpa();
                }
                return "";
            }
        });
        lpaColumn.getColumn().setText(Messages.GetInstallationInformation_LPA);
        tableColumnLayout.setColumnData((Widget)lpaColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn dataSetAPFColumn = new TableViewerColumn(loadModulesTable, 0);
        dataSetAPFColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof LoadModuleInfo) {
                    return ((LoadModuleInfo)element).getDatasetAPF();
                }
                return "";
            }
        });
        dataSetAPFColumn.getColumn().setText(Messages.GetInstallationInformation_DataSetAPF);
        tableColumnLayout.setColumnData((Widget)dataSetAPFColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        return loadModulesTable;
    }

    private static TableViewer createOptlmTable(Composite optlmComposite) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        optlmComposite.setLayout((Layout)tableColumnLayout);
        TableViewer table = InstallInfoView.createTableViewer(optlmComposite);
        TableViewerColumn module = new TableViewerColumn(table, 0);
        module.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof OptlmEntry) {
                    return ((OptlmEntry)element).getName();
                }
                return "";
            }
        });
        module.getColumn().setText(Messages.GetInstallationInformation_Module);
        module.getColumn().setToolTipText(Messages.GetInstallationInformation_optlmTooltip);
        tableColumnLayout.setColumnData((Widget)module.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn value = new TableViewerColumn(table, 0);
        value.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof OptlmEntry) {
                    return ((OptlmEntry)element).getValue();
                }
                return "";
            }
        });
        value.getColumn().setText(Messages.GetInstallationInformation_Value);
        tableColumnLayout.setColumnData((Widget)value.getColumn(), (ColumnLayoutData)new ColumnWeightData(2));
        return table;
    }

    private static TableViewer createTableViewer(Composite parent) {
        TableViewer table = new TableViewer(parent, 268503812);
        table.getTable().setLinesVisible(true);
        table.getTable().setHeaderVisible(true);
        table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return table;
    }

    private static SelectionAdapter getSelectionAdapter(final TableColumn column, final int index, final HistoryFileTableViewerComparator comparator, final TableViewer viewer) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                viewer.getTable().setSortDirection(dir);
                viewer.getTable().setSortColumn(column);
                viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public static InstallInfoView showView() {
        return (InstallInfoView)PDPlatformUIUtils.view.showView((String)ID, InstallInfoView.class);
    }

    private void createExcludedHistoryFilesTab(TabFolder tabFolder) {
        GridLayout fillLayout = GridLayoutFactory.fillDefaults().create();
        GridData fillData = GridDataFactory.fillDefaults().grab(true, true).create();
        GridData fillDataH = GridDataFactory.fillDefaults().grab(true, false).create();
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(Messages.GetInstallationInformation_SubsystemExcludedHIstoryFiles);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)fillLayout, (Object)fillData);
        Composite excludedHistoryFilesSearchComposite = GUI.composite((Composite)composite, (Layout)fillLayout, (Object)fillDataH);
        Label excludedSearchLabel = new Label(excludedHistoryFilesSearchComposite, 0);
        excludedSearchLabel.setText(Messages.GetInstallationInformation_Search);
        final Text excludedSearchText = new Text(excludedHistoryFilesSearchComposite, 2176);
        excludedSearchText.setLayoutData((Object)new GridData(768));
        Composite excludedHistoryFilesComposite = GUI.composite((Composite)composite, (Layout)fillLayout, (Object)fillData);
        this.excludedHistoryFileViewer = InstallInfoView.createAHistoryFileInfoTable(excludedHistoryFilesComposite, Messages.GetInstallationInformation_excludedHistoryFilesTooltip, this.comparatorExcluded);
        this.excludedHistoryFileViewer.setComparator((ViewerComparator)this.comparatorExcluded);
        excludedSearchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                InstallInfoView.this.excludedFilter.setSearchText(excludedSearchText.getText());
                InstallInfoView.this.excludedHistoryFileViewer.refresh();
            }
        });
        this.excludedHistoryFileViewer.addFilter((ViewerFilter)this.excludedFilter);
        Menu excludeContextMenu = new Menu((Control)this.excludedHistoryFileViewer.getTable());
        this.excludedHistoryFileViewer.getTable().setMenu(excludeContextMenu);
        MenuItem unexclude = new MenuItem(excludeContextMenu, 0);
        unexclude.setText(Messages.InstallInfo_Unexclude);
        unexclude.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryFileInfo historyFile;
                Object element;
                if (!InstallInfoView.this.excludedHistoryFileViewer.getSelection().isEmpty() && (element = ((StructuredSelection)InstallInfoView.this.excludedHistoryFileViewer.getSelection()).getFirstElement()) instanceof HistoryFileInfo && !(historyFile = (HistoryFileInfo)element).getDsn().isEmpty() && !historyFile.getDsn().equals(Messages.GetInstallationInformation_TheSubsystemCouldNotBeContacted)) {
                    URI hostUri = FARL.getFARLURI((String)InstallInfoView.this.address, (String)Integer.toString(InstallInfoView.this.port), (String)historyFile.getDsn());
                    FATP unExcludeHistoryFile = BackendRequests.unexclude_history_file(hostUri);
                    FATP getInstallInfo = BackendRequests.get_installation_info(hostUri);
                    FATPJob job = new FATPJob(Messages.InstallInfo_AttemptingToUnexclude, new FATP[]{unExcludeHistoryFile, getInstallInfo}, null){

                        protected void finalize_responses(IProgressMonitor _monitor) {
                            for (FATP[] request_response : this.responses) {
                                Throwable throwable = null;
                                Object var5_6 = null;
                                try {
                                    FATP request = request_response[0];
                                    try {
                                        try (FATP response = request_response[1];){
                                            if ("\"installationInfo\"".equals(request.get_request_header("If-Match")) && response.is_successful_response() && response.get_status_code().equals("200")) {
                                                InstallInfoView.this.parseInstallationInfoFromResponse(response);
                                            } else if ("501".equals(response.get_status_code())) {
                                                PDDialogs.openErrorThreadSafe((String)Messages.InstallInfoView_ServerTooOld);
                                            } else if (!response.is_successful_response()) {
                                                PDDialogs.openErrorThreadSafe((String)Messages.InstallInfoView_ErrorUnexclude, (String)response.get_status_reason_phrase());
                                            }
                                        }
                                        if (request == null) continue;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (request != null) {
                                            request.close();
                                        }
                                        throw throwable;
                                    }
                                    request.close();
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    };
                    InstallInfoView.this.runFATPJob((Job)job, unExcludeHistoryFile);
                }
            }
        });
        tab.setControl((Control)composite);
    }

    private void createGeneralTab(TabFolder tabFolder) {
        TabItem generalTab = new TabItem(tabFolder, 0);
        generalTab.setText(Messages.GetInstallationInformation_General);
        GridLayout fillLayout = GridLayoutFactory.fillDefaults().create();
        GridData fillData = GridDataFactory.fillDefaults().grab(true, true).create();
        GridData fillDataH = GridDataFactory.fillDefaults().grab(true, false).create();
        Composite generalComposite = GUI.composite((Composite)tabFolder, (Layout)fillLayout, (Object)fillData);
        Composite generalPropertiesComposite = GUI.composite((Composite)generalComposite, (Layout)GUI.grid.l.standard(), (Object)fillData);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        generalPropertiesComposite.setLayout((Layout)tableColumnLayout);
        this.generalPropertiesTable = new TableViewer(generalPropertiesComposite, 268503812);
        this.generalPropertiesTable.getTable().setLinesVisible(true);
        this.generalPropertiesTable.getTable().setHeaderVisible(true);
        this.generalPropertiesTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.generalPropertiesTable);
        TableViewerColumn module = new TableViewerColumn(this.generalPropertiesTable, 0);
        module.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InstallationInfoGeneralItem) {
                    return ((InstallationInfoGeneralItem)element).getKey();
                }
                return "";
            }

            public String getToolTipText(Object element) {
                if (element instanceof SubsystemInfoItem) {
                    SubsystemInfoItem l2 = (SubsystemInfoItem)element;
                    return l2.getTooltip();
                }
                return "";
            }
        });
        module.getColumn().setText(Messages.InstallInfo_Property);
        tableColumnLayout.setColumnData((Widget)module.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn value = new TableViewerColumn(this.generalPropertiesTable, 0);
        value.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof InstallationInfoGeneralItem) {
                    return ((InstallationInfoGeneralItem)element).getValue();
                }
                return "";
            }

            public String getToolTipText(Object element) {
                if (element instanceof SubsystemInfoItem) {
                    return ((SubsystemInfoItem)element).getTooltip();
                }
                return "";
            }
        });
        value.getColumn().setText(Messages.GetInstallationInformation_Value);
        tableColumnLayout.setColumnData((Widget)value.getColumn(), (ColumnLayoutData)new ColumnWeightData(2));
        Group loadModulesGroup = GUI.group((Composite)generalComposite, (String)Messages.GetInstallationInformation_LoadModules, (Layout)fillLayout, (Object)fillData);
        Composite loadModuleComposite = GUI.composite((Composite)loadModulesGroup, (Layout)fillLayout, (Object)fillData);
        this.loadModulesTable = InstallInfoView.createLoadModulesTable(loadModuleComposite);
        Group leExitsGroup = GUI.group((Composite)generalComposite, (String)Messages.GetInstallationInformation_leExitInformation, (Layout)fillLayout, (Object)fillData);
        Composite leExitsComposite = GUI.composite((Composite)leExitsGroup, (Layout)fillLayout, (Object)fillData);
        this.leExitTable = InstallInfoView.createLEExitsTable(leExitsComposite);
        Group optlmGroup = GUI.group((Composite)generalComposite, (String)Messages.GetInstallationInformation_optlmInformation, (Layout)fillLayout, (Object)fillData);
        this.whereFound = GUI.label.left((Composite)optlmGroup, (String)"", (Object)fillDataH);
        Composite optlmComposite = GUI.composite((Composite)optlmGroup, (Layout)fillLayout, (Object)fillData);
        this.optlmTable = InstallInfoView.createOptlmTable(optlmComposite);
        generalTab.setControl((Control)generalComposite);
    }

    private void createManagedHistoryFilesTab(TabFolder tabFolder) {
        GridLayout fillLayout = GridLayoutFactory.fillDefaults().create();
        GridData fillData = GridDataFactory.fillDefaults().grab(true, true).create();
        GridData fillDataH = GridDataFactory.fillDefaults().grab(true, false).create();
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(Messages.GetInstallationInformation_SubsystemManagedHistoryFiles);
        Composite composite = GUI.composite((Composite)tabFolder, (Layout)fillLayout, (Object)fillData);
        Composite managedHistoryFilesSearchComposite = GUI.composite((Composite)composite, (Layout)fillLayout, (Object)fillDataH);
        Label managedSearchLabel = new Label(managedHistoryFilesSearchComposite, 0);
        managedSearchLabel.setText(Messages.GetInstallationInformation_Search);
        final Text managedSearchText = new Text(managedHistoryFilesSearchComposite, 2176);
        managedSearchText.setLayoutData((Object)new GridData(768));
        Composite managedHistoryFilesComposite = GUI.composite((Composite)composite, (Layout)fillLayout, (Object)fillData);
        this.managedHistoryFileViewer = InstallInfoView.createAHistoryFileInfoTable(managedHistoryFilesComposite, Messages.GetInstallationInformation_managedHistoryFilesTooltip, this.comparatorManaged);
        this.managedHistoryFileViewer.setComparator((ViewerComparator)this.comparatorManaged);
        managedSearchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                InstallInfoView.this.managedFilter.setSearchText(managedSearchText.getText());
                InstallInfoView.this.managedHistoryFileViewer.refresh();
            }
        });
        this.managedHistoryFileViewer.addFilter((ViewerFilter)this.managedFilter);
        Menu managedContextMenu = new Menu((Control)this.managedHistoryFileViewer.getTable());
        this.managedHistoryFileViewer.getTable().setMenu(managedContextMenu);
        MenuItem exclude = new MenuItem(managedContextMenu, 0);
        exclude.setText(Messages.InstallInfo_Exclude);
        exclude.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryFileInfo historyFile;
                Object element;
                if (!InstallInfoView.this.managedHistoryFileViewer.getSelection().isEmpty() && (element = ((StructuredSelection)InstallInfoView.this.managedHistoryFileViewer.getSelection()).getFirstElement()) instanceof HistoryFileInfo && !(historyFile = (HistoryFileInfo)element).getDsn().isEmpty() && !historyFile.getDsn().equals(Messages.GetInstallationInformation_TheSubsystemCouldNotBeContacted)) {
                    URI hostUri = FARL.getFARLURI((String)InstallInfoView.this.address, (String)Integer.toString(InstallInfoView.this.port), (String)historyFile.getDsn());
                    FATP excludeHistoryFile = BackendRequests.exclude_history_file(hostUri);
                    FATP unManageHistoryFile = BackendRequests.unmanage_history_file(hostUri);
                    FATP getInstallInfo = BackendRequests.get_installation_info(hostUri);
                    FATPJob job = new FATPJob(Messages.InstallInfo_AttemptingToExclude, new FATP[]{excludeHistoryFile, unManageHistoryFile, getInstallInfo}, null){

                        protected void finalize_responses(IProgressMonitor _monitor) {
                            for (FATP[] request_response : this.responses) {
                                Throwable throwable = null;
                                Object var5_6 = null;
                                try {
                                    FATP request = request_response[0];
                                    try {
                                        try (FATP response = request_response[1];){
                                            if ("\"installationInfo\"".equals(request.get_request_header("If-Match")) && response.is_successful_response() && response.get_status_code().equals("200")) {
                                                InstallInfoView.this.parseInstallationInfoFromResponse(response);
                                            } else if ("501".equals(response.get_status_code())) {
                                                PDDialogs.openErrorThreadSafe((String)Messages.InstallInfoView_ServerTooOld);
                                            } else if (!response.is_successful_response()) {
                                                PDDialogs.openErrorThreadSafe((String)Messages.InstallInfoView_ErrorExcluding, (String)response.get_status_reason_phrase());
                                            }
                                        }
                                        if (request == null) continue;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (request != null) {
                                            request.close();
                                        }
                                        throw throwable;
                                    }
                                    request.close();
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    };
                    InstallInfoView.this.runFATPJob((Job)job, excludeHistoryFile);
                }
            }
        });
        MenuItem unmanage = new MenuItem(managedContextMenu, 0);
        unmanage.setText(Messages.InstallInfo_Unmanage);
        unmanage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryFileInfo historyFile;
                Object element;
                if (!InstallInfoView.this.managedHistoryFileViewer.getSelection().isEmpty() && (element = ((StructuredSelection)InstallInfoView.this.managedHistoryFileViewer.getSelection()).getFirstElement()) instanceof HistoryFileInfo && !(historyFile = (HistoryFileInfo)element).getDsn().isEmpty() && !historyFile.getDsn().equals(Messages.GetInstallationInformation_TheSubsystemCouldNotBeContacted)) {
                    URI hostUri = FARL.getFARLURI((String)InstallInfoView.this.address, (String)Integer.toString(InstallInfoView.this.port), (String)historyFile.getDsn());
                    FATP unManageHistoryFile = BackendRequests.unmanage_history_file(hostUri);
                    FATP getInstallInfo = BackendRequests.get_installation_info(hostUri);
                    FATPJob job = new FATPJob(Messages.InstallInfo_AttemptingToUnmanage, new FATP[]{unManageHistoryFile, getInstallInfo}, null){

                        protected void finalize_responses(IProgressMonitor _monitor) {
                            for (FATP[] request_response : this.responses) {
                                Throwable throwable = null;
                                Object var5_6 = null;
                                try {
                                    FATP request = request_response[0];
                                    try {
                                        try (FATP response = request_response[1];){
                                            if ("\"installationInfo\"".equals(request.get_request_header("If-Match")) && response.is_successful_response() && response.get_status_code().equals("200")) {
                                                InstallInfoView.this.parseInstallationInfoFromResponse(response);
                                            } else if ("501".equals(response.get_status_code())) {
                                                PDDialogs.openErrorThreadSafe((String)Messages.InstallInfoView_ServerTooOld);
                                            } else if (!response.is_successful_response()) {
                                                PDDialogs.openErrorThreadSafe((String)Messages.InstallInfoView_ErrorUnmanage, (String)response.get_status_reason_phrase());
                                            }
                                        }
                                        if (request == null) continue;
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        if (request != null) {
                                            request.close();
                                        }
                                        throw throwable;
                                    }
                                    request.close();
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    };
                    InstallInfoView.this.runFATPJob((Job)job, unManageHistoryFile);
                }
            }
        });
        tab.setControl((Control)composite);
    }

    public void load() {
        FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        dialog.setFilterNames(new String[]{Messages.GetInstallationInformation_serviceInformationText, Messages.GetInstallationInformation_AllFilesFilterName});
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dialog.setFileName("installationInformation.xml");
        String chosenFile = dialog.open();
        if (chosenFile != null && !chosenFile.isEmpty()) {
            File theFile = new File(chosenFile);
            try {
                XMLMemento loadMementoFromFile = PDXMLMementoUtils.loadMementoFromFile((File)theFile);
                this.setInstallationInfoXML(loadMementoFromFile.toString());
                this.address = loadMementoFromFile.getString("address");
                Integer thePort = loadMementoFromFile.getInteger("port");
                if (thePort != null) {
                    this.port = thePort;
                }
            }
            catch (IOException | WorkbenchException e1) {
                logger.error((Object)MessageFormat.format("Could not save installation information to file {0} - {1}", chosenFile, e1));
                PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.GetInstallationInformation_ErrorSavingInstallationInfo, e1.getMessage()));
            }
        }
    }

    public void saveDisplayedInfo() {
        FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        dialog.setFilterNames(new String[]{Messages.GetInstallationInformation_serviceInformationText, Messages.GetInstallationInformation_AllFilesFilterName});
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dialog.setFileName("installationInformation.xml");
        String chosenFile = dialog.open();
        if (chosenFile != null && !chosenFile.isEmpty()) {
            File theFile = new File(chosenFile);
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(this.installInfo.getRawXml()));
                memento.putString("address", this.address);
                memento.putInteger("port", this.port);
                PDXMLMementoUtils.saveMementoToFile((File)theFile, (XMLMemento)memento);
            }
            catch (IOException | WorkbenchException e1) {
                logger.error((Object)MessageFormat.format("Could not save installation information to file {0} - {1}", chosenFile, e1));
                PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.GetInstallationInformation_ErrorSavingInstallationInfo, e1.getMessage()));
            }
        }
    }

    public void createPartControl(Composite parent) {
        GridLayout fillLayout = GridLayoutFactory.fillDefaults().create();
        GridData fillData = GridDataFactory.fillDefaults().grab(true, true).create();
        Composite composite = GUI.composite((Composite)parent, (Layout)fillLayout, (Object)fillData);
        TabFolder tabFolder = new TabFolder(composite, 0);
        tabFolder.setLayoutData((Object)fillData);
        this.createGeneralTab(tabFolder);
        this.createSubsystemInfoTab(tabFolder);
        this.createManagedHistoryFilesTab(tabFolder);
        this.createExcludedHistoryFilesTab(tabFolder);
        this.modelToView();
    }

    private void createSubsystemInfoTab(TabFolder tabFolder) {
        GridLayout fillLayout = GridLayoutFactory.fillDefaults().create();
        GridData fillData = GridDataFactory.fillDefaults().grab(true, true).create();
        TabItem subsystemInfoTab = new TabItem(tabFolder, 0);
        subsystemInfoTab.setText(Messages.GetInstallationInformation_SubsystemInformation);
        Composite subsystemInfoComposite = GUI.composite((Composite)tabFolder, (Layout)fillLayout, (Object)fillData);
        Composite subsystemInfoPropertiesComposite = GUI.composite((Composite)subsystemInfoComposite, (Layout)GUI.grid.l.standard(), (Object)fillData);
        this.createSubsystemPropertiesTable(subsystemInfoPropertiesComposite);
        subsystemInfoTab.setControl((Control)subsystemInfoComposite);
    }

    private void createSubsystemPropertiesTable(Composite subsystemInfoPropertiesComposite) {
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        subsystemInfoPropertiesComposite.setLayout((Layout)tableColumnLayout);
        this.subsystemPropertiesTable = new TableViewer(subsystemInfoPropertiesComposite, 268503812);
        this.subsystemPropertiesTable.getTable().setLinesVisible(true);
        this.subsystemPropertiesTable.getTable().setHeaderVisible(true);
        this.subsystemPropertiesTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.subsystemPropertiesTable);
        TableViewerColumn module = new TableViewerColumn(this.subsystemPropertiesTable, 0);
        module.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SubsystemInfoItem) {
                    SubsystemInfoItem l2 = (SubsystemInfoItem)element;
                    return l2.getKey();
                }
                return "";
            }

            public String getToolTipText(Object element) {
                if (element instanceof SubsystemInfoItem) {
                    SubsystemInfoItem l2 = (SubsystemInfoItem)element;
                    return l2.getTooltip();
                }
                return "";
            }
        });
        module.getColumn().setText(Messages.InstallInfo_Property);
        tableColumnLayout.setColumnData((Widget)module.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
        TableViewerColumn value = new TableViewerColumn(this.subsystemPropertiesTable, 0);
        value.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof SubsystemInfoItem) {
                    SubsystemInfoItem l2 = (SubsystemInfoItem)element;
                    return l2.getValue();
                }
                return "";
            }

            public String getToolTipText(Object element) {
                if (element instanceof SubsystemInfoItem) {
                    SubsystemInfoItem l2 = (SubsystemInfoItem)element;
                    return l2.getTooltip();
                }
                return "";
            }
        });
        value.getColumn().setText(Messages.GetInstallationInformation_Value);
        tableColumnLayout.setColumnData((Widget)value.getColumn(), (ColumnLayoutData)new ColumnWeightData(2));
    }

    public void displayInfoFor(String inAddress, int inPort) {
        Objects.requireNonNull(inAddress, "Must specify non-null address.");
        Objects.requireNonNull(Integer.valueOf(inPort), "Must specify non-null port.");
        this.address = inAddress;
        this.port = inPort;
        this.refreshInstallationInfo();
    }

    private void modelToView() {
        PDPlatformUIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!InstallInfoView.this.generalPropertiesTable.getTable().isDisposed()) {
                    InstallInfoView.this.generalPropertiesTable.setInput(InstallInfoView.this.installInfo.getProperties());
                }
                if (!InstallInfoView.this.whereFound.isDisposed()) {
                    InstallInfoView.this.whereFound.setText(InstallInfoView.this.installInfo.getOptlmInfo().getWhereFound());
                }
                if (!InstallInfoView.this.loadModulesTable.getTable().isDisposed()) {
                    InstallInfoView.this.loadModulesTable.setInput(InstallInfoView.this.installInfo.getLoadModules());
                }
                if (!InstallInfoView.this.leExitTable.getTable().isDisposed()) {
                    InstallInfoView.this.leExitTable.setInput(InstallInfoView.this.installInfo.getLeExitStatuses());
                }
                if (!InstallInfoView.this.optlmTable.getTable().isDisposed()) {
                    InstallInfoView.this.optlmTable.setInput(InstallInfoView.this.installInfo.getOptlmInfo().getOptlmEntries());
                }
                if (!InstallInfoView.this.subsystemPropertiesTable.getTable().isDisposed()) {
                    InstallInfoView.this.subsystemPropertiesTable.setInput(InstallInfoView.this.installInfo.getSubsystemInfo().getItems());
                }
                if (!InstallInfoView.this.managedHistoryFileViewer.getTable().isDisposed()) {
                    InstallInfoView.this.managedHistoryFileViewer.setInput(InstallInfoView.this.installInfo.getManagedHistoryFiles());
                }
                if (!InstallInfoView.this.excludedHistoryFileViewer.getTable().isDisposed()) {
                    InstallInfoView.this.excludedHistoryFileViewer.setInput(InstallInfoView.this.installInfo.getExcludedHistoryFiles());
                }
                InstallInfoView.this.setPartName(Messages.InstallInfoView_InstallationInfo);
                if (InstallInfoView.this.address != null) {
                    InstallInfoView.this.setPartName(MessageFormat.format(Messages.InstallInfoView_InstallInfoWithAddressPort, Ipv6Utils.bracketWrap((String)InstallInfoView.this.address), Integer.toString(InstallInfoView.this.port)));
                }
                InstallInfoView.showView();
            }
        });
    }

    private void parseInstallationInfoFromResponse(FATP response) {
        Charset charset = CharsetResponseHelper.getCharsetFromResponseOrEnglishFromContentTypeHeader((String)response.get_entity_header("Content-Type"));
        String installInfoXML = response.get_body(charset);
        if (!installInfoXML.isEmpty()) {
            this.setInstallationInfoXML(installInfoXML);
        }
    }

    public void setInstallationInfoXML(String installInfoXML) {
        try {
            this.installInfo = new InstallationInfo(installInfoXML);
            EclipseUtils.retestEclipseProperty((String)"com.ibm.pdtools.common.component.ui.tree", (String)"hasLoadedData");
            this.modelToView();
        }
        catch (WorkbenchException e) {
            logger.error((Object)("Encountered an error when parsing installation info xml:" + e.getMessage()));
            PDDialogs.openErrorThreadSafe((String)Messages.InstallInfoView_ErrorParsingXml, (Throwable)e);
        }
    }

    public void refreshInstallationInfo() {
        if (this.address == null) {
            return;
        }
        URI hostUri = FARL.getFARLURI((String)this.address, (String)Integer.toString(this.port));
        logger.trace((Object)("Loading installation information for: " + String.valueOf(hostUri)));
        FATP getInstallInfo = BackendRequests.get_installation_info(hostUri);
        FATPJob job = new FATPJob(Messages.GetInstallationInformation_LoadingInstallInfo, getInstallInfo){

            protected void finalize_responses(IProgressMonitor _monitor) {
                for (FATP[] request_response : this.responses) {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (FATP response = request_response[1];){
                        if (response.is_successful_response() && response.get_status_code().equals("200")) {
                            InstallInfoView.this.parseInstallationInfoFromResponse(response);
                            continue;
                        }
                        if ("501".equals(response.get_status_code())) {
                            PDDialogs.openErrorThreadSafe((String)Messages.InstallInfoView_ServerTooOld);
                            continue;
                        }
                        if (response.is_successful_response()) continue;
                        PDDialogs.openErrorThreadSafe((String)Messages.InstallInfoView_ErrorGetInstallInfo, (String)response.get_status_reason_phrase());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
        };
        this.runFATPJob((Job)job, getInstallInfo);
    }

    private void runFATPJob(Job job, final FATP request) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                request.close();
            }
        });
        job.setUser(true);
        IWorkbenchSiteProgressService siteProgress = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteProgress != null) {
            siteProgress.schedule(job, 0L, true);
        } else {
            job.schedule();
        }
    }

    public void setFocus() {
    }

    public boolean isDisplayingInfo() {
        String rawXml = this.installInfo.getRawXml();
        return rawXml != null && !rawXml.isEmpty();
    }
}

