/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.install.info.model;

import com.ibm.etools.fa.install.info.core.Messages;
import com.ibm.etools.fa.install.info.model.HistoryFileInfo;
import com.ibm.etools.fa.install.info.model.InstallationInfoGeneralItem;
import com.ibm.etools.fa.install.info.model.LanguageEnvironmentExitStatus;
import com.ibm.etools.fa.install.info.model.LoadModuleInfo;
import com.ibm.etools.fa.install.info.model.OptlmInfo;
import com.ibm.etools.fa.install.info.model.SubsystemInfo;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class InstallationInfo {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private List<InstallationInfoGeneralItem> properties = new ArrayList<InstallationInfoGeneralItem>();
    private String rawXml = "";
    private List<LoadModuleInfo> loadModules = new ArrayList<LoadModuleInfo>();
    private List<LanguageEnvironmentExitStatus> leExitStatuses = new ArrayList<LanguageEnvironmentExitStatus>();
    private OptlmInfo optlmInfo = new OptlmInfo();
    private SubsystemInfo subsystemInfo = new SubsystemInfo(null);
    private List<HistoryFileInfo> managedHistoryFiles = new ArrayList<HistoryFileInfo>();
    private List<HistoryFileInfo> excludedHistoryFiles = new ArrayList<HistoryFileInfo>();

    public InstallationInfo() {
    }

    public InstallationInfo(String xml) throws WorkbenchException {
        IMemento[] historyFileChildren;
        IMemento excludedHistoryFilesMemento;
        int n;
        IMemento[] historyFileChildren2;
        IMemento subsystemInfoMemento;
        IMemento optlmInfoMemento;
        IMemento[] exits;
        IMemento leExitCICSStatusesMemento;
        IMemento[] exits2;
        IMemento leExit64StatusesMemento;
        IMemento[] exits3;
        IMemento leExitStatusesMemento;
        int n2;
        IMemento[] loadModulesChildren;
        IMemento loadModulesMemento;
        IMemento defaultHistoryFileMemento;
        IMemento exitsStatusMemento;
        IMemento svcStatusMemento;
        this.rawXml = xml;
        XMLMemento installInfo = XMLMemento.createReadRoot((Reader)new StringReader(xml));
        IMemento versionMemento = installInfo.getChild("version");
        if (versionMemento != null) {
            this.properties.add(new InstallationInfoGeneralItem(Messages.GetInstallationInformation_Version, versionMemento.getTextData(), ""));
        }
        if ((svcStatusMemento = installInfo.getChild("svcStatus")) != null) {
            this.properties.add(new InstallationInfoGeneralItem(Messages.GetInstallationInformation_SVCStatus, svcStatusMemento.getTextData(), ""));
        }
        if ((exitsStatusMemento = installInfo.getChild("exitsStatus")) != null) {
            String ieavtabxStatic = "";
            IMemento ieavtabxStaticMemento = exitsStatusMemento.getChild("ieavtabxStatic");
            if (ieavtabxStaticMemento != null) {
                ieavtabxStatic = ieavtabxStaticMemento.getTextData();
            }
            String ieavtabxDynamic = "";
            IMemento ieavtabxDynamicMemento = exitsStatusMemento.getChild("ieavtabxDynamic");
            if (ieavtabxDynamicMemento != null) {
                ieavtabxDynamic = ieavtabxDynamicMemento.getTextData();
            }
            if (ieavtabxDynamic != null) {
                this.properties.add(new InstallationInfoGeneralItem(Messages.GetInstallationInformation_ieavtabxExitStatus, ieavtabxDynamic, Messages.GetInstallationInformation_xdcapDynamicTooltip));
            } else if (ieavtabxStatic != null) {
                this.properties.add(new InstallationInfoGeneralItem(Messages.GetInstallationInformation_ieavtabxExitStatus, ieavtabxStatic, Messages.GetInstallationInformation_xdcapStaticTooltip));
            }
            IMemento ieavtselMemento = exitsStatusMemento.getChild("ieavtsel");
            if (ieavtselMemento != null) {
                this.properties.add(new InstallationInfoGeneralItem(Messages.GetInstallationInformation_ieavtselExitStatus, ieavtselMemento.getTextData(), Messages.GetInstallationInformation_ieavtselTooltip));
            }
        }
        if ((defaultHistoryFileMemento = installInfo.getChild("defaultHistoryFile")) != null) {
            this.properties.add(new InstallationInfoGeneralItem(Messages.GetInstallationInformation_DefaultHistoryFile, defaultHistoryFileMemento.getTextData(), ""));
        }
        if ((loadModulesMemento = installInfo.getChild("loadModules")) != null && (loadModulesChildren = loadModulesMemento.getChildren("loadModule")) != null) {
            IMemento[] iMementoArray = loadModulesChildren;
            n2 = loadModulesChildren.length;
            int ieavtselMemento = 0;
            while (ieavtselMemento < n2) {
                IMemento module = iMementoArray[ieavtselMemento];
                if (module != null) {
                    this.loadModules.add(new LoadModuleInfo(module));
                }
                ++ieavtselMemento;
            }
        }
        if ((leExitStatusesMemento = installInfo.getChild("le31ExitStatuses")) != null && (exits3 = leExitStatusesMemento.getChildren("exit")) != null) {
            IMemento[] iMementoArray = exits3;
            int n3 = exits3.length;
            n2 = 0;
            while (n2 < n3) {
                IMemento exitMemento = iMementoArray[n2];
                this.leExitStatuses.add(new LanguageEnvironmentExitStatus(exitMemento, "CEEEXTAN (batch 31-bit)", "IDIXCEE"));
                ++n2;
            }
        }
        if ((leExit64StatusesMemento = installInfo.getChild("le64ExitStatuses")) != null && (exits2 = leExit64StatusesMemento.getChildren("exit")) != null) {
            IMemento[] iMementoArray = exits2;
            int n4 = exits2.length;
            int n5 = 0;
            while (n5 < n4) {
                IMemento exitMemento = iMementoArray[n5];
                this.leExitStatuses.add(new LanguageEnvironmentExitStatus(exitMemento, "CELQXTAN (batch 64-bit)", "IDIXCE64"));
                ++n5;
            }
        }
        if ((leExitCICSStatusesMemento = installInfo.getChild("leCICSExitStatuses")) != null && (exits = leExitCICSStatusesMemento.getChildren("exit")) != null) {
            IMemento[] iMementoArray = exits;
            int n6 = exits.length;
            int n7 = 0;
            while (n7 < n6) {
                IMemento exitMemento = iMementoArray[n7];
                this.leExitStatuses.add(new LanguageEnvironmentExitStatus(exitMemento, "CEECXTAN (CICS)", "IDIXCCEE"));
                ++n7;
            }
        }
        if ((optlmInfoMemento = installInfo.getChild("optlmInfo")) != null) {
            this.optlmInfo = new OptlmInfo(optlmInfoMemento);
        }
        this.subsystemInfo = (subsystemInfoMemento = installInfo.getChild("subsystemInfo")) != null ? new SubsystemInfo(subsystemInfoMemento) : new SubsystemInfo();
        IMemento managedHistoryFilesMemento = installInfo.getChild("managedHistoryFiles");
        if (managedHistoryFilesMemento != null && (historyFileChildren2 = managedHistoryFilesMemento.getChildren("historyFile")) != null) {
            IMemento[] iMementoArray = historyFileChildren2;
            n = historyFileChildren2.length;
            int n8 = 0;
            while (n8 < n) {
                IMemento historyFileMemento = iMementoArray[n8];
                this.managedHistoryFiles.add(new HistoryFileInfo(historyFileMemento));
                ++n8;
            }
        }
        if ((excludedHistoryFilesMemento = installInfo.getChild("excludedHistoryFiles")) != null && (historyFileChildren = excludedHistoryFilesMemento.getChildren("historyFile")) != null) {
            IMemento[] iMementoArray = historyFileChildren;
            int n9 = historyFileChildren.length;
            n = 0;
            while (n < n9) {
                IMemento historyFileMemento = iMementoArray[n];
                this.excludedHistoryFiles.add(new HistoryFileInfo(historyFileMemento));
                ++n;
            }
        }
    }

    public List<HistoryFileInfo> getExcludedHistoryFiles() {
        return this.excludedHistoryFiles;
    }

    public List<LanguageEnvironmentExitStatus> getLeExitStatuses() {
        return this.leExitStatuses;
    }

    public List<LoadModuleInfo> getLoadModules() {
        return this.loadModules;
    }

    public List<HistoryFileInfo> getManagedHistoryFiles() {
        return this.managedHistoryFiles;
    }

    public OptlmInfo getOptlmInfo() {
        return this.optlmInfo;
    }

    public List<InstallationInfoGeneralItem> getProperties() {
        return this.properties;
    }

    public String getRawXml() {
        return this.rawXml;
    }

    public SubsystemInfo getSubsystemInfo() {
        return this.subsystemInfo;
    }
}

