/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.install.info.core;

import com.ibm.etools.fa.install.info.core.Messages;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FARL;
import com.ibm.etools.fa.pdtclient.jhost.ui.fatp.FATP;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Date;

public class BackendRequests {
    public static final String ENTITY_TAG_INSTALLATION_INFO = "\"installationInfo\"";
    public static final String ENTITY_TAG_SUBSYSTEM_UNMANAGE_HISTORY_FILE = "\"subsystemUnmanageHistoryFile\"";
    public static final String ENTITY_TAG_SUBSYSTEM_EXCLUDE_HISTORY_FILE = "\"subsystemExcludeHistoryFile\"";
    public static final String ENTITY_TAG_SUBSYSTEM_UNEXCLUDE_HISTORY_FILE = "\"subsystemUnexcludeHistoryFile\"";
    private static final String CODEPAGE_ENGLISH = "cp1047";
    private static final String CODEPAGE_JAPANESE = "cp939";
    private static final String CODEPAGE_KOREAN = "cp933";

    public static FATP exclude_history_file(URI _uri) {
        FATP fatp = FATP.create_request((String)"GET", (String)FARL.getPathStringIncludingHash((URI)_uri));
        BackendRequests.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_SUBSYSTEM_EXCLUDE_HISTORY_FILE);
        fatp.set_request_header("Accept", "text/xml");
        fatp.append_to_request_header("TE", "trailers");
        fatp.append_to_request_header("TE", "chunked");
        fatp.set_request_description(Messages.BackendRequests_AttemptToExcludeHistoryFile);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    public static FATP get_installation_info(URI _uri) {
        FATP fatp = FATP.create_request((String)"GET", (String)"*");
        BackendRequests.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_INSTALLATION_INFO);
        fatp.set_request_header("Accept", "text/xml");
        fatp.append_to_request_header("TE", "trailers");
        fatp.append_to_request_header("TE", "chunked");
        fatp.set_request_description(Messages.FARL_LoadingInstallationInfo);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    private static void set_request_defaults(FATP _fatp, URI _uri) {
        _fatp.setHostRequestHeader(_uri.getAuthority());
        _fatp.set_request_header("User-Agent", "jhost/1.0 FATP/1.1");
        _fatp.set_request_header("Accept", "text/xml");
        _fatp.append_to_request_header("Accept-Charset", CODEPAGE_ENGLISH);
        _fatp.append_to_request_header("Accept-Charset", CODEPAGE_JAPANESE);
        _fatp.append_to_request_header("Accept-Charset", CODEPAGE_KOREAN);
        _fatp.append_to_request_header("Accept-Charset", StandardCharsets.UTF_8.name());
        _fatp.set_request_header("Accept-Encoding", "identity");
        _fatp.set_request_header("Date", DateFormat.getDateTimeInstance().format(new Date()));
        _fatp.set_request_header("Accept-Language", System.getProperty("user.language"));
    }

    public static FATP unexclude_history_file(URI _uri) {
        FATP fatp = FATP.create_request((String)"GET", (String)FARL.getPathStringIncludingHash((URI)_uri));
        BackendRequests.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_SUBSYSTEM_UNEXCLUDE_HISTORY_FILE);
        fatp.set_request_header("Accept", "text/xml");
        fatp.append_to_request_header("TE", "trailers");
        fatp.append_to_request_header("TE", "chunked");
        fatp.set_request_description(Messages.BackendRequests_AttemptToUnexcludeHistoryFile);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }

    public static FATP unmanage_history_file(URI _uri) {
        FATP fatp = FATP.create_request((String)"GET", (String)FARL.getPathStringIncludingHash((URI)_uri));
        BackendRequests.set_request_defaults(fatp, _uri);
        fatp.set_request_header("If-Match", ENTITY_TAG_SUBSYSTEM_UNMANAGE_HISTORY_FILE);
        fatp.set_request_header("Accept", "text/xml");
        fatp.append_to_request_header("TE", "trailers");
        fatp.append_to_request_header("TE", "chunked");
        fatp.set_request_description(Messages.BackendRequests_AttemptToUnmanageHistoryFile);
        fatp.append_to_request_header("Suppress-Status-Code-Error", "501");
        return fatp;
    }
}

