/* database containing annotations */
/* the format of the file is: sql command followed by GO on a new line */
SET CURRENT SCHEMA = '<schema_name>'
;

CREATE TABLE AnnAttach(
	annID INTEGER NOT NULL,
	k VARGRAPHIC(50) NOT NULL,
	value VARCHAR(1) FOR BIT DATA NOT NULL
) IN DATABASE <db_name> 
;   

CREATE TABLE AnnDetail(
	annID INTEGER NOT NULL,
	k VARGRAPHIC(50) NOT NULL,
	value VARGRAPHIC(500) ,
	project VARGRAPHIC(100) ,
	resType VARGRAPHIC(100) ,
	resName VARGRAPHIC(200) ,
	progType VARGRAPHIC(100) ,
	annResID INTEGER ,
	createdDate TIMESTAMP 
) IN DATABASE <db_name> 
;   

CREATE TABLE Annotation(
	ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
	AID VARGRAPHIC(100) NOT NULL,
	name VARGRAPHIC(50) NOT NULL,
	deleted INTEGER NOT NULL WITH DEFAULT 0
) IN DATABASE <db_name> 
;   
     
CREATE UNIQUE INDEX Annotation_PK_CINDX ON Annotation (ID) CLUSTER
;
ALTER TABLE Annotation ADD CONSTRAINT Annotation_PK PRIMARY KEY (ID)
;

CREATE TABLE AnnResource(
	ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
	annID INTEGER NOT NULL,
	RID VARGRAPHIC(400) NOT NULL 
) IN DATABASE <db_name> 
;   
    
CREATE UNIQUE INDEX AnnResource_PK_CINDX ON AnnResource (ID) CLUSTER
;
ALTER TABLE AnnResource ADD CONSTRAINT AnnResource_PK PRIMARY KEY (ID)
;
	
CREATE TABLE Keyword(
	ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
	name VARGRAPHIC(100) NOT NULL
) IN DATABASE <db_name> 
;   
     
CREATE UNIQUE INDEX Keyword_PK_CINDX ON Keyword (ID) CLUSTER
;
ALTER TABLE Keyword ADD CONSTRAINT Keyword_PK PRIMARY KEY (ID)
;
	 
CREATE TABLE Resource(
	annResID INTEGER NOT NULL,
	projectInfo VARGRAPHIC(250) NOT NULL,
	dbID INTEGER NOT NULL,
	version INTEGER NOT NULL,
	resTypeID INTEGER NOT NULL
) IN DATABASE <db_name> 
;   
     
CREATE TABLE Version(
	version VARCHAR(50) NOT NULL
) IN DATABASE <db_name> 
;   
     
CREATE INDEX AnnResource_RID_ncidx ON AnnResource (RID ASC)
;
CREATE INDEX Ukey_ncidx ON Keyword (name ASC)
;

ALTER TABLE AnnAttach ADD CONSTRAINT attachm_annotation_FK FOREIGN KEY(annID)
REFERENCES Annotation (ID)
ON DELETE CASCADE  
ENFORCED
; 

ALTER TABLE AnnDetail ADD CONSTRAINT detail_annotation_FK FOREIGN KEY(annID)
REFERENCES Annotation (ID)
ON DELETE CASCADE  
ENFORCED
; 

ALTER TABLE AnnResource ADD CONSTRAINT annRes_annotation_FK FOREIGN KEY(annID)
REFERENCES Annotation (ID)
ON DELETE CASCADE  
ENFORCED
; 

ALTER TABLE Resource ADD CONSTRAINT resource_annRes_FK FOREIGN KEY(annResID)
REFERENCES AnnResource (ID)
ON DELETE CASCADE  
ENFORCED
; 
