--#SET TERMINATOR @

CREATE BUFFERPOOL BPDATA32K IMMEDIATE SIZE AUTOMATIC PAGESIZE 32K
@
CREATE BUFFERPOOL BPIDX32K  IMMEDIATE SIZE AUTOMATIC PAGESIZE 32K
@
CREATE BUFFERPOOL BPTEMP32K IMMEDIATE SIZE AUTOMATIC PAGESIZE 32K
@

CREATE REGULAR /*LARGE*/TABLESPACE TS_DATA 
    IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	PAGESIZE 32K 
	MANAGED BY AUTOMATIC STORAGE
	AUTORESIZE YES
    BUFFERPOOL BPDATA32K 
	PREFETCHSIZE AUTOMATIC 
	USING STOGROUP IBMSTOGROUP
	INCREASESIZE 50 M 
	MAXSIZE NONE
@
	
CREATE REGULAR /*LARGE*/TABLESPACE TS_IDX 
    IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	PAGESIZE 32K 
	MANAGED BY AUTOMATIC STORAGE
	AUTORESIZE YES
    BUFFERPOOL BPIDX32K 
	PREFETCHSIZE AUTOMATIC 
	USING STOGROUP IBMSTOGROUP
	INCREASESIZE 50 M 
	MAXSIZE NONE
@	
	
CREATE USER TEMPORARY TABLESPACE TS_TMP  
    IN DATABASE PARTITION GROUP IBMDEFAULTGROUP 
	PAGESIZE 32K 
	MANAGED BY AUTOMATIC STORAGE
	BUFFERPOOL BPTEMP32K
	USING STOGROUP IBMSTOGROUP
@ 


CREATE SCHEMA <schema_name>
@

SET CURRENT SCHEMA = '<schema_name>'
@
SET CURRENT PATH = '<schema_name>'
@
SET CURRENT FUNCTION PATH = '<schema_name>'
@



CREATE TABLE Annotation(
	ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
	AID VARGRAPHIC(100) NOT NULL,
	name VARGRAPHIC(50) NOT NULL,
	deleted INTEGER NOT NULL WITH DEFAULT 0,
	CONSTRAINT Annotation_PK PRIMARY KEY (ID)
)IN TS_DATA 
 INDEX IN TS_IDX 
@   



CREATE TABLE AnnAttach(
	annID INTEGER NOT NULL,
	k VARGRAPHIC(50) NOT NULL,
	value VARCHAR(1) FOR BIT DATA NOT NULL
)IN TS_DATA 
 INDEX IN TS_IDX 
@   
 
ALTER TABLE AnnAttach ADD CONSTRAINT attachm_annotation_FK FOREIGN KEY(annID)
REFERENCES Annotation (ID)
ON DELETE CASCADE  
ENFORCED 
@ 
    


CREATE TABLE AnnDetail(
	annID INTEGER NOT NULL,
	k VARGRAPHIC(50) NOT NULL,
	value VARGRAPHIC(500) ,
	project VARGRAPHIC(100) ,
	resType VARGRAPHIC(100) ,
	resName VARGRAPHIC(200) ,
	progType VARGRAPHIC(100) ,
	annResID INTEGER ,
	createdDate TIMESTAMP 
)IN TS_DATA 
 INDEX IN TS_IDX 
@   
     
ALTER TABLE AnnDetail ADD CONSTRAINT detail_annotation_FK FOREIGN KEY(annID)
REFERENCES Annotation (ID)
ON DELETE CASCADE  
ENFORCED 
@

     

CREATE TABLE AnnResource(
	ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
	annID INTEGER NOT NULL,
	RID VARGRAPHIC(400) NOT NULL, 
	CONSTRAINT AnnResource_PK PRIMARY KEY (ID)
)IN TS_DATA 
 INDEX IN TS_IDX 
@   
 
CREATE INDEX AnnResource_RID_ncidx ON AnnResource (RID ASC) ALLOW REVERSE SCANS 
@ 

ALTER TABLE AnnResource ADD CONSTRAINT annRes_annotation_FK FOREIGN KEY(annID)
REFERENCES Annotation (ID)
ON DELETE CASCADE  
ENFORCED 
@
 
    

CREATE TABLE Keyword(
	ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),
	name VARGRAPHIC(100) NOT NULL,
	CONSTRAINT Keyword_PK PRIMARY KEY (ID)
)IN TS_DATA 
 INDEX IN TS_IDX 
@   
 
CREATE INDEX Ukey_ncidx ON Keyword (name ASC) ALLOW REVERSE SCANS 
@  
     


CREATE TABLE Resource(
	annResID INTEGER NOT NULL,
	projectInfo VARGRAPHIC(250) NOT NULL,
	dbID INTEGER NOT NULL,
	version INTEGER NOT NULL,
	resTypeID INTEGER NOT NULL
)IN TS_DATA 
 INDEX IN TS_IDX 
@  
 
ALTER TABLE Resource ADD CONSTRAINT resource_annRes_FK FOREIGN KEY(annResID)
REFERENCES AnnResource (ID)
ON DELETE CASCADE  
ENFORCED 
@   
     

CREATE TABLE Version(
	version VARCHAR(50) NOT NULL
)IN TS_DATA 
 INDEX IN TS_IDX 
@   

INSERT INTO Version VALUES ('1.1') 
@