/* database containing annotations */
/* the format of the file is: sql command followed by GO on a new line */
CREATE TABLE Annotation (
	[ID] [int] IDENTITY (1,1) NOT NULL PRIMARY KEY,
	[AID] [nvarchar] (100) NOT NULL,
	[name] [nvarchar] (50) NOT NULL,
	[deleted] [int] DEFAULT ((0)) NOT NULL
) ON [PRIMARY]
GO

CREATE TABLE AnnDetail (
	[annID] [int] NOT NULL,
	[k] [nvarchar] (50) NOT NULL,
	[value] [nvarchar] (500),
	[project] [nvarchar] (100),
	[resType] [nvarchar] (100),
	[resName] [nvarchar] (250),
	[progType] [nvarchar] (100),
	[annResID] [int],
	[createdDate] [datetime] 
)
GO

CREATE TABLE AnnAttach (
	[annID] [int] NOT NULL,
	[k] [nvarchar] (50) NOT NULL,
	[value] [varbinary] NOT NULL	
) 
GO

CREATE TABLE AnnResource (
	[ID] [int] IDENTITY (1,1) NOT NULL PRIMARY KEY,
	[annID] [int] NOT NULL,
	[RID] [nvarchar] (800) NOT NULL
) ON [PRIMARY]
GO

CREATE TABLE Resource (
	[annResID] [int] NOT NULL,
	[projectInfo] [nvarchar] (250) NOT NULL,
	[dbID] [int] NOT NULL,
	[version] [int] NOT NULL,
	[resTypeID] [int] NOT NULL
) ON [PRIMARY]
GO

CREATE TABLE Keyword (
	[ID] [int] IDENTITY (1,1) NOT NULL PRIMARY KEY,
	[name] [nvarchar] (100) NOT NULL
) ON [PRIMARY]
GO

CREATE TABLE Version (
	[version] [varchar] (50) NOT NULL,
) ON [PRIMARY]
GO

CREATE UNIQUE INDEX Ukey ON Keyword(name)
GO

CREATE INDEX AnnResource_RID ON AnnResource (RID)
GO

ALTER TABLE AnnDetail ADD 
    CONSTRAINT [FK_detail_annotation] FOREIGN KEY 
    (
        [annid]
    ) REFERENCES Annotation (
        [id]
    ) ON DELETE CASCADE
GO

ALTER TABLE AnnAttach ADD 
    CONSTRAINT [FK_attachm_annotation] FOREIGN KEY 
    (
        [annid]
    ) REFERENCES Annotation (
        [id]
    ) ON DELETE CASCADE
GO

ALTER TABLE AnnResource ADD 
    CONSTRAINT [FK_annRes_annotation] FOREIGN KEY 
    (
        [annid]
    ) REFERENCES Annotation (
        [id]
    ) ON DELETE CASCADE
GO

ALTER TABLE Resource ADD 
    CONSTRAINT [FK_resource_annRes] FOREIGN KEY 
    (
        [annResID]
    ) REFERENCES AnnResource (
        [ID]
    ) ON DELETE CASCADE
GO
