/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.service;

import com.ez.eclient.configuration.ConfigurationFactory;
import com.ez.eclient.configuration.FileReaderFactory;
import com.ez.eclient.configuration.FileWriterFactory;
import com.ez.eclient.configuration.JsonConfigurationFactory;
import com.ez.eclient.configuration.PojoConfigurationFactory;
import com.ez.eclient.configuration.PropertiesConfigurationFactory;
import com.ez.eclient.configuration.ReaderFactory;
import com.ez.eclient.configuration.SuperConfigurationFactory;
import com.ez.eclient.configuration.WriterFactory;
import com.ez.eclient.configuration.service.ConfigurationInterceptorFactory;
import com.ez.eclient.configuration.service.EclipseConfigurationStack;
import com.ez.eclient.configuration.synchro.service.ConfigurationDescription;
import com.ez.eclient.configuration.synchro.service.ConfigurationFormat;
import java.io.File;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseConfigurationStackFactory {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(EclipseConfigurationStackFactory.class);

    public static EclipseConfigurationStack create(String mirrorLocationDir, ConfigurationDescription d, ConfigurationInterceptorFactory interceptorFactory) {
        String location = d.getMirrorLocation();
        PropertiesConfigurationFactory localFactory = null;
        JsonConfigurationFactory serverFactory = null;
        if (location == null) {
            location = mirrorLocationDir;
            L.debug(String.format("%s: mirror location not set, fallback to default.", d.getUniqueId()));
        }
        if (d.getFormat().equals((Object)ConfigurationFormat.Directory)) {
            String rpath = new File(location, String.valueOf(d.getUniqueId()) + ".prefs").getAbsolutePath();
            String rfile = new File(rpath, String.valueOf(d.getUniqueId()) + ".json").getAbsolutePath();
            String lpath = d.getLocalFile();
            String lfile = new File(lpath, String.valueOf(d.getUniqueId()) + ".json").getAbsolutePath();
            serverFactory = new SuperConfigurationFactory((ConfigurationFactory)new JsonConfigurationFactory((ReaderFactory)new FileReaderFactory(new File(rfile)), null), (ConfigurationFactory)new PojoConfigurationFactory((Object)new HashMap<String, String>(rpath){
                {
                    this.put("ez.meta.directory_path", string);
                }
            }, true));
            localFactory = new SuperConfigurationFactory((ConfigurationFactory)new JsonConfigurationFactory((ReaderFactory)new FileReaderFactory(new File(lfile)), (WriterFactory)new FileWriterFactory(new File(lfile))), (ConfigurationFactory)new PojoConfigurationFactory((Object)new HashMap<String, String>(lpath){
                {
                    this.put("ez.meta.directory_path", string);
                }
            }));
        } else if (d.getFormat().equals((Object)ConfigurationFormat.Json)) {
            FileReaderFactory serverReaderFactory = new FileReaderFactory(new File(location, String.valueOf(d.getUniqueId()) + ".prefs"));
            WriterFactory serverWriterFactory = null;
            serverFactory = new JsonConfigurationFactory((ReaderFactory)serverReaderFactory, serverWriterFactory);
            FileReaderFactory localReaderFactory = new FileReaderFactory(new File(d.getLocalFile()));
            FileWriterFactory localWriterFactory = new FileWriterFactory(new File(d.getLocalFile()));
            localFactory = new JsonConfigurationFactory((ReaderFactory)localReaderFactory, (WriterFactory)localWriterFactory);
        } else if (d.getFormat().equals((Object)ConfigurationFormat.EnhancedProperties)) {
            File file = new File(location, String.valueOf(d.getUniqueId()) + ".prefs");
            FileReaderFactory serverReaderFactory = new FileReaderFactory(file);
            serverFactory = new PropertiesConfigurationFactory((ReaderFactory)serverReaderFactory, null);
            FileReaderFactory localReaderFactory = new FileReaderFactory(file);
            localFactory = new PropertiesConfigurationFactory((ReaderFactory)localReaderFactory, null);
        } else {
            throw new IllegalArgumentException("Format not supported: " + d.getFormat());
        }
        return new EclipseConfigurationStack(d.getUniqueId(), (ConfigurationFactory)localFactory, (ConfigurationFactory)serverFactory, interceptorFactory);
    }
}

