/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.service;

import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.ConfigurationFactory;
import com.ez.eclient.configuration.ImutableConfigurationException;
import com.ez.eclient.configuration.MutableConfiguration;
import com.ez.eclient.configuration.MutableConfigurationAdapter;
import com.ez.eclient.configuration.service.ConfigurationInterceptorFactory;
import com.ez.eclient.configuration.service.ConfigurationStack;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseConfigurationStack
implements ConfigurationStack {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(EclipseConfigurationStack.class);
    final String configurationUniqueId;
    Configuration local;
    Configuration server;
    private final Object guard = new Object();
    Configuration current;
    final ConfigurationFactory localFactory;
    final ConfigurationFactory serverFactory;
    final ConfigurationInterceptorFactory interceptorFactory;

    public EclipseConfigurationStack(String configurationUniqueId, ConfigurationFactory localFactory, ConfigurationFactory serverFactory, ConfigurationInterceptorFactory interceptorFactory) {
        if (configurationUniqueId == null) {
            throw new IllegalArgumentException("configurationUniqueId");
        }
        if (localFactory == null) {
            throw new IllegalArgumentException("localFactory");
        }
        if (serverFactory == null) {
            throw new IllegalArgumentException("serverFactory");
        }
        this.configurationUniqueId = configurationUniqueId;
        this.localFactory = localFactory;
        this.serverFactory = serverFactory;
        this.interceptorFactory = interceptorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMapObject(String path) {
        Object object = this.guard;
        synchronized (object) {
            this.ensureConfigs();
            return this.current.getMapObject(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListObject(String path) {
        Object object = this.guard;
        synchronized (object) {
            this.ensureConfigs();
            return this.current.getListObject(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String path) {
        Object object = this.guard;
        synchronized (object) {
            this.ensureConfigs();
            return this.current.getObject(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRootObject() {
        Object object = this.guard;
        synchronized (object) {
            this.ensureConfigs();
            return this.current.getRootObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.guard;
        synchronized (object) {
            this.ensureConfigs();
            boolean success = false;
            try {
                this.server.refresh();
                Boolean isAllowOverwrite = this.getProperty(this.server, "ez.meta.allow_overwrite", true);
                if (!isAllowOverwrite.booleanValue()) {
                    this.forceLocalOverwrite(false);
                }
                this.local.refresh();
                success = true;
            }
            finally {
                if (!success) {
                    this.server = null;
                    this.local = null;
                }
            }
            if (success) {
                success = false;
                try {
                    this.resetCurrent();
                    success = true;
                }
                finally {
                    if (!success) {
                        this.current = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.guard;
        synchronized (object) {
            block16: {
                block14: {
                    if (this.server != null) {
                        try {
                            try {
                                this.server.close();
                            }
                            catch (Exception ex) {
                                L.error("Can't close server configuration.", (Throwable)ex);
                                this.server = null;
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            this.server = null;
                            throw throwable;
                        }
                        this.server = null;
                    }
                }
                if (this.local != null) {
                    try {
                        try {
                            this.local.close();
                        }
                        catch (Exception ex) {
                            L.error("Can't close local configuration.", (Throwable)ex);
                            this.local = null;
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        this.local = null;
                        throw throwable;
                    }
                    this.local = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConfiguration(String scope) {
        Object object = this.guard;
        synchronized (object) {
            Configuration c = null;
            if (scope == null) {
                throw new IllegalArgumentException(scope);
            }
            this.ensureConfigs();
            if (scope.equals("local")) {
                c = this.local;
            } else if (scope.equals("server")) {
                c = this.server;
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableConfiguration getMutableConfiguration(String scope) {
        Object object = this.guard;
        synchronized (object) {
            MutableConfiguration c = this.createMutable(scope);
            return new MutableConfigurationAdapter(c){

                public void close() {
                    L.debug(String.format("Configuration %s saved, refresh.", EclipseConfigurationStack.this.configurationUniqueId));
                    super.close();
                    EclipseConfigurationStack.this.refresh();
                }
            };
        }
    }

    private void ensureConfigs() {
        Configuration c;
        boolean reset = false;
        if (this.local == null) {
            c = this.localFactory.create();
            if (this.interceptorFactory != null) {
                c = this.interceptorFactory.create("local", this.configurationUniqueId, c);
            }
            this.local = c;
            reset = true;
        }
        if (this.server == null) {
            c = this.serverFactory.create();
            if (this.interceptorFactory != null) {
                c = this.interceptorFactory.create("server", this.configurationUniqueId, c);
            }
            this.server = c;
            reset = true;
        }
        if (reset) {
            this.resetCurrent();
        }
    }

    private void resetCurrent() {
        Boolean isOverwrite = this.getProperty(this.local, "ez.meta.overwrite", false);
        Boolean allowOverwrite = this.getProperty(this.server, "ez.meta.allow_overwrite", true);
        if (isOverwrite.booleanValue() && !allowOverwrite.booleanValue()) {
            isOverwrite = false;
            L.debug(String.format("Configuration %s: overwrite set but not allowed, ignore.", this.configurationUniqueId));
        }
        if (isOverwrite.booleanValue()) {
            L.debug(String.format("Configuration %s: local values now on top of the stack.", this.configurationUniqueId));
            this.current = this.local;
        } else {
            L.debug(String.format("Configuration %s: server values now on top of the stack.", this.configurationUniqueId));
            this.current = this.server;
        }
    }

    private MutableConfiguration createMutable(String scope) {
        MutableConfiguration c = null;
        if (scope.equals("local")) {
            c = this.localFactory.createMutable();
        } else if (scope.equals("server")) {
            throw new ImutableConfigurationException("Read only context: " + scope);
        }
        return c;
    }

    private Boolean getProperty(Configuration c, String key, boolean defaultValue) {
        Object o = c.getObject(key);
        Boolean ob = defaultValue;
        if (o != null) {
            if (o instanceof Boolean) {
                ob = (Boolean)o;
            } else if (o instanceof String) {
                ob = Boolean.valueOf((String)o);
            } else {
                L.error(String.format("Configuration %s: property %s not string nor boolean.", this.configurationUniqueId, "ez.meta.overwrite"));
            }
        }
        return ob;
    }

    private void forceLocalOverwrite(boolean value) {
        try (MutableConfiguration mc = this.createMutable("local");){
            mc.setProperty("ez.meta.overwrite", (Object)value);
        }
    }
}

