/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.service;

import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.MutableConfiguration;
import com.ez.eclient.configuration.service.ConfigurationService;
import com.ez.eclient.configuration.service.ConfigurationStack;
import com.ez.eclient.configuration.service.Configurator;
import com.ez.eclient.configuration.service.SingletonConfigurationStack;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurationService
extends ConfigurationService {
    private static final Logger L = LoggerFactory.getLogger(DefaultConfigurationService.class);
    private final Map<String, ConfigurationStack> configs = new HashMap<String, ConfigurationStack>();
    private final Object guard = new Object();

    public DefaultConfigurationService() {
        List<Configurator> confs = this.loadExtensions();
        Properties p = new Properties();
        for (Configurator c : confs) {
            try {
                c.preConfigure(p);
            }
            catch (Exception ex) {
                L.error("Can't execute extension: " + c, (Throwable)ex);
            }
        }
        for (Configurator c : confs) {
            try {
                c.postConfigure(this);
            }
            catch (Exception ex) {
                L.error("Can't execute extension: " + c, (Throwable)ex);
            }
        }
    }

    @Override
    public Map getMapObject(String configurationUniqueId, String propertyPath) {
        ConfigurationStack c = this.find(configurationUniqueId);
        if (c != null) {
            return c.getMapObject(propertyPath);
        }
        return null;
    }

    @Override
    public List getListObject(String configurationUniqueId, String propertyPath) {
        ConfigurationStack c = this.find(configurationUniqueId);
        if (c != null) {
            return c.getListObject(propertyPath);
        }
        return null;
    }

    @Override
    public Object getObject(String configurationUniqueId, String propertyPath) {
        ConfigurationStack c = this.find(configurationUniqueId);
        if (c != null) {
            return c.getObject(propertyPath);
        }
        return null;
    }

    @Override
    public Object getRootObject(String configurationUniqueId) {
        ConfigurationStack c = this.find(configurationUniqueId);
        if (c != null) {
            return c.getRootObject();
        }
        return null;
    }

    @Override
    public Configuration getConfiguration(String configurationUniqueId) {
        return this.find(configurationUniqueId);
    }

    @Override
    public Configuration getConfiguration(String configurationUniqueId, String scope) {
        Configuration c = null;
        ConfigurationStack cs = this.find(configurationUniqueId);
        if (cs != null) {
            c = cs.getConfiguration(scope);
        }
        return c;
    }

    @Override
    public MutableConfiguration getMutableConfiguration(String configurationUniqueId, String scope) {
        MutableConfiguration mc = null;
        ConfigurationStack cs = this.find(configurationUniqueId);
        if (cs != null) {
            mc = cs.getMutableConfiguration(scope);
        }
        return mc;
    }

    public void registerConfiguration(String configurationUniqueId, ConfigurationStack configuration) {
        this.registerConfiguration(configurationUniqueId, (Configuration)configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfiguration(String configurationUniqueId, Configuration configuration) {
        Object object = this.guard;
        synchronized (object) {
            if (this.configs.containsKey(configurationUniqueId)) {
                throw new IllegalArgumentException("Already registered.");
            }
            Configuration c = configuration;
            if (!(configuration instanceof ConfigurationStack)) {
                c = new SingletonConfigurationStack(c);
                this.configs.put(configurationUniqueId, new SingletonConfigurationStack(configuration));
            } else {
                this.configs.put(configurationUniqueId, (ConfigurationStack)configuration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration unregisterConfiguration(String configurationUniqueId) {
        Object object = this.guard;
        synchronized (object) {
            Configuration c = this.configs.remove(configurationUniqueId);
            if (c == null) {
                L.error("Configuration not found: " + configurationUniqueId);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshConfiguration(String configurationUniqueId) {
        ConfigurationStack c;
        Object object = this.guard;
        synchronized (object) {
            c = this.find(configurationUniqueId);
        }
        if (c == null) {
            throw new IllegalArgumentException("Configuration not found: " + configurationUniqueId);
        }
        c.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationStack find(String configurationUniqueId) {
        Object object = this.guard;
        synchronized (object) {
            return this.configs.get(configurationUniqueId);
        }
    }

    private List<Configurator> loadExtensions() {
        LinkedList<Configurator> cl = new LinkedList<Configurator>();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ez.eclient.configuration.service.configurator");
        if (configs != null) {
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                Object e = null;
                try {
                    e = ce.createExecutableExtension("class");
                }
                catch (CoreException ex) {
                    L.error("Can't create extension.", (Throwable)ex);
                }
                if (e != null && e instanceof Configurator) {
                    cl.add((Configurator)e);
                }
                ++n2;
            }
        }
        return cl;
    }
}

