/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRDataUtils;

public final class WebUtil {
    public static final String REQUEST_PARAMETER_REPORT_URI = "jr_report_uri";
    public static final String REQUEST_PARAMETER_ASYNC_REPORT = "jr_async";
    public static final String REQUEST_PARAMETER_PAGE = "jr_page";
    public static final String REQUEST_PARAMETER_PAGE_TIMESTAMP = "jr_page_timestamp";
    public static final String REQUEST_PARAMETER_PAGE_UPDATE = "jr_page_update";
    public static final String REQUEST_PARAMETER_RUN_REPORT = "jr_run";
    public static final String RESOURCE_JR_GLOBAL_CSS = "net/sf/jasperreports/web/servlets/resources/jasperreports-global.css";
    public static final String PROPERTY_REQUEST_PARAMETER_RESOURCE_URI = "net.sf.jasperreports.web.request.parameter.resource.uri";
    public static final String PROPERTY_REQUEST_PARAMETER_RESOURCE_LOCALE = "net.sf.jasperreports.web.request.parameter.resource.locale";
    public static final String PROPERTY_REQUEST_PARAMETER_RESOURCE_BUNDLE = "net.sf.jasperreports.web.request.parameter.resource.bundle";
    public static final String PROPERTY_REQUEST_PARAMETER_DYNAMIC_RESOURCE = "net.sf.jasperreports.web.request.parameter.dynamic.resource";
    public static final String PROPERTY_REPORT_EXECUTION_PATH = "net.sf.jasperreports.web.report.execution.path";
    public static final String PROPERTY_REPORT_INTERACTION_PATH = "net.sf.jasperreports.web.report.interaction.path";
    public static final String PROPERTY_REPORT_RESOURCES_PATH = "net.sf.jasperreports.web.report.resources.path";
    public static final String PROPERTY_EMBED_COMPONENT_METADATA = "net.sf.jasperreports.web.embed.component.metadata.in.html.output";
    public static final String EXCEPTION_MESSAGE_KEY_CONFIG_PROPERTY_NOT_SET = "web.util.config.property.not.set";
    private JasperReportsContext jasperReportsContext;
    private JRPropertiesUtil propertiesUtil;

    private WebUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
    }

    public static WebUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new WebUtil(jasperReportsContext);
    }

    public String getReportExecutionPath() {
        String path = this.propertiesUtil.getProperty(PROPERTY_REPORT_EXECUTION_PATH);
        if (path == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CONFIG_PROPERTY_NOT_SET, PROPERTY_REPORT_EXECUTION_PATH);
        }
        return path;
    }

    public String getReportInteractionPath() {
        String path = this.propertiesUtil.getProperty(PROPERTY_REPORT_INTERACTION_PATH);
        if (path == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CONFIG_PROPERTY_NOT_SET, PROPERTY_REPORT_INTERACTION_PATH);
        }
        return path;
    }

    public String getResourcesPath() {
        String path = this.propertiesUtil.getProperty(PROPERTY_REPORT_RESOURCES_PATH);
        if (path == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CONFIG_PROPERTY_NOT_SET, PROPERTY_REPORT_RESOURCES_PATH);
        }
        return path;
    }

    public String getResourceUri(HttpServletRequest request) {
        String resourceUriParamName = this.propertiesUtil.getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_URI);
        return request.getParameter(resourceUriParamName);
    }

    public Locale getResourceLocale(HttpServletRequest request) {
        String resourceLocaleParamName = this.propertiesUtil.getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_LOCALE);
        String localeCode = request.getParameter(resourceLocaleParamName);
        return localeCode == null ? null : JRDataUtils.getLocale(localeCode);
    }

    public String getResourceBundleForResource(HttpServletRequest request) {
        String resourceBundleParamName = this.propertiesUtil.getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_BUNDLE);
        return request.getParameter(resourceBundleParamName);
    }

    public boolean isDynamicResource(HttpServletRequest request) {
        String dynamicResourceParamName = this.propertiesUtil.getProperty(PROPERTY_REQUEST_PARAMETER_DYNAMIC_RESOURCE);
        return Boolean.parseBoolean(request.getParameter(dynamicResourceParamName));
    }

    public String getResourcesBasePath() {
        String resourcesBasePath = this.getResourcesPath();
        String resourceUriParamName = this.propertiesUtil.getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_URI);
        return resourcesBasePath + "?" + resourceUriParamName + "=";
    }

    public String getResourcePath(String resourcePath) {
        return this.getResourcePath(this.getResourcesBasePath(), resourcePath, false);
    }

    public String getResourcePath(String resourcePath, boolean isDynamic) {
        return this.getResourcePath(this.getResourcesBasePath(), resourcePath, isDynamic);
    }

    public String getResourcePath(String resourcesBasePath, String resourcePath) {
        return this.getResourcePath(resourcesBasePath, resourcePath, false);
    }

    public String getResourcePath(String resourcesBasePath, String resourcePath, boolean isDynamic) {
        String resourceDynamicParamName = this.propertiesUtil.getProperty(PROPERTY_REQUEST_PARAMETER_DYNAMIC_RESOURCE);
        return resourcesBasePath + resourcePath + (isDynamic ? "&" + resourceDynamicParamName + "=" + isDynamic : "");
    }

    public String getResourcePath(String resourcesBasePath, String resourcePath, String resourceBundleName, Locale locale) {
        String resourceBundleParamName = this.propertiesUtil.getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_BUNDLE);
        String resourceLocaleParamName = this.propertiesUtil.getProperty(PROPERTY_REQUEST_PARAMETER_RESOURCE_LOCALE);
        return this.getResourcePath(resourcesBasePath, resourcePath, false) + "&" + resourceBundleParamName + "=" + resourceBundleName + "&" + resourceLocaleParamName + "=" + JRDataUtils.getLocaleCode(locale);
    }

    public boolean isComponentMetadataEmbedded() {
        return Boolean.parseBoolean(this.propertiesUtil.getProperty(PROPERTY_EMBED_COMPONENT_METADATA));
    }

    public static String encodeUrl(String url) {
        if (url != null) {
            try {
                return URLEncoder.encode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new JRRuntimeException(e);
            }
        }
        return null;
    }

    public static String decodeUrl(String url) {
        if (url != null) {
            try {
                return URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new JRRuntimeException(e);
            }
        }
        return null;
    }
}

