/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.web.util.AbstractWebResourceHandler;
import net.sf.jasperreports.web.util.SimpleWebResource;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebResource;
import net.sf.jasperreports.web.util.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWebResourceHandler
extends AbstractWebResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebResourceHandler.class);
    private static DefaultWebResourceHandler INSTANCE = new DefaultWebResourceHandler();

    private DefaultWebResourceHandler() {
    }

    public static DefaultWebResourceHandler getInstance() {
        return INSTANCE;
    }

    public boolean handlesResource(String resource) {
        return true;
    }

    @Override
    public WebResource getResource(JasperReportsContext jasperReportsContext, HttpServletRequest request, String resourceUri) {
        SimpleWebResource resource = null;
        if (resourceUri != null && this.checkResourceName(jasperReportsContext, resourceUri)) {
            WebUtil webUtil = WebUtil.getInstance(jasperReportsContext);
            boolean isDynamicResource = webUtil.isDynamicResource(request);
            String resourceBundleName = webUtil.getResourceBundleForResource(request);
            Locale locale = webUtil.getResourceLocale(request);
            byte[] bytes = null;
            try {
                if (resourceUri.indexOf(".vm.") != -1 && (isDynamicResource || resourceBundleName != null || locale != null)) {
                    HashMap<String, Object> contextMap = new HashMap<String, Object>();
                    contextMap.put("path", request.getContextPath() + webUtil.getResourcesBasePath());
                    locale = locale == null ? Locale.getDefault() : locale;
                    contextMap.put("msgProvider", MessageUtil.getInstance(jasperReportsContext).getLocalizedMessageProvider(resourceBundleName, locale));
                    String resourceString = VelocityUtil.processTemplate(resourceUri, contextMap);
                    if (resourceString != null) {
                        bytes = resourceString.getBytes("UTF-8");
                    }
                } else {
                    bytes = JRLoader.loadBytesFromResource(resourceUri);
                }
            }
            catch (IOException | JRException e) {
                throw new JRRuntimeException(e);
            }
            resource = new SimpleWebResource();
            resource.setData(bytes);
            if (resourceUri != null && resourceUri.lastIndexOf(".") != -1) {
                resource.setType(resourceUri.substring(resourceUri.lastIndexOf(".") + 1));
            }
        }
        return resource;
    }

    protected boolean checkResourceName(JasperReportsContext jasperReportsContext, String resourceName) {
        try {
            resourceName = new URI(null, null, resourceName, null).normalize().getPath();
        }
        catch (URISyntaxException e) {
            throw new JRRuntimeException(e);
        }
        boolean matched = false;
        List<JRPropertiesUtil.PropertySuffix> patternProps = JRPropertiesUtil.getInstance(jasperReportsContext).getProperties("net.sf.jasperreports.web.resource.pattern.");
        for (JRPropertiesUtil.PropertySuffix patternProp : patternProps) {
            Pattern resourcePattern;
            String patternStr = patternProp.getValue();
            if (patternStr == null || patternStr.length() <= 0 || !(resourcePattern = Pattern.compile(patternStr)).matcher(resourceName).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug("resource " + resourceName + " matched pattern " + resourcePattern);
            }
            matched = true;
            break;
        }
        if (!matched && log.isDebugEnabled()) {
            log.debug("Resource " + resourceName + " does not matched any allowed pattern");
        }
        return matched;
    }
}

