/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.web.JRInteractiveException;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.Action;
import net.sf.jasperreports.web.actions.MultiAction;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.servlets.Controller;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import net.sf.jasperreports.web.servlets.ReportPageStatus;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.ReportExecutionHyperlinkProducerFactory;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;
    private static final Logger log = LoggerFactory.getLogger(ReportServlet.class);
    private static final String TEMPLATE_HEADER = "net/sf/jasperreports/web/servlets/resources/templates/HeaderTemplate.vm";
    private static final String TEMPLATE_BETWEEN_PAGES = "net/sf/jasperreports/web/servlets/resources/templates/BetweenPagesTemplate.vm";
    private static final String TEMPLATE_FOOTER = "net/sf/jasperreports/web/servlets/resources/templates/FooterTemplate.vm";
    private static final String TEMPLATE_HEADER_NOPAGES = "net/sf/jasperreports/web/servlets/resources/templates/HeaderTemplateNoPages.vm";
    private static final String TEMPLATE_FOOTER_NOPAGES = "net/sf/jasperreports/web/servlets/resources/templates/FooterTemplateNoPages.vm";
    private static final String REQUEST_PARAMETER_IGNORE_PAGINATION = "jr_ignrpg";
    private static final String REQUEST_PARAMETER_ACTION = "jr_action";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        PrintWriter out = response.getWriter();
        WebReportContext webReportContext = WebReportContext.getInstance(request);
        try {
            if (request.getParameterMap().containsKey("jr_page_update")) {
                this.pageUpdate(request, response, webReportContext);
            } else {
                this.runReport(request, webReportContext);
                this.render(request, webReportContext, out);
            }
        }
        catch (JRInteractiveException e) {
            log.error("Jasper Interactive error", (Throwable)e);
            out.println("<div><pre id=\"jrInteractiveError\">");
            if (e.getMessage() != null && e.getMessage().indexOf("<#_#>") != -1) {
                String[] tokens;
                for (String token : tokens = e.getMessage().split("<#_#>")) {
                    out.println(token);
                }
            } else {
                out.println(e.getMessage());
            }
            out.println("</pre></div>");
        }
        catch (Exception e) {
            log.error("Error on report execution", (Throwable)e);
            response.setContentType("application/json; charset=UTF-8");
            response.setStatus(404);
            out.println("{");
            out.println("\"msg\": \"JasperReports encountered an error!\"");
            out.println("}");
        }
    }

    public void runReport(HttpServletRequest request, WebReportContext webReportContext) throws JRException, JRInteractiveException {
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        String runReport = request.getParameter("jr_run");
        if (jasperPrintAccessor == null || Boolean.valueOf(runReport).booleanValue()) {
            String async;
            Boolean isIgnorePagination;
            String reportUri = request.getParameter("jr_report_uri");
            if (reportUri != null) {
                webReportContext.setParameterValue("jr_report_uri", reportUri);
            }
            if ((isIgnorePagination = Boolean.valueOf(request.getParameter(REQUEST_PARAMETER_IGNORE_PAGINATION))) != null) {
                webReportContext.setParameterValue("IS_IGNORE_PAGINATION", isIgnorePagination);
            }
            if ((async = request.getParameter("jr_async")) != null) {
                webReportContext.setParameterValue("jr_async", Boolean.valueOf(async));
            }
            Action action = this.getAction(webReportContext, WebUtil.decodeUrl(request.getParameter(REQUEST_PARAMETER_ACTION)));
            Controller controller = new Controller(this.getJasperReportsContext());
            controller.runReport(webReportContext, action);
        }
    }

    public void render(HttpServletRequest request, WebReportContext webReportContext, PrintWriter writer) throws JRException {
        ReportPageStatus pageStatus;
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        ReportExecutionStatus reportStatus = jasperPrintAccessor.getReportStatus();
        if (reportStatus.getStatus() == ReportExecutionStatus.Status.ERROR) {
            throw new JRRuntimeException("Error occurred during report generation", reportStatus.getError());
        }
        boolean hasPages = jasperPrintAccessor.pageStatus(0, null).pageExists();
        HtmlExporter exporter = new HtmlExporter(this.getJasperReportsContext());
        if (hasPages) {
            String pageTimestamp;
            Long timestamp;
            String reportPage = request.getParameter("jr_page");
            int pageIdx = reportPage == null ? 0 : Integer.parseInt(reportPage);
            pageStatus = jasperPrintAccessor.pageStatus(pageIdx, timestamp = (pageTimestamp = request.getParameter("jr_page_timestamp")) == null ? null : Long.valueOf(pageTimestamp));
            if (!pageStatus.pageExists()) {
                throw new JRRuntimeException("Page " + pageIdx + " not found in report");
            }
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, pageIdx);
        } else {
            pageStatus = ReportPageStatus.PAGE_FINAL;
        }
        exporter.setReportContext(webReportContext);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrintAccessor.getJasperPrint());
        exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, writer);
        exporter.setParameter(JRHtmlExporterParameter.IMAGES_URI, "image?jr_ctxid=" + webReportContext.getId() + "&image=");
        exporter.setParameter(JRHtmlExporterParameter.HTML_HEADER, this.getHeader(request, webReportContext, hasPages, pageStatus));
        exporter.setParameter(JRHtmlExporterParameter.BETWEEN_PAGES_HTML, this.getBetweenPages(request, webReportContext));
        exporter.setParameter(JRHtmlExporterParameter.HTML_FOOTER, this.getFooter(request, webReportContext, hasPages, pageStatus));
        exporter.setParameter(JRHtmlExporterParameter.HYPERLINK_PRODUCER_FACTORY, ReportExecutionHyperlinkProducerFactory.getInstance(this.getJasperReportsContext(), request));
        exporter.exportReport();
    }

    protected String getHeader(HttpServletRequest request, WebReportContext webReportContext, boolean hasPages, ReportPageStatus pageStatus) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        contextMap.put("totalPages", jasperPrintAccessor.getReportStatus().getTotalPageCount());
        String reportPage = request.getParameter("jr_page");
        contextMap.put("currentPage", reportPage != null ? reportPage : "0");
        if (!pageStatus.isPageFinal()) {
            contextMap.put("pageTimestamp", String.valueOf(pageStatus.getTimestamp()));
        }
        if (hasPages) {
            return VelocityUtil.processTemplate(TEMPLATE_HEADER, contextMap);
        }
        return VelocityUtil.processTemplate(TEMPLATE_HEADER_NOPAGES, contextMap);
    }

    protected String getBetweenPages(HttpServletRequest request, WebReportContext webReportContext) {
        return VelocityUtil.processTemplate(TEMPLATE_BETWEEN_PAGES, new HashMap<String, Object>());
    }

    protected String getFooter(HttpServletRequest request, WebReportContext webReportContext, boolean hasPages, ReportPageStatus pageStatus) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        if (hasPages) {
            return VelocityUtil.processTemplate(TEMPLATE_FOOTER, contextMap);
        }
        return VelocityUtil.processTemplate(TEMPLATE_FOOTER_NOPAGES, contextMap);
    }

    private Action getAction(ReportContext webReportContext, String jsonData) {
        Action result = null;
        List<AbstractAction> actions = JacksonUtil.getInstance(this.getJasperReportsContext()).loadAsList(jsonData, AbstractAction.class);
        if (actions != null) {
            if (actions.size() == 1) {
                result = actions.get(0);
            } else if (actions.size() > 1) {
                result = new MultiAction(actions);
            }
            ((AbstractAction)result).init(this.getJasperReportsContext(), webReportContext);
        }
        return result;
    }

    protected void pageUpdate(HttpServletRequest request, HttpServletResponse response, WebReportContext webReportContext) throws JRException, IOException {
        Long pageTimestamp;
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        if (jasperPrintAccessor == null) {
            throw new JRRuntimeException("Did not find the report on the session.");
        }
        String pageIdxParam = request.getParameter("jr_page");
        Integer pageIndex = pageIdxParam == null ? null : Integer.valueOf(pageIdxParam);
        String pageTimestampParam = request.getParameter("jr_page_timestamp");
        Long l = pageTimestamp = pageTimestampParam == null ? null : Long.valueOf(pageTimestampParam);
        if (log.isDebugEnabled()) {
            log.debug("report page update check for pageIndex: " + pageIndex + ", pageTimestamp: " + pageTimestamp);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.putReportStatusResult(response, jasperPrintAccessor, result);
        if (pageIndex != null && pageTimestamp != null) {
            ReportPageStatus pageStatus = jasperPrintAccessor.pageStatus(pageIndex, pageTimestamp);
            boolean modified = pageStatus.hasModified();
            result.put("pageModified", modified);
            if (log.isDebugEnabled()) {
                log.debug("page " + pageIndex + " modified " + modified);
            }
        }
        String resultString = JacksonUtil.getInstance(this.getJasperReportsContext()).getJsonString(result);
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        out.write(resultString);
        out.flush();
    }

    protected void putReportStatusResult(HttpServletResponse response, JasperPrintAccessor printAccessor, LinkedHashMap<String, Object> result) throws JRException {
        String status;
        ReportExecutionStatus reportStatus = printAccessor.getReportStatus();
        result.put("partialPageCount", reportStatus.getCurrentPageCount());
        switch (reportStatus.getStatus()) {
            case FINISHED: {
                status = "finished";
                Integer totalPageCount = reportStatus.getTotalPageCount();
                result.put("totalPages", totalPageCount);
                if (!log.isDebugEnabled()) break;
                log.debug("report finished " + totalPageCount + " pages");
                break;
            }
            case ERROR: {
                status = "error";
                this.handleReportUpdateError(response, reportStatus);
                break;
            }
            case CANCELED: {
                status = "canceled";
                if (!log.isDebugEnabled()) break;
                log.debug("report canceled");
                break;
            }
            default: {
                status = "running";
                if (!log.isDebugEnabled()) break;
                log.debug("report running");
            }
        }
        result.put("status", status);
    }

    protected void handleReportUpdateError(HttpServletResponse response, ReportExecutionStatus reportStatus) throws JRException {
        Throwable error = reportStatus.getError();
        if (log.isDebugEnabled()) {
            log.debug("report error " + error);
        }
        response.setHeader("reportError", "true");
        response.setHeader("lastPartialPageIndex", Integer.toString(reportStatus.getCurrentPageCount() - 1));
        if (error instanceof JRException) {
            throw (JRException)error;
        }
        if (error instanceof JRRuntimeException) {
            throw (JRRuntimeException)error;
        }
        throw new JRRuntimeException("Error generating report", error);
    }
}

