/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import net.sf.jasperreports.web.servlets.ReportPageStatus;
import net.sf.jasperreports.web.util.JacksonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportPageStatusServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;
    private static final Logger log = LoggerFactory.getLogger(ReportPageStatusServlet.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json; charset=UTF-8");
        this.setNoExpire(response);
        PrintWriter out = response.getWriter();
        String contextId = request.getParameter("jr_ctxid");
        if (contextId != null && request.getHeader("accept").indexOf("application/json") >= 0) {
            WebReportContext webReportContext = WebReportContext.getInstance(request, false);
            if (webReportContext == null) {
                response.setStatus(404);
                out.println("{\"msg\": \"Resource with id '" + contextId + "' not found!\"}");
                return;
            }
            try {
                this.pageUpdate(request, response, webReportContext);
                return;
            }
            catch (Exception e) {
                log.error("Error on page status update", (Throwable)e);
                response.setStatus(404);
                out.println("{\"msg\": \"JasperReports encountered an error on page status update!\"}");
                return;
            }
        }
        response.setStatus(400);
        out.println("{\"msg\": \"Wrong parameters!\"}");
    }

    protected void pageUpdate(HttpServletRequest request, HttpServletResponse response, WebReportContext webReportContext) throws JRException, IOException {
        Long pageTimestamp;
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        if (jasperPrintAccessor == null) {
            throw new JRRuntimeException("Did not find the report on the session.");
        }
        String pageIdxParam = request.getParameter("jr_page");
        Integer pageIndex = pageIdxParam == null ? null : Integer.valueOf(pageIdxParam);
        String pageTimestampParam = request.getParameter("jr_page_timestamp");
        Long l = pageTimestamp = pageTimestampParam == null ? null : Long.valueOf(pageTimestampParam);
        if (log.isDebugEnabled()) {
            log.debug("report page update check for pageIndex: " + pageIndex + ", pageTimestamp: " + pageTimestamp);
        }
        LinkedHashMap<String, Object> reportStatus = new LinkedHashMap<String, Object>();
        this.putReportStatusResult(response, jasperPrintAccessor, reportStatus);
        if (pageIndex != null && pageTimestamp != null) {
            ReportPageStatus pageStatus = jasperPrintAccessor.pageStatus(pageIndex, pageTimestamp);
            boolean modified = pageStatus.hasModified();
            reportStatus.put("pageModified", modified);
            reportStatus.put("pageFinal", pageStatus.isPageFinal());
            if (log.isDebugEnabled()) {
                log.debug("page " + pageIndex + " modified " + modified);
            }
        }
        HashMap<String, LinkedHashMap<String, Object>> result = new HashMap<String, LinkedHashMap<String, Object>>();
        result.put("result", reportStatus);
        String resultString = JacksonUtil.getInstance(this.getJasperReportsContext()).getJsonString(result);
        PrintWriter out = response.getWriter();
        out.write(resultString);
        out.flush();
    }

    protected void putReportStatusResult(HttpServletResponse response, JasperPrintAccessor printAccessor, Map<String, Object> result) throws JRException {
        String status;
        ReportExecutionStatus reportStatus = printAccessor.getReportStatus();
        result.put("lastPartialPageIndex", reportStatus.getCurrentPageCount() - 1);
        switch (reportStatus.getStatus()) {
            case FINISHED: {
                status = "finished";
                Integer totalPageCount = reportStatus.getTotalPageCount();
                result.put("lastPageIndex", totalPageCount - 1);
                if (!log.isDebugEnabled()) break;
                log.debug("report finished " + totalPageCount + " pages");
                break;
            }
            case ERROR: {
                status = "error";
                this.handleReportUpdateError(response, reportStatus);
                break;
            }
            case CANCELED: {
                status = "canceled";
                if (!log.isDebugEnabled()) break;
                log.debug("report canceled");
                break;
            }
            default: {
                status = "running";
                if (!log.isDebugEnabled()) break;
                log.debug("report running");
            }
        }
        result.put("status", status);
    }

    protected void handleReportUpdateError(HttpServletResponse response, ReportExecutionStatus reportStatus) throws JRException {
        Throwable error = reportStatus.getError();
        if (log.isDebugEnabled()) {
            log.debug("report error " + error);
        }
        response.setHeader("reportError", "true");
        response.setHeader("lastPartialPageIndex", Integer.toString(reportStatus.getCurrentPageCount() - 1));
        if (error instanceof JRException) {
            throw (JRException)error;
        }
        if (error instanceof JRRuntimeException) {
            throw (JRRuntimeException)error;
        }
        throw new JRRuntimeException("Error generating report", error);
    }
}

