/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.swing;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.swing.JRViewerController;
import net.sf.jasperreports.swing.JRViewerEvent;
import net.sf.jasperreports.swing.JRViewerListener;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.SaveContributorUtils;
import net.sf.jasperreports.view.save.JRPrintSaveContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRViewerToolbar
extends JPanel
implements JRViewerListener {
    private static final Logger log = LoggerFactory.getLogger(JRViewerToolbar.class);
    private static final long serialVersionUID = 10200L;
    protected final JRViewerController viewerContext;
    protected final float MIN_ZOOM = 0.5f;
    protected final float MAX_ZOOM = 10.0f;
    protected int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250, 400, 800};
    protected int defaultZoomIndex = 2;
    protected List<JRSaveContributor> saveContributors = new ArrayList<JRSaveContributor>();
    protected File lastFolder;
    protected JRSaveContributor lastSaveContributor;
    protected DecimalFormat zoomDecimalFormat;
    protected JToggleButton btnActualSize;
    protected JButton btnFirst;
    protected JToggleButton btnFitPage;
    protected JToggleButton btnFitWidth;
    protected JButton btnLast;
    protected JButton btnNext;
    protected JButton btnPrevious;
    protected JButton btnPrint;
    protected JButton btnReload;
    protected JButton btnSave;
    protected JButton btnZoomIn;
    protected JButton btnZoomOut;
    protected JComboBox cmbZoom;
    protected JPanel pnlSep01;
    protected JPanel pnlSep02;
    protected JPanel pnlSep03;
    protected JTextField txtGoTo;

    public JRViewerToolbar(JRViewerController viewerContext) {
        this.viewerContext = viewerContext;
        this.viewerContext.addListener(this);
        this.zoomDecimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(viewerContext.getLocale()));
        this.initComponents();
        this.initSaveContributors();
    }

    private void initComponents() {
        this.btnSave = new JButton();
        this.btnPrint = new JButton();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.btnFirst = new JButton();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.btnLast = new JButton();
        this.txtGoTo = new JTextField();
        this.pnlSep02 = new JPanel();
        this.btnActualSize = new JToggleButton();
        this.btnFitPage = new JToggleButton();
        this.btnFitWidth = new JToggleButton();
        this.pnlSep03 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.zooms.length; ++i) {
            model.addElement("" + this.zooms[i] + "%");
        }
        this.cmbZoom.setModel(model);
        this.setLayout(new FlowLayout(0, 0, 2));
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/save.GIF")));
        this.btnSave.setToolTipText(this.viewerContext.getBundleString("save"));
        this.btnSave.setMargin(new Insets(2, 2, 2, 2));
        this.btnSave.setMaximumSize(new Dimension(23, 23));
        this.btnSave.setMinimumSize(new Dimension(23, 23));
        this.btnSave.setPreferredSize(new Dimension(23, 23));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnSaveActionPerformed(evt);
            }
        });
        this.add(this.btnSave);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/print.GIF")));
        this.btnPrint.setToolTipText(this.viewerContext.getBundleString("print"));
        this.btnPrint.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrint.setMaximumSize(new Dimension(23, 23));
        this.btnPrint.setMinimumSize(new Dimension(23, 23));
        this.btnPrint.setPreferredSize(new Dimension(23, 23));
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnPrintActionPerformed(evt);
            }
        });
        this.add(this.btnPrint);
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/reload.GIF")));
        this.btnReload.setToolTipText(this.viewerContext.getBundleString("reload"));
        this.btnReload.setMargin(new Insets(2, 2, 2, 2));
        this.btnReload.setMaximumSize(new Dimension(23, 23));
        this.btnReload.setMinimumSize(new Dimension(23, 23));
        this.btnReload.setPreferredSize(new Dimension(23, 23));
        this.btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnReloadActionPerformed(evt);
            }
        });
        this.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.add(this.pnlSep01);
        this.btnFirst.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/first.GIF")));
        this.btnFirst.setToolTipText(this.viewerContext.getBundleString("first.page"));
        this.btnFirst.setMargin(new Insets(2, 2, 2, 2));
        this.btnFirst.setMaximumSize(new Dimension(23, 23));
        this.btnFirst.setMinimumSize(new Dimension(23, 23));
        this.btnFirst.setPreferredSize(new Dimension(23, 23));
        this.btnFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnFirstActionPerformed(evt);
            }
        });
        this.add(this.btnFirst);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/previous.GIF")));
        this.btnPrevious.setToolTipText(this.viewerContext.getBundleString("previous.page"));
        this.btnPrevious.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrevious.setMaximumSize(new Dimension(23, 23));
        this.btnPrevious.setMinimumSize(new Dimension(23, 23));
        this.btnPrevious.setPreferredSize(new Dimension(23, 23));
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnPreviousActionPerformed(evt);
            }
        });
        this.add(this.btnPrevious);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/next.GIF")));
        this.btnNext.setToolTipText(this.viewerContext.getBundleString("next.page"));
        this.btnNext.setMargin(new Insets(2, 2, 2, 2));
        this.btnNext.setMaximumSize(new Dimension(23, 23));
        this.btnNext.setMinimumSize(new Dimension(23, 23));
        this.btnNext.setPreferredSize(new Dimension(23, 23));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnNextActionPerformed(evt);
            }
        });
        this.add(this.btnNext);
        this.btnLast.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/last.GIF")));
        this.btnLast.setToolTipText(this.viewerContext.getBundleString("last.page"));
        this.btnLast.setMargin(new Insets(2, 2, 2, 2));
        this.btnLast.setMaximumSize(new Dimension(23, 23));
        this.btnLast.setMinimumSize(new Dimension(23, 23));
        this.btnLast.setPreferredSize(new Dimension(23, 23));
        this.btnLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnLastActionPerformed(evt);
            }
        });
        this.add(this.btnLast);
        this.txtGoTo.setToolTipText(this.viewerContext.getBundleString("go.to.page"));
        this.txtGoTo.setMaximumSize(new Dimension(40, 23));
        this.txtGoTo.setMinimumSize(new Dimension(40, 23));
        this.txtGoTo.setPreferredSize(new Dimension(40, 23));
        this.txtGoTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.txtGoToActionPerformed(evt);
            }
        });
        this.add(this.txtGoTo);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.add(this.pnlSep02);
        this.btnActualSize.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/actualsize.GIF")));
        this.btnActualSize.setToolTipText(this.viewerContext.getBundleString("actual.size"));
        this.btnActualSize.setMargin(new Insets(2, 2, 2, 2));
        this.btnActualSize.setMaximumSize(new Dimension(23, 23));
        this.btnActualSize.setMinimumSize(new Dimension(23, 23));
        this.btnActualSize.setPreferredSize(new Dimension(23, 23));
        this.btnActualSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnActualSizeActionPerformed(evt);
            }
        });
        this.add(this.btnActualSize);
        this.btnFitPage.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitpage.GIF")));
        this.btnFitPage.setToolTipText(this.viewerContext.getBundleString("fit.page"));
        this.btnFitPage.setMargin(new Insets(2, 2, 2, 2));
        this.btnFitPage.setMaximumSize(new Dimension(23, 23));
        this.btnFitPage.setMinimumSize(new Dimension(23, 23));
        this.btnFitPage.setPreferredSize(new Dimension(23, 23));
        this.btnFitPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnFitPageActionPerformed(evt);
            }
        });
        this.add(this.btnFitPage);
        this.btnFitWidth.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitwidth.GIF")));
        this.btnFitWidth.setToolTipText(this.viewerContext.getBundleString("fit.width"));
        this.btnFitWidth.setMargin(new Insets(2, 2, 2, 2));
        this.btnFitWidth.setMaximumSize(new Dimension(23, 23));
        this.btnFitWidth.setMinimumSize(new Dimension(23, 23));
        this.btnFitWidth.setPreferredSize(new Dimension(23, 23));
        this.btnFitWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnFitWidthActionPerformed(evt);
            }
        });
        this.add(this.btnFitWidth);
        this.pnlSep03.setMaximumSize(new Dimension(10, 10));
        this.add(this.pnlSep03);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText(this.viewerContext.getBundleString("zoom.in"));
        this.btnZoomIn.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnZoomInActionPerformed(evt);
            }
        });
        this.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText(this.viewerContext.getBundleString("zoom.out"));
        this.btnZoomOut.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.btnZoomOutActionPerformed(evt);
            }
        });
        this.add(this.btnZoomOut);
        this.cmbZoom.setEditable(true);
        this.cmbZoom.setToolTipText(this.viewerContext.getBundleString("zoom.ratio"));
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JRViewerToolbar.this.cmbZoomActionPerformed(evt);
            }
        });
        this.cmbZoom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JRViewerToolbar.this.cmbZoomItemStateChanged(evt);
            }
        });
        this.add(this.cmbZoom);
    }

    public void init() {
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
    }

    public void addComponentKeyListener(KeyListener listener) {
        this.btnSave.addKeyListener(listener);
        this.btnPrint.addKeyListener(listener);
        this.btnReload.addKeyListener(listener);
        this.btnFirst.addKeyListener(listener);
        this.btnPrevious.addKeyListener(listener);
        this.btnNext.addKeyListener(listener);
        this.btnLast.addKeyListener(listener);
        this.txtGoTo.addKeyListener(listener);
        this.btnActualSize.addKeyListener(listener);
        this.btnFitPage.addKeyListener(listener);
        this.btnFitWidth.addKeyListener(listener);
        this.btnZoomIn.addKeyListener(listener);
        this.btnZoomOut.addKeyListener(listener);
        this.cmbZoom.addKeyListener(listener);
    }

    void btnSaveActionPerformed(ActionEvent evt) {
        int retValue;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setLocale(this.getLocale());
        fileChooser.updateUI();
        for (int i = 0; i < this.saveContributors.size(); ++i) {
            fileChooser.addChoosableFileFilter(this.saveContributors.get(i));
        }
        if (this.saveContributors.contains(this.lastSaveContributor)) {
            fileChooser.setFileFilter(this.lastSaveContributor);
        } else if (this.saveContributors.size() > 0) {
            fileChooser.setFileFilter(this.saveContributors.get(0));
        }
        if (this.lastFolder != null) {
            fileChooser.setCurrentDirectory(this.lastFolder);
        }
        if ((retValue = fileChooser.showSaveDialog(this)) == 0) {
            FileFilter fileFilter = fileChooser.getFileFilter();
            File file = fileChooser.getSelectedFile();
            this.lastFolder = file.getParentFile();
            JRSaveContributor contributor = null;
            if (fileFilter instanceof JRSaveContributor) {
                contributor = (JRSaveContributor)fileFilter;
            } else {
                int i = 0;
                while (contributor == null && i < this.saveContributors.size()) {
                    if ((contributor = this.saveContributors.get(i++)).accept(file)) continue;
                    contributor = null;
                }
                if (contributor == null) {
                    contributor = new JRPrintSaveContributor(this.viewerContext.getJasperReportsContext(), this.getLocale(), this.viewerContext.getResourceBundle());
                }
            }
            this.lastSaveContributor = contributor;
            try {
                contributor.save(this.viewerContext.getJasperPrint(), file);
            }
            catch (JRException | JRRuntimeException e) {
                if (log.isErrorEnabled()) {
                    log.error("Save error.", (Throwable)e);
                }
                JOptionPane.showMessageDialog(this, this.viewerContext.getBundleString("error.saving"));
            }
        }
    }

    void btnPrintActionPerformed(ActionEvent evt) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JRViewerToolbar.this.btnPrint.setEnabled(false);
                    JasperPrintManager.getInstance(JRViewerToolbar.this.viewerContext.getJasperReportsContext()).print(JRViewerToolbar.this.viewerContext.getJasperPrint(), true);
                }
                catch (Exception ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Print error.", (Throwable)ex);
                    }
                    JOptionPane.showMessageDialog(JRViewerToolbar.this, JRViewerToolbar.this.viewerContext.getBundleString("error.printing"));
                }
                finally {
                    JRViewerToolbar.this.btnPrint.setEnabled(true);
                }
            }
        });
        thread.start();
    }

    void btnReloadActionPerformed(ActionEvent evt) {
        this.viewerContext.reload();
    }

    void btnFirstActionPerformed(ActionEvent evt) {
        this.viewerContext.setPageIndex(0);
        this.viewerContext.refreshPage();
    }

    void btnPreviousActionPerformed(ActionEvent evt) {
        this.viewerContext.setPageIndex(this.viewerContext.getPageIndex() - 1);
        this.viewerContext.refreshPage();
    }

    void btnNextActionPerformed(ActionEvent evt) {
        this.viewerContext.setPageIndex(this.viewerContext.getPageIndex() + 1);
        this.viewerContext.refreshPage();
    }

    void btnLastActionPerformed(ActionEvent evt) {
        this.viewerContext.setPageIndex(this.viewerContext.getPageCount() - 1);
        this.viewerContext.refreshPage();
    }

    void txtGoToActionPerformed(ActionEvent evt) {
        try {
            int pageNumber = Integer.parseInt(this.txtGoTo.getText());
            if (pageNumber != this.viewerContext.getPageIndex() + 1 && pageNumber > 0 && pageNumber <= this.viewerContext.getPageCount()) {
                this.viewerContext.setPageIndex(pageNumber - 1);
                this.viewerContext.refreshPage();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void btnActualSizeActionPerformed(ActionEvent evt) {
        if (this.btnActualSize.isSelected()) {
            this.btnFitPage.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.viewerContext.setZoomRatio(1.0f);
            this.btnActualSize.setSelected(true);
        }
    }

    void btnFitPageActionPerformed(ActionEvent evt) {
        if (this.btnFitPage.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.viewerContext.fitPage();
            this.btnFitPage.setSelected(true);
        }
    }

    void btnFitWidthActionPerformed(ActionEvent evt) {
        if (this.btnFitWidth.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitPage.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.viewerContext.fitWidth();
            this.btnFitWidth.setSelected(true);
        }
    }

    void btnZoomInActionPerformed(ActionEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index < 0) {
            this.viewerContext.setZoomRatio((float)this.zooms[-index - 1] / 100.0f);
        } else if (index < this.cmbZoom.getModel().getSize() - 1) {
            this.viewerContext.setZoomRatio((float)this.zooms[index + 1] / 100.0f);
        }
    }

    protected float getZoomRatio() {
        float newZoom = this.viewerContext.getZoom();
        try {
            newZoom = this.zoomDecimalFormat.parse(String.valueOf(this.cmbZoom.getEditor().getItem())).floatValue() / 100.0f;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return newZoom;
    }

    void btnZoomOutActionPerformed(ActionEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index > 0) {
            this.viewerContext.setZoomRatio((float)this.zooms[index - 1] / 100.0f);
        } else if (index < -1) {
            this.viewerContext.setZoomRatio((float)this.zooms[-index - 2] / 100.0f);
        }
    }

    void cmbZoomActionPerformed(ActionEvent evt) {
        float newZoom = this.getZoomRatio();
        if (newZoom < 0.5f) {
            newZoom = 0.5f;
        }
        if (newZoom > 10.0f) {
            newZoom = 10.0f;
        }
        this.viewerContext.setZoomRatio(newZoom);
    }

    void cmbZoomItemStateChanged(ItemEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
    }

    public void addSaveContributor(JRSaveContributor contributor) {
        this.saveContributors.add(contributor);
    }

    public void removeSaveContributor(JRSaveContributor contributor) {
        this.saveContributors.remove(contributor);
    }

    public JRSaveContributor[] getSaveContributors() {
        return this.saveContributors.toArray(new JRSaveContributor[this.saveContributors.size()]);
    }

    public void setSaveContributors(JRSaveContributor[] saveContributors) {
        this.saveContributors = new ArrayList<JRSaveContributor>();
        if (saveContributors != null) {
            this.saveContributors.addAll(Arrays.asList(saveContributors));
        }
    }

    protected void initSaveContributors() {
        List<JRSaveContributor> builtinContributors = SaveContributorUtils.createBuiltinContributors(this.viewerContext.getJasperReportsContext(), this.getLocale(), this.viewerContext.getResourceBundle());
        this.saveContributors.addAll(builtinContributors);
    }

    protected void reportLoaded() {
        this.btnReload.setEnabled(this.viewerContext.isReloadSupported());
    }

    protected void refreshPage() {
        if (!this.viewerContext.hasPages()) {
            this.btnSave.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnActualSize.setEnabled(false);
            this.btnFitPage.setEnabled(false);
            this.btnFitWidth.setEnabled(false);
            this.btnZoomIn.setEnabled(false);
            this.btnZoomOut.setEnabled(false);
            this.cmbZoom.setEnabled(false);
            return;
        }
        this.btnSave.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnActualSize.setEnabled(true);
        this.btnFitPage.setEnabled(true);
        this.btnFitWidth.setEnabled(true);
        this.btnZoomIn.setEnabled(this.viewerContext.getZoom() < 10.0f);
        this.btnZoomOut.setEnabled(this.viewerContext.getZoom() > 0.5f);
        this.cmbZoom.setEnabled(true);
    }

    protected void pageChanged() {
        if (this.viewerContext.hasPages()) {
            int pageIndex = this.viewerContext.getPageIndex();
            this.btnFirst.setEnabled(pageIndex > 0);
            this.btnPrevious.setEnabled(pageIndex > 0);
            boolean notLast = pageIndex < this.viewerContext.getPageCount() - 1;
            this.btnNext.setEnabled(notLast);
            this.btnLast.setEnabled(notLast);
            this.txtGoTo.setEnabled(this.btnFirst.isEnabled() || this.btnLast.isEnabled());
            this.txtGoTo.setText("" + (pageIndex + 1));
        } else {
            this.btnFirst.setEnabled(false);
            this.btnPrevious.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.txtGoTo.setEnabled(false);
            this.txtGoTo.setText("");
        }
    }

    protected void zoomChanged() {
        this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(this.viewerContext.getZoom() * 100.0f) + "%");
    }

    public boolean isFitPage() {
        return this.btnFitPage.isSelected();
    }

    public boolean isFitWidth() {
        return this.btnFitPage.isSelected();
    }

    public void setFitWidth() {
        this.btnFitWidth.setSelected(true);
    }

    protected void fitPage() {
        this.btnFitPage.setSelected(true);
    }

    protected void fitWidth() {
        this.btnFitWidth.setSelected(true);
    }

    @Override
    public void viewerEvent(JRViewerEvent event) {
        switch (event.getCode()) {
            case 5: {
                this.fitPage();
                break;
            }
            case 6: {
                this.fitWidth();
                break;
            }
            case 3: {
                this.pageChanged();
                break;
            }
            case 2: {
                this.refreshPage();
                break;
            }
            case 4: {
                this.zoomChanged();
                break;
            }
            case 1: {
                this.reportLoaded();
                break;
            }
        }
    }
}

