/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.swing;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.engine.util.SimpleFileResolver;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.swing.JRViewerEvent;
import net.sf.jasperreports.swing.JRViewerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRViewerController {
    private static final Logger log = LoggerFactory.getLogger(JRViewerController.class);
    protected static final int TYPE_FILE_NAME = 1;
    protected static final int TYPE_INPUT_STREAM = 2;
    protected static final int TYPE_OBJECT = 3;
    private JasperReportsContext jasperReportsContext;
    private LocalJasperReportsContext localJasperReportsContext;
    private ResourceBundle resourceBundle;
    private Locale locale;
    private final List<JRViewerListener> listeners = new ArrayList<JRViewerListener>();
    protected int type = 1;
    protected boolean isXML;
    protected String reportFileName;
    protected boolean reloadSupported;
    protected JasperPrint jasperPrint;
    protected RenderersCache renderersCache;
    private int pageIndex;
    private float zoom;
    private boolean fitPage;
    private boolean fitWidth;

    public JRViewerController(Locale locale, ResourceBundle resBundle) {
        this(DefaultJasperReportsContext.getInstance(), locale, resBundle);
    }

    public JRViewerController(JasperReportsContext jasperReportsContext, Locale locale, ResourceBundle resBundle) {
        this.jasperReportsContext = jasperReportsContext;
        this.locale = locale != null ? locale : Locale.getDefault();
        this.resourceBundle = resBundle == null ? ResourceBundle.getBundle("net/sf/jasperreports/view/viewer", this.getLocale()) : resBundle;
    }

    public void addListener(JRViewerListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(JRViewerListener listener) {
        return this.listeners.remove(listener);
    }

    protected void fireListeners(int eventCode) {
        if (!this.listeners.isEmpty()) {
            JRViewerEvent event = new JRViewerEvent(this, eventCode);
            for (JRViewerListener listener : this.listeners) {
                listener.viewerEvent(event);
            }
        }
    }

    protected void setReport(String fileName, boolean isXmlReport) throws JRException {
        this.jasperPrint = isXmlReport ? JRPrintXmlLoader.loadFromFile(this.jasperReportsContext, fileName) : (JasperPrint)JRLoader.loadObjectFromFile(fileName);
        this.renderersCache = null;
    }

    public void loadReport(String fileName, boolean isXmlReport) throws JRException {
        this.setReport(fileName, isXmlReport);
        this.type = 1;
        this.isXML = isXmlReport;
        this.reportFileName = fileName;
        SimpleFileResolver fileResolver = new SimpleFileResolver(Arrays.asList(new File(fileName).getParentFile(), new File(".")));
        fileResolver.setResolveAbsolutePath(true);
        if (this.localJasperReportsContext == null) {
            this.localJasperReportsContext = new LocalJasperReportsContext(this.jasperReportsContext);
            this.jasperReportsContext = this.localJasperReportsContext;
        }
        this.localJasperReportsContext.setFileResolver(fileResolver);
        this.reloadSupported = true;
        this.fireListeners(1);
        this.setPageIndex(0);
    }

    protected void setReport(InputStream is, boolean isXmlReport) throws JRException {
        this.jasperPrint = isXmlReport ? JRPrintXmlLoader.load(this.jasperReportsContext, is) : (JasperPrint)JRLoader.loadObject(is);
        this.renderersCache = null;
    }

    public void loadReport(InputStream is, boolean isXmlReport) throws JRException {
        this.setReport(is, isXmlReport);
        this.type = 2;
        this.isXML = isXmlReport;
        this.reloadSupported = false;
        this.fireListeners(1);
        this.setPageIndex(0);
    }

    public void loadReport(JasperPrint jrPrint) {
        this.jasperPrint = jrPrint;
        this.renderersCache = null;
        this.type = 3;
        this.isXML = false;
        this.reloadSupported = false;
        this.fireListeners(1);
        this.setPageIndex(0);
    }

    public void reload() {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
            }
            catch (JRException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Reload failed.", (Throwable)e);
                }
                this.jasperPrint = null;
                this.renderersCache = null;
                this.setPageIndex(0);
                this.refreshPage();
                this.fireListeners(7);
            }
            this.forceRefresh();
        }
    }

    public boolean hasPages() {
        return this.jasperPrint != null && this.jasperPrint.getPages() != null && this.jasperPrint.getPages().size() > 0;
    }

    public void refreshPage() {
        this.fireListeners(2);
    }

    protected void forceRefresh() {
        this.zoom = 0.0f;
        this.setZoomRatio(1.0f);
    }

    public void setZoomRatio(float newZoom) {
        if (newZoom > 0.0f) {
            this.fitPage = false;
            this.fitWidth = false;
            float old = this.zoom;
            this.zoom = newZoom;
            this.fireListeners(4);
            if (this.zoom != old) {
                this.refreshPage();
            }
        }
    }

    public void setPageIndex(int index) {
        if (this.hasPages()) {
            if (index >= 0 && index < this.jasperPrint.getPages().size()) {
                this.pageIndex = index;
                this.fireListeners(3);
            }
        } else {
            this.fireListeners(3);
        }
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getBundleString(String key) {
        return this.resourceBundle.getString(key);
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public int getPageCount() {
        return this.jasperPrint.getPages().size();
    }

    public PrintPageFormat getPageFormat() {
        return this.getJasperPrint().getPageFormat(this.getPageIndex());
    }

    protected RenderersCache getRenderersCache() {
        if (this.renderersCache == null) {
            this.renderersCache = new RenderersCache(this.getJasperReportsContext());
        }
        return this.renderersCache;
    }

    public void clear() {
        this.jasperPrint = null;
        this.renderersCache = null;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public float getZoom() {
        return this.zoom;
    }

    public boolean isReloadSupported() {
        return this.reloadSupported;
    }

    public boolean isFitPage() {
        return this.fitPage;
    }

    public boolean isFitWidth() {
        return this.fitWidth;
    }

    public void fitPage() {
        this.fireListeners(5);
        this.fitPage = true;
    }

    public void fitWidth() {
        this.fireListeners(6);
        this.fitWidth = true;
    }
}

