/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.swing;

import java.io.InputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.swing.JRDesignViewerController;
import net.sf.jasperreports.swing.JRDesignViewerPanel;
import net.sf.jasperreports.swing.JRDesignViewerToolbar;
import net.sf.jasperreports.swing.JRViewer;
import net.sf.jasperreports.swing.JRViewerPanel;
import net.sf.jasperreports.swing.JRViewerToolbar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRDesignViewer
extends JRViewer {
    private static final Logger log = LoggerFactory.getLogger(JRDesignViewer.class);
    private static final long serialVersionUID = 10200L;

    public JRDesignViewer(String fileName, boolean isXML) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), fileName, isXML);
    }

    public JRDesignViewer(InputStream is, boolean isXML) throws JRException {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), is, isXML);
    }

    public JRDesignViewer(JRReport report) throws JRException {
        this(DefaultJasperReportsContext.getInstance(), report);
    }

    public JRDesignViewer(JasperReportsContext jasperReportsContext, String fileName, boolean isXML) throws JRException {
        super(jasperReportsContext, fileName, isXML, null, null);
        this.hideUnusedComponents();
    }

    public JRDesignViewer(JasperReportsContext jasperReportsContext, InputStream is, boolean isXML) throws JRException {
        super(jasperReportsContext, is, isXML, null, null);
        this.hideUnusedComponents();
    }

    public JRDesignViewer(JasperReportsContext jasperReportsContext, JRReport report) throws JRException {
        super(jasperReportsContext, new ReportConverter(jasperReportsContext, report, false).getJasperPrint(), null, null);
        this.hideUnusedComponents();
    }

    private void hideUnusedComponents() {
        this.pnlStatus.setVisible(false);
    }

    @Override
    protected void initViewerContext(JasperReportsContext jasperReportsContext, Locale locale, ResourceBundle resBundle) {
        this.viewerContext = new JRDesignViewerController(jasperReportsContext, locale, resBundle);
        this.setLocale(this.viewerContext.getLocale());
        this.viewerContext.addListener(this);
    }

    @Override
    protected JRViewerToolbar createToolbar() {
        return new JRDesignViewerToolbar(this.viewerContext);
    }

    @Override
    protected JRViewerPanel createViewerPanel() {
        return new JRDesignViewerPanel(this.viewerContext);
    }
}

