/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.phantomjs;

import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.phantomjs.InetUtil;
import net.sf.jasperreports.phantomjs.PhantomJSProcess;
import net.sf.jasperreports.phantomjs.ProcessDirector;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessFactory
extends BasePooledObjectFactory<PhantomJSProcess> {
    private static final Logger log = LoggerFactory.getLogger(ProcessFactory.class);
    private ProcessDirector director;
    private int expirationCount;
    private int expirationTime;

    public ProcessFactory(ProcessDirector director, JRPropertiesUtil properties) {
        this.director = director;
        this.expirationCount = properties.getIntegerProperty("net.sf.jasperreports.phantomjs.expiration.count", 1000);
        this.expirationTime = properties.getIntegerProperty("net.sf.jasperreports.phantomjs.expiration.time", 1200000);
    }

    public PhantomJSProcess create() throws Exception {
        int port = InetUtil.getAvailablePort();
        PhantomJSProcess process = new PhantomJSProcess(this.director, port);
        process.startPhantomJS();
        return process;
    }

    public PooledObject<PhantomJSProcess> wrap(PhantomJSProcess process) {
        return new DefaultPooledObject((Object)process);
    }

    public void activateObject(PooledObject<PhantomJSProcess> pooledObject) throws Exception {
        super.activateObject(pooledObject);
        PhantomJSProcess process = (PhantomJSProcess)pooledObject.getObject();
        if (process.hasEnded()) {
            if (log.isDebugEnabled()) {
                log.debug(process.getId() + " has ended");
            }
            throw new JRRuntimeException("Process " + process.getId() + " has ended");
        }
        long borrowedCount = ((DefaultPooledObject)pooledObject).getBorrowedCount();
        if (borrowedCount >= (long)this.expirationCount) {
            if (log.isDebugEnabled()) {
                log.debug(process.getId() + " borrow count " + borrowedCount + " exceeded expiration count " + this.expirationCount);
            }
            throw new JRRuntimeException("Process " + process.getId() + " borrow count exceeded");
        }
        long now = System.currentTimeMillis();
        if (now >= pooledObject.getCreateTime() + (long)this.expirationTime) {
            if (log.isDebugEnabled()) {
                log.debug(process.getId() + " expiration time " + this.expirationTime + " from " + pooledObject.getCreateTime() + " exceeded");
            }
            throw new JRRuntimeException("Process " + process.getId() + " expiration time exceeded");
        }
    }

    public boolean validateObject(PooledObject<PhantomJSProcess> pooledObject) {
        PhantomJSProcess process = (PhantomJSProcess)pooledObject.getObject();
        String message = "validate" + System.currentTimeMillis();
        String data = "{\"echo\": \"" + message + "\"}";
        if (log.isDebugEnabled()) {
            log.debug(process.getId() + " pinging with " + data);
        }
        try {
            String answer = process.getProcessConnection().runRequest(data);
            if (log.isDebugEnabled()) {
                log.debug(process.getId() + " got answer " + answer);
            }
            return answer.equals(message);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug(process.getId() + " ping failed", (Throwable)e);
            }
            return false;
        }
    }

    public void destroyObject(PooledObject<PhantomJSProcess> pooledObject) throws Exception {
        ((PhantomJSProcess)pooledObject.getObject()).dispose();
    }
}

