/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.phantomjs;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetUtil {
    private static final Logger log = LoggerFactory.getLogger(InetUtil.class);

    public static Inet4Address getIPv4Loopback() {
        InetAddress loopbackAddress = InetAddress.getLoopbackAddress();
        if (loopbackAddress instanceof Inet4Address) {
            return (Inet4Address)loopbackAddress;
        }
        try {
            InetAddress[] addresses;
            for (InetAddress inetAddress : addresses = InetAddress.getAllByName(loopbackAddress.getHostName())) {
                if (!(inetAddress instanceof Inet4Address)) continue;
                return (Inet4Address)inetAddress;
            }
        }
        catch (UnknownHostException e) {
            log.warn("Error while determining loopback addresses for " + loopbackAddress.getHostName(), (Throwable)e);
        }
        try {
            Enumeration<NetworkInterface> itfs = NetworkInterface.getNetworkInterfaces();
            while (itfs.hasMoreElements()) {
                NetworkInterface itf = itfs.nextElement();
                if (!itf.isLoopback()) continue;
                Enumeration<InetAddress> addresses = itf.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    return (Inet4Address)address;
                }
            }
        }
        catch (SocketException e) {
            log.warn("Error while listing network interfaces", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailablePort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int port = socket.getLocalPort();
            if (log.isDebugEnabled()) {
                log.debug("found available port " + port);
            }
            int n = port;
            return n;
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }
}

