/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.xmla;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.olap.JROlapDataSource;
import net.sf.jasperreports.olap.xmla.JRXmlaCell;
import net.sf.jasperreports.olap.xmla.JRXmlaHierarchy;
import net.sf.jasperreports.olap.xmla.JRXmlaMember;
import net.sf.jasperreports.olap.xmla.JRXmlaMemberTuple;
import net.sf.jasperreports.olap.xmla.JRXmlaResult;
import net.sf.jasperreports.olap.xmla.JRXmlaResultAxis;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.CellSetAxisMetaData;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.layout.RectangularCellSetFormatter;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Member;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Olap4jXmlaQueryExecuter
extends JRAbstractQueryExecuter {
    public static final String EXCEPTION_MESSAGE_KEY_CONNECTION_ERROR = "query.xmla.connection.error";
    public static final String EXCEPTION_MESSAGE_KEY_EXECUTE_QUERY_ERROR = "query.xmla.execute.query.error";
    public static final String OLAP4J_DRIVER = "olap4jDriver";
    public static final String OLAP4J_URL_PREFIX = "urlPrefix";
    public static final String XMLA_SERVER = "server";
    public static final String XMLA_CATALOG = "catalog";
    public static final String XMLA_DATA_SOURCE = "dataSource";
    public static final String XMLA_USER = "user";
    public static final String XMLA_PASSWORD = "password";
    public static final String OLAP4J_XMLA_DRIVER_CLASS = "org.olap4j.driver.xmla.XmlaOlap4jDriver";
    public static final String OLAP4J_XMLA_URL_PREFIX = "jdbc:xmla:";
    private static final Logger log = LoggerFactory.getLogger(Olap4jXmlaQueryExecuter.class);
    final DefaultJasperReportsContext context = DefaultJasperReportsContext.getInstance();
    private Connection rConnection;
    private JRXmlaResult xmlaResult;

    public Olap4jXmlaQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        this.parseQuery();
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return "MDX";
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        Properties connectProps = new Properties();
        connectProps.put(XMLA_SERVER, this.getParameterValue("XMLA_URL"));
        connectProps.put(XMLA_CATALOG, this.getParameterValue("XMLA_CATALOG"));
        connectProps.put(XMLA_DATA_SOURCE, this.getParameterValue("XMLA_DATASOURCE"));
        connectProps.put(XMLA_USER, this.getParameterValue("XMLA_USER"));
        connectProps.put(XMLA_PASSWORD, this.getParameterValue("XMLA_PASSWORD"));
        connectProps.put(OLAP4J_DRIVER, OLAP4J_XMLA_DRIVER_CLASS);
        connectProps.put(OLAP4J_URL_PREFIX, OLAP4J_XMLA_URL_PREFIX);
        this.rConnection = null;
        try {
            Class.forName(OLAP4J_XMLA_DRIVER_CLASS);
            this.rConnection = DriverManager.getConnection(OLAP4J_XMLA_URL_PREFIX, connectProps);
        }
        catch (Throwable t) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_CONNECTION_ERROR, new Object[]{OLAP4J_XMLA_DRIVER_CLASS}, t);
        }
        OlapConnection connection = (OlapConnection)this.rConnection;
        if (log.isDebugEnabled()) {
            log.debug("running MDX: " + this.getQueryString());
        }
        CellSet result = null;
        try {
            OlapStatement statement = connection.createStatement();
            result = statement.executeOlapQuery(this.getQueryString());
        }
        catch (OlapException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_EXECUTE_QUERY_ERROR, new Object[]{this.getQueryString()}, e);
        }
        this.parseResult(result);
        return new JROlapDataSource(this.dataset, this.xmlaResult);
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }

    @Override
    public void close() {
        if (this.rConnection != null) {
            try {
                this.rConnection.close();
            }
            catch (SQLException e) {
                throw new JRRuntimeException(e);
            }
            this.rConnection = null;
        }
    }

    protected void parseResult(CellSet result) throws JRException {
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            RectangularCellSetFormatter formatter = new RectangularCellSetFormatter(true);
            formatter.format(result, new PrintWriter(bos, true));
            log.debug("Result:\n" + ((Object)bos).toString());
        }
        this.xmlaResult = new JRXmlaResult();
        this.parseAxes(result);
        this.parseCellDataElement(result);
    }

    protected void parseAxes(CellSet result) {
        Iterator itAxis = result.getAxes().iterator();
        log.debug("# axes: " + result.getAxes().size());
        while (itAxis.hasNext()) {
            CellSetAxis itAxisElement = (CellSetAxis)itAxis.next();
            Axis axis = itAxisElement.getAxisMetaData().getAxisOrdinal();
            if (axis.axisOrdinal() == Axis.FILTER.axisOrdinal()) {
                if (!log.isDebugEnabled()) continue;
                log.debug("skipping filter axis: " + axis.name() + ", ordinal: " + axis.axisOrdinal());
                continue;
            }
            JRXmlaResultAxis xmlaAxis = new JRXmlaResultAxis(axis.name());
            this.xmlaResult.addAxis(xmlaAxis);
            if (log.isDebugEnabled()) {
                log.debug("adding axis: " + axis.name() + ", ordinal: " + axis.axisOrdinal());
            }
            this.handleHierInfo(xmlaAxis, itAxisElement.getAxisMetaData());
            for (Position p : itAxisElement) {
                if (log.isDebugEnabled()) {
                    log.debug("adding pos : " + p.getOrdinal() + ", with member size: " + p.getMembers().size());
                }
                this.handlePosition(xmlaAxis, itAxisElement, p);
            }
        }
    }

    protected void parseCellDataElement(CellSet result) throws JRException {
        if (log.isDebugEnabled()) {
            log.debug("COLUMNS axis size: " + ((CellSetAxis)result.getAxes().get(Axis.COLUMNS.axisOrdinal())).getPositions().size());
            log.debug("ROWS axis size: " + ((CellSetAxis)result.getAxes().get(Axis.ROWS.axisOrdinal())).getPositions().size());
        }
        for (Position axis_1 : ((CellSetAxis)result.getAxes().get(Axis.ROWS.axisOrdinal())).getPositions()) {
            for (Position axis_0 : ((CellSetAxis)result.getAxes().get(Axis.COLUMNS.axisOrdinal())).getPositions()) {
                Cell currentCell = result.getCell(new Position[]{axis_0, axis_1});
                if (currentCell.isError()) {
                    this.handleCellErrors(currentCell);
                    continue;
                }
                int cellOrdinal = currentCell.getOrdinal();
                Object value = currentCell.getValue();
                if (value instanceof Number) {
                    try {
                        value = currentCell.getDoubleValue();
                    }
                    catch (OlapException e) {
                        throw new JRException(e);
                    }
                }
                String fmtValue = currentCell.getFormattedValue();
                JRXmlaCell cell = new JRXmlaCell(value, fmtValue);
                if (log.isDebugEnabled()) {
                    log.debug("Cell: " + cellOrdinal + ", at axis 0 pos: " + axis_0.getOrdinal() + ", axis 1 pos: " + axis_1.getOrdinal());
                }
                this.xmlaResult.setCell(cell, cellOrdinal);
            }
        }
    }

    protected void handleCellErrors(Cell currentCell) throws JRException {
        log.error(currentCell.getValue().toString());
        throw new JRException((OlapException)((Object)currentCell.getValue()));
    }

    protected void handleHierInfo(JRXmlaResultAxis xmlaAxis, CellSetAxisMetaData axisMetaData) {
        for (Hierarchy h : axisMetaData.getHierarchies()) {
            String dimName = h.getName();
            JRXmlaHierarchy hier = new JRXmlaHierarchy(dimName);
            if (log.isDebugEnabled()) {
                log.debug("Adding hierarchy: " + dimName);
            }
            xmlaAxis.addHierarchy(hier);
        }
    }

    protected void handlePosition(JRXmlaResultAxis axis, CellSetAxis itAxisElement, Position p) {
        JRXmlaMemberTuple tuple = new JRXmlaMemberTuple(p.getMembers().size());
        int memNum = 0;
        for (Member m : p.getMembers()) {
            String hierName = m.getHierarchy().getName();
            String uName = m.getUniqueName();
            String caption = null;
            try {
                Method captionMethod = Member.class.getMethod("getCaption", Locale.class);
                try {
                    caption = (String)captionMethod.invoke((Object)m, new Object[]{null});
                }
                catch (Exception e) {
                    throw new JRRuntimeException(e);
                }
            }
            catch (SecurityException e) {
                throw new JRRuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                try {
                    Method captionMethod = Member.class.getMethod("getCaption", new Class[0]);
                    caption = (String)captionMethod.invoke((Object)m, new Object[0]);
                }
                catch (Exception e1) {
                    throw new JRRuntimeException(e1);
                }
            }
            String lName = m.getLevel().getName();
            int lNum = m.getLevel().getDepth();
            if (log.isDebugEnabled()) {
                log.debug("setting hierarchy: " + hierName + ", Level " + lName + ", level number: " + lNum);
            }
            JRXmlaMember member = new JRXmlaMember(caption, uName, hierName, lName, lNum);
            tuple.setMember(memNum++, member);
        }
        axis.addTuple(tuple);
    }
}

