/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.AbstractQueryExecuterFactory;
import net.sf.jasperreports.engine.query.JREmptyQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import net.sf.jasperreports.engine.util.Designated;
import net.sf.jasperreports.olap.JRMondrianQueryExecuter;
import net.sf.jasperreports.olap.JRMondrianQueryExecuterFactory;
import net.sf.jasperreports.olap.xmla.JRXmlaQueryExecuter;
import net.sf.jasperreports.olap.xmla.JRXmlaQueryExecuterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRMdxQueryExecuterFactory
extends AbstractQueryExecuterFactory
implements Designated {
    public static final String QUERY_EXECUTER_NAME = "net.sf.jasperreports.query.executer:MDX";
    private static final Logger log = LoggerFactory.getLogger(JRMdxQueryExecuterFactory.class);
    private static final Object[] MDX_BUILTIN_PARAMETERS;
    public static final String CANONICAL_LANGUAGE = "MDX";

    @Override
    public Object[] getBuiltinParameters() {
        return MDX_BUILTIN_PARAMETERS;
    }

    @Override
    public JRQueryExecuter createQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parameters) throws JRException {
        JRQueryExecuter queryExecuter;
        if (this.getParameterValue(parameters, "MONDRIAN_CONNECTION") != null) {
            queryExecuter = new JRMondrianQueryExecuter(jasperReportsContext, dataset, parameters);
        } else if (this.getParameterValue(parameters, "XMLA_URL") != null) {
            queryExecuter = new JRXmlaQueryExecuter(jasperReportsContext, dataset, parameters);
        } else {
            log.warn("No Mondrian connection or XMLA URL set for MDX query");
            queryExecuter = new JREmptyQueryExecuter();
        }
        return queryExecuter;
    }

    protected final Object getParameterValue(Map<String, ? extends JRValueParameter> valueParams, String name) {
        JRValueParameter valueParam = valueParams.get(name);
        return valueParam == null ? null : valueParam.getValue();
    }

    @Override
    public boolean supportsQueryParameterType(String className) {
        return true;
    }

    @Override
    public String getDesignation() {
        return QUERY_EXECUTER_NAME;
    }

    static {
        Object[] mondrianParams = new JRMondrianQueryExecuterFactory().getBuiltinParameters();
        Object[] xmlaParams = new JRXmlaQueryExecuterFactory().getBuiltinParameters();
        MDX_BUILTIN_PARAMETERS = new Object[mondrianParams.length + xmlaParams.length];
        System.arraycopy(mondrianParams, 0, MDX_BUILTIN_PARAMETERS, 0, mondrianParams.length);
        System.arraycopy(xmlaParams, 0, MDX_BUILTIN_PARAMETERS, mondrianParams.length, xmlaParams.length);
    }
}

