/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlBaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRXmlTemplateWriter
extends JRXmlBaseWriter {
    private static final Logger log = LoggerFactory.getLogger(JRXmlTemplateWriter.class);
    public static final XmlNamespace JASPERTEMPLATE_NAMESPACE = new XmlNamespace("http://jasperreports.sourceforge.net/jasperreports/template", null, "http://jasperreports.sourceforge.net/xsd/jaspertemplate.xsd");
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final JRTemplate template;
    private final String encoding;

    public static String writeTemplate(JRTemplate template) {
        return JRXmlTemplateWriter.writeTemplate(template, DEFAULT_ENCODING);
    }

    public static String writeTemplate(JasperReportsContext jasperReportsContext, JRTemplate template) {
        return JRXmlTemplateWriter.writeTemplate(jasperReportsContext, template, DEFAULT_ENCODING);
    }

    public static String writeTemplate(JRTemplate template, String encoding) {
        return JRXmlTemplateWriter.writeTemplate((JasperReportsContext)DefaultJasperReportsContext.getInstance(), template, encoding);
    }

    public static String writeTemplate(JasperReportsContext jasperReportsContext, JRTemplate template, String encoding) {
        StringWriter stringOut = new StringWriter();
        try {
            JRXmlTemplateWriter.writeTemplate(jasperReportsContext, template, stringOut, encoding);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        return stringOut.toString();
    }

    public static void writeTemplate(JRTemplate template, OutputStream out) {
        JRXmlTemplateWriter.writeTemplate(template, out, DEFAULT_ENCODING);
    }

    public static void writeTemplate(JasperReportsContext jasperReportsContext, JRTemplate template, OutputStream out) {
        JRXmlTemplateWriter.writeTemplate(jasperReportsContext, template, out, DEFAULT_ENCODING);
    }

    public static void writeTemplate(JRTemplate template, OutputStream out, String encoding) {
        JRXmlTemplateWriter.writeTemplate((JasperReportsContext)DefaultJasperReportsContext.getInstance(), template, out, encoding);
    }

    public static void writeTemplate(JasperReportsContext jasperReportsContext, JRTemplate template, OutputStream out, String encoding) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out, encoding);
            JRXmlTemplateWriter.writeTemplate(jasperReportsContext, template, writer, encoding);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static void writeTemplateToFile(JRTemplate template, String outputFile) {
        JRXmlTemplateWriter.writeTemplateToFile(template, outputFile, DEFAULT_ENCODING);
    }

    public static void writeTemplateToFile(JasperReportsContext jasperReportsContext, JRTemplate template, String outputFile) {
        JRXmlTemplateWriter.writeTemplateToFile(jasperReportsContext, template, outputFile, DEFAULT_ENCODING);
    }

    public static void writeTemplateToFile(JRTemplate template, String outputFile, String encoding) {
        JRXmlTemplateWriter.writeTemplateToFile(DefaultJasperReportsContext.getInstance(), template, outputFile, encoding);
    }

    public static void writeTemplateToFile(JasperReportsContext jasperReportsContext, JRTemplate template, String outputFile, String encoding) {
        BufferedOutputStream fileOut = null;
        boolean close = true;
        try {
            fileOut = new BufferedOutputStream(new FileOutputStream(outputFile));
            JRXmlTemplateWriter.writeTemplate(jasperReportsContext, template, fileOut, encoding);
            fileOut.flush();
            close = false;
            fileOut.close();
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (fileOut != null && close) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    log.warn("Could not close file " + outputFile, (Throwable)e);
                }
            }
        }
    }

    protected static void writeTemplate(JasperReportsContext jasperReportsContext, JRTemplate template, Writer out, String encoding) throws IOException {
        JRXmlTemplateWriter writer = new JRXmlTemplateWriter(jasperReportsContext, template, out, encoding);
        writer.write();
        out.flush();
    }

    public JRXmlTemplateWriter(JRTemplate template, Writer out, String encoding) {
        this(DefaultJasperReportsContext.getInstance(), template, out, encoding);
    }

    public JRXmlTemplateWriter(JasperReportsContext jasperReportsContext, JRTemplate template, Writer out, String encoding) {
        this.template = template;
        this.encoding = encoding;
        String version = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty("net.sf.jasperreports.report.version");
        this.useWriter(new JRXmlWriteHelper(out), version);
    }

    public void write() throws IOException {
        XmlNamespace namespace;
        this.writer.writeProlog(this.encoding);
        if (this.isNewerVersionOrEqual("6.3.0")) {
            namespace = JASPERTEMPLATE_NAMESPACE;
        } else {
            this.writer.writePublicDoctype("jasperTemplate", "-//JasperReports//DTD Template//EN", "http://jasperreports.sourceforge.net/dtds/jaspertemplate.dtd");
            namespace = null;
        }
        this.writer.startElement("jasperTemplate", namespace);
        this.writeIncludedTemplates();
        this.writeStyles();
        this.writer.closeElement();
    }

    protected void writeIncludedTemplates() throws IOException {
        JRTemplateReference[] includedTemplates = this.template.getIncludedTemplates();
        if (includedTemplates != null) {
            for (int i = 0; i < includedTemplates.length; ++i) {
                JRTemplateReference reference = includedTemplates[i];
                this.writeIncludedTemplate(reference);
            }
        }
    }

    protected void writeIncludedTemplate(JRTemplateReference reference) throws IOException {
        this.writer.writeCDATAElement("template", reference.getLocation());
    }

    protected void writeStyles() throws IOException {
        JRStyle[] styles = this.template.getStyles();
        if (styles != null) {
            for (int i = 0; i < styles.length; ++i) {
                JRStyle style = styles[i];
                this.writeStyle(style);
            }
        }
    }

    @Override
    protected boolean toWriteConditionalStyles() {
        return false;
    }
}

