/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.xml.BaseSaxParserFactory;
import net.sf.jasperreports.engine.xml.JRBoxFactory;
import net.sf.jasperreports.engine.xml.JRParagraphFactory;
import net.sf.jasperreports.engine.xml.JRPenFactory;
import net.sf.jasperreports.engine.xml.JRSaxParserFactory;
import net.sf.jasperreports.engine.xml.JRTemplateStyleFactory;
import net.sf.jasperreports.engine.xml.JRXmlDigester;
import net.sf.jasperreports.engine.xml.TabStopFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.RuleSetBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JRXmlTemplateDigesterFactory
implements ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(JRXmlTemplateDigesterFactory.class);
    protected static final String PATTERN_ROOT = "jasperTemplate";
    protected static final String PATTERN_INCLUDED_TEMPLATE = "jasperTemplate/template";
    protected static final String PATTERN_STYLE = "jasperTemplate/style";
    protected static final String PATTERN_STYLE_PEN = "jasperTemplate/style/pen";
    protected static final String PATTERN_BOX = "jasperTemplate/style/box";
    protected static final String PATTERN_BOX_PEN = "jasperTemplate/style/box/pen";
    protected static final String PATTERN_BOX_TOP_PEN = "jasperTemplate/style/box/topPen";
    protected static final String PATTERN_BOX_LEFT_PEN = "jasperTemplate/style/box/leftPen";
    protected static final String PATTERN_BOX_BOTTOM_PEN = "jasperTemplate/style/box/bottomPen";
    protected static final String PATTERN_BOX_RIGHT_PEN = "jasperTemplate/style/box/rightPen";
    protected static final String PATTERN_PARAGRAPH = "jasperTemplate/style/paragraph";
    protected static final String PATTERN_TAB_STOP = "jasperTemplate/style/paragraph/tabStop";
    private static final JRXmlTemplateDigesterFactory instance = new JRXmlTemplateDigesterFactory();
    private final RuleSet rules = this.readRuleSet();

    protected JRXmlTemplateDigesterFactory() {
    }

    public static JRXmlTemplateDigesterFactory instance() {
        return instance;
    }

    protected RuleSet readRuleSet() {
        return new RuleSetBase(){

            public void addRuleInstances(Digester digester) {
                digester.addObjectCreate(JRXmlTemplateDigesterFactory.PATTERN_ROOT, JRSimpleTemplate.class);
                digester.addCallMethod(JRXmlTemplateDigesterFactory.PATTERN_INCLUDED_TEMPLATE, "addIncludedTemplate", 0);
                digester.addFactoryCreate(JRXmlTemplateDigesterFactory.PATTERN_STYLE, JRTemplateStyleFactory.class);
                digester.addSetNext(JRXmlTemplateDigesterFactory.PATTERN_STYLE, "addStyle", JRStyle.class.getName());
                digester.addFactoryCreate(JRXmlTemplateDigesterFactory.PATTERN_STYLE_PEN, JRPenFactory.Style.class.getName());
                digester.addFactoryCreate(JRXmlTemplateDigesterFactory.PATTERN_BOX, JRBoxFactory.class.getName());
                digester.addFactoryCreate(JRXmlTemplateDigesterFactory.PATTERN_BOX_PEN, JRPenFactory.Box.class.getName());
                digester.addFactoryCreate(JRXmlTemplateDigesterFactory.PATTERN_BOX_TOP_PEN, JRPenFactory.Top.class.getName());
                digester.addFactoryCreate(JRXmlTemplateDigesterFactory.PATTERN_BOX_LEFT_PEN, JRPenFactory.Left.class.getName());
                digester.addFactoryCreate(JRXmlTemplateDigesterFactory.PATTERN_BOX_BOTTOM_PEN, JRPenFactory.Bottom.class.getName());
                digester.addFactoryCreate(JRXmlTemplateDigesterFactory.PATTERN_BOX_RIGHT_PEN, JRPenFactory.Right.class.getName());
                digester.addFactoryCreate(JRXmlTemplateDigesterFactory.PATTERN_PARAGRAPH, JRParagraphFactory.class.getName());
                digester.addFactoryCreate(JRXmlTemplateDigesterFactory.PATTERN_TAB_STOP, TabStopFactory.class.getName());
                digester.addSetNext(JRXmlTemplateDigesterFactory.PATTERN_TAB_STOP, "addTabStop", TabStop.class.getName());
            }
        };
    }

    public JRXmlDigester createDigester(JasperReportsContext jasperReportsContext) {
        SAXParser parser = this.createParser(jasperReportsContext);
        JRXmlDigester digester = new JRXmlDigester(parser);
        try {
            this.configureDigester(jasperReportsContext, digester);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new JRRuntimeException(e);
        }
        return digester;
    }

    protected SAXParser createParser(JasperReportsContext jasperReportsContext) {
        String parserFactoryClass = JRPropertiesUtil.getInstance(jasperReportsContext).getProperty("net.sf.jasperreports.template.xml.parser.factory");
        if (log.isDebugEnabled()) {
            log.debug("Using template SAX parser factory class " + parserFactoryClass);
        }
        JRSaxParserFactory factory = BaseSaxParserFactory.getFactory(jasperReportsContext, parserFactoryClass);
        return factory.createParser();
    }

    protected void configureDigester(JasperReportsContext jasperReportsContext, Digester digester) throws SAXException, ParserConfigurationException {
        digester.setNamespaceAware(true);
        digester.setRuleNamespaceURI("http://jasperreports.sourceforge.net/jasperreports/template");
        boolean validating = JRPropertiesUtil.getInstance(jasperReportsContext).getBooleanProperty("net.sf.jasperreports.compiler.xml.validation");
        digester.setErrorHandler((ErrorHandler)this);
        digester.setValidating(validating);
        digester.setFeature("http://xml.org/sax/features/validation", validating);
        digester.addRuleSet(this.rules);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }
}

