/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.digester.Digester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JRXmlDigester
extends Digester {
    private static final Logger log = LoggerFactory.getLogger(JRXmlDigester.class);
    public static final String EXCEPTION_MESSAGE_KEY_ENTITY_LOADING_ERROR = "xml.digester.entity.loading.error";
    public static final String EXCEPTION_MESSAGE_UNKOWN_ENTITY_NOT_LOADING = "xml.digester.unknown.entity.not.loading";
    public static final String PROPERTY_LOAD_UNKNOWN_ENTITIES = "net.sf.jasperreports.xml.load.unknown.entities";
    private Map<String, URL> internalEntityResources;
    private Set<String> entityURLs;
    private boolean loadUnknownEntities;
    private String lastNamespacePrefix;
    private Object lastPopped;

    public JRXmlDigester() {
        this.initInternalResources();
    }

    public JRXmlDigester(XMLReader xmlReader) {
        super(xmlReader);
        this.initInternalResources();
    }

    public JRXmlDigester(SAXParser parser) {
        super(parser);
        this.initInternalResources();
    }

    private void initInternalResources() {
        this.internalEntityResources = new HashMap<String, URL>();
        this.entityURLs = new HashSet<String>();
        this.addEntityResource("http://jasperreports.sourceforge.net/dtds/jasperreport.dtd", "net/sf/jasperreports/engine/dtds/jasperreport.dtd");
        this.addEntityResource("http://jasperreports.sourceforge.net/dtds/jasperprint.dtd", "net/sf/jasperreports/engine/dtds/jasperprint.dtd");
        this.addEntityResource("http://jasperreports.sourceforge.net/dtds/jaspertemplate.dtd", "net/sf/jasperreports/engine/dtds/jaspertemplate.dtd");
        this.addEntityResource("http://jasperreports.sourceforge.net/xsd/jasperreport.xsd", "net/sf/jasperreports/engine/dtds/jasperreport.xsd");
        this.addEntityResource(null, "net/sf/jasperreports/engine/dtds/jasperreport-dtd-compat.xsd");
        this.addEntityResource("http://jasperreports.sourceforge.net/xsd/jasperprint.xsd", "net/sf/jasperreports/engine/dtds/jasperprint.xsd");
        this.addEntityResource(null, "net/sf/jasperreports/engine/dtds/jasperprint-dtd-compat.xsd");
        this.addEntityResource("http://jasperreports.sourceforge.net/xsd/jaspertemplate.xsd", "net/sf/jasperreports/engine/dtds/jaspertemplate.xsd");
        this.addEntityResource(null, "net/sf/jasperreports/engine/dtds/jaspertemplate-dtd-compat.xsd");
        this.loadUnknownEntities = JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getBooleanProperty(PROPERTY_LOAD_UNKNOWN_ENTITIES, false);
    }

    public void addInternalEntityResource(String systemId, String resource) {
        if (resource == null) {
            if (log.isDebugEnabled()) {
                log.debug("adding entity URL " + systemId);
            }
            this.entityURLs.add(systemId);
        } else {
            this.addEntityResource(systemId, resource);
        }
    }

    private void addEntityResource(String systemId, String resource) {
        URL resourceURL = JRLoader.getResource(resource);
        if (resourceURL == null) {
            log.warn("Could not find entity resource " + resource);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Entity " + systemId + " resolved to " + resourceURL);
        }
        if (systemId != null) {
            this.internalEntityResources.put(systemId, resourceURL);
        }
        this.entityURLs.add(resourceURL.toExternalForm());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputSource resolveEntity(String pubId, String systemId) {
        InputSource inputSource = null;
        if (systemId == null) return inputSource;
        URL resourceURL = this.internalEntityResources.get(systemId);
        if (resourceURL == null) {
            if (!this.entityURLs.contains(systemId) && !this.loadUnknownEntities) throw new JRRuntimeException(EXCEPTION_MESSAGE_UNKOWN_ENTITY_NOT_LOADING, systemId);
            if (!log.isDebugEnabled()) return new InputSource(systemId);
            log.debug("loading entity " + systemId);
            return new InputSource(systemId);
        }
        try {
            byte[] resourceData = JRLoader.loadBytes(resourceURL);
            ByteArrayInputStream memoryStream = new ByteArrayInputStream(resourceData);
            return new InputSource(memoryStream);
        }
        catch (JRException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_ENTITY_LOADING_ERROR, new Object[]{systemId}, e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.lastNamespacePrefix = this.getNamespacePrefix(qName);
        super.endElement(namespaceURI, localName, qName);
    }

    protected String getNamespacePrefix(String qName) {
        int sepIdx;
        String prefix = qName == null ? null : ((sepIdx = qName.indexOf(58)) > 0 ? qName.substring(0, sepIdx) : null);
        return prefix;
    }

    public String getLastNamespacePrefix() {
        return this.lastNamespacePrefix;
    }

    public Object pop() {
        this.lastPopped = super.pop();
        return this.lastPopped;
    }

    public void clearLastPopped() {
        this.lastPopped = null;
    }

    public Object lastPopped() {
        return this.lastPopped;
    }
}

