/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.PenEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public abstract class JRAbstractStyleFactory
extends JRBaseFactory {
    private static final Logger log = LoggerFactory.getLogger(JRAbstractStyleFactory.class);

    public Object createObject(Attributes atts) {
        JRDesignStyle style = new JRDesignStyle();
        style.setName(atts.getValue("name"));
        String isDefault = atts.getValue("isDefault");
        if (isDefault != null && isDefault.length() > 0) {
            style.setDefault(Boolean.valueOf(isDefault));
        }
        if (atts.getValue("style") != null) {
            this.setParentStyle(style, atts.getValue("style"));
        }
        this.setCommonStyle(style, atts);
        return style;
    }

    protected void setCommonStyle(JRStyle style, Attributes atts) {
        LineSpacingEnum lineSpacing;
        RotationEnum rotation;
        String padding;
        Color borderColor;
        PenEnum border;
        VerticalImageAlignEnum verticalImageAlign;
        HorizontalImageAlignEnum horizontalImageAlign;
        VerticalTextAlignEnum verticalTextAlign;
        HorizontalTextAlignEnum horizontalTextAlign;
        ScaleImageEnum scaleImage;
        String radius;
        FillEnum fill;
        ModeEnum mode = ModeEnum.getByName(atts.getValue("mode"));
        if (mode != null) {
            style.setMode(mode);
        }
        String forecolor = atts.getValue("forecolor");
        style.setForecolor(JRColorUtil.getColor(forecolor, null));
        String backcolor = atts.getValue("backcolor");
        style.setBackcolor(JRColorUtil.getColor(backcolor, null));
        PenEnum pen = PenEnum.getByName(atts.getValue("pen"));
        if (pen != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'pen' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(pen, style.getLinePen());
        }
        if ((fill = FillEnum.getByName(atts.getValue("fill"))) != null) {
            style.setFill(fill);
        }
        if ((radius = atts.getValue("radius")) != null && radius.length() > 0) {
            style.setRadius(Integer.valueOf(radius));
        }
        if ((scaleImage = ScaleImageEnum.getByName(atts.getValue("scaleImage"))) != null) {
            style.setScaleImage(scaleImage);
        }
        if ((horizontalTextAlign = HorizontalTextAlignEnum.getByName(atts.getValue("hAlign"))) != null) {
            style.setHorizontalTextAlign(horizontalTextAlign);
        }
        if ((horizontalTextAlign = HorizontalTextAlignEnum.getByName(atts.getValue("hTextAlign"))) != null) {
            style.setHorizontalTextAlign(horizontalTextAlign);
        }
        if ((verticalTextAlign = VerticalTextAlignEnum.getByName(atts.getValue("vAlign"))) != null) {
            style.setVerticalTextAlign(verticalTextAlign);
        }
        if ((verticalTextAlign = VerticalTextAlignEnum.getByName(atts.getValue("vTextAlign"))) != null) {
            style.setVerticalTextAlign(verticalTextAlign);
        }
        if ((horizontalImageAlign = HorizontalImageAlignEnum.getByName(atts.getValue("hAlign"))) != null) {
            style.setHorizontalImageAlign(horizontalImageAlign);
        }
        if ((horizontalImageAlign = HorizontalImageAlignEnum.getByName(atts.getValue("hImageAlign"))) != null) {
            style.setHorizontalImageAlign(horizontalImageAlign);
        }
        if ((verticalImageAlign = VerticalImageAlignEnum.getByName(atts.getValue("vAlign"))) != null) {
            style.setVerticalImageAlign(verticalImageAlign);
        }
        if ((verticalImageAlign = VerticalImageAlignEnum.getByName(atts.getValue("vImageAlign"))) != null) {
            style.setVerticalImageAlign(verticalImageAlign);
        }
        if ((border = PenEnum.getByName(atts.getValue("border"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'border' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, style.getLineBox().getPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("borderColor"), null)) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'borderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            style.getLineBox().getPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("padding")) != null && padding.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'padding' attribute is deprecated. Use the <box> tag instead.");
            }
            style.getLineBox().setPadding(Integer.valueOf(padding));
        }
        if ((border = PenEnum.getByName(atts.getValue("topBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'topBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, style.getLineBox().getTopPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("topBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'topBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            style.getLineBox().getTopPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("topPadding")) != null && padding.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'topPadding' attribute is deprecated. Use the <box> tag instead.");
            }
            style.getLineBox().setTopPadding(Integer.valueOf(padding));
        }
        if ((border = PenEnum.getByName(atts.getValue("leftBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'leftBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, style.getLineBox().getLeftPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("leftBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'leftBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            style.getLineBox().getLeftPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("leftPadding")) != null && padding.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'leftPadding' attribute is deprecated. Use the <box> tag instead.");
            }
            style.getLineBox().setLeftPadding(Integer.valueOf(padding));
        }
        if ((border = PenEnum.getByName(atts.getValue("bottomBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'bottomBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, style.getLineBox().getBottomPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("bottomBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'bottomBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            style.getLineBox().getBottomPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("bottomPadding")) != null && padding.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'bottomPadding' attribute is deprecated. Use the <box> tag instead.");
            }
            style.getLineBox().setBottomPadding(Integer.valueOf(padding));
        }
        if ((border = PenEnum.getByName(atts.getValue("rightBorder"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'rightBorder' attribute is deprecated. Use the <pen> tag instead.");
            }
            JRPenUtil.setLinePenFromPen(border, style.getLineBox().getRightPen());
        }
        if ((borderColor = JRColorUtil.getColor(atts.getValue("rightBorderColor"), Color.black)) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'rightBorderColor' attribute is deprecated. Use the <pen> tag instead.");
            }
            style.getLineBox().getRightPen().setLineColor(borderColor);
        }
        if ((padding = atts.getValue("rightPadding")) != null && padding.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'rightPadding' attribute is deprecated. Use the <box> tag instead.");
            }
            style.getLineBox().setRightPadding(Integer.valueOf(padding));
        }
        if ((rotation = RotationEnum.getByName(atts.getValue("rotation"))) != null) {
            style.setRotation(rotation);
        }
        if ((lineSpacing = LineSpacingEnum.getByName(atts.getValue("lineSpacing"))) != null) {
            if (log.isWarnEnabled()) {
                log.warn("The 'lineSpacing' attribute is deprecated. Use the <paragraph> tag instead.");
            }
            style.getParagraph().setLineSpacing(lineSpacing);
        }
        style.setMarkup(atts.getValue("markup"));
        String isStyledText = atts.getValue("isStyledText");
        if (isStyledText != null && isStyledText.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn("The 'isStyledText' attribute is deprecated. Use the 'markup' attribute instead.");
            }
            style.setMarkup(Boolean.valueOf(isStyledText) != false ? "styled" : "none");
        }
        style.setPattern(atts.getValue("pattern"));
        String isBlankWhenNull = atts.getValue("isBlankWhenNull");
        if (isBlankWhenNull != null && isBlankWhenNull.length() > 0) {
            style.setBlankWhenNull(Boolean.valueOf(isBlankWhenNull));
        }
        if (atts.getValue("fontName") != null) {
            style.setFontName(atts.getValue("fontName"));
        }
        if (atts.getValue("isBold") != null) {
            style.setBold(Boolean.valueOf(atts.getValue("isBold")));
        }
        if (atts.getValue("isItalic") != null) {
            style.setItalic(Boolean.valueOf(atts.getValue("isItalic")));
        }
        if (atts.getValue("isUnderline") != null) {
            style.setUnderline(Boolean.valueOf(atts.getValue("isUnderline")));
        }
        if (atts.getValue("isStrikeThrough") != null) {
            style.setStrikeThrough(Boolean.valueOf(atts.getValue("isStrikeThrough")));
        }
        if (atts.getValue("fontSize") != null) {
            style.setFontSize(Float.valueOf(atts.getValue("fontSize")));
        }
        if (atts.getValue("pdfFontName") != null) {
            style.setPdfFontName(atts.getValue("pdfFontName"));
        }
        if (atts.getValue("pdfEncoding") != null) {
            style.setPdfEncoding(atts.getValue("pdfEncoding"));
        }
        if (atts.getValue("isPdfEmbedded") != null) {
            style.setPdfEmbedded(Boolean.valueOf(atts.getValue("isPdfEmbedded")));
        }
    }

    protected abstract void setParentStyle(JRDesignStyle var1, String var2);
}

