/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JEditorPaneMarkupProcessor;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.StyledTextListInfo;
import net.sf.jasperreports.engine.util.StyledTextListItemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JEditorPaneHtmlMarkupProcessor
extends JEditorPaneMarkupProcessor {
    private static final Logger log = LoggerFactory.getLogger(JEditorPaneHtmlMarkupProcessor.class);
    private Document document;
    private boolean bodyOccurred = false;
    private Stack<StyledTextListInfo> htmlListStack;
    private boolean insideLi;
    private boolean liStart;
    private StyledTextListInfo justClosedList;

    public static JEditorPaneHtmlMarkupProcessor getInstance() {
        return new JEditorPaneHtmlMarkupProcessor();
    }

    @Override
    public String convert(String srcText) {
        if (srcText.indexOf(60) >= 0 || srcText.indexOf(38) >= 0) {
            JRStyledText styledText = new JRStyledText();
            this.htmlListStack = new Stack();
            JEditorPane editorPane = new JEditorPane("text/html", srcText);
            editorPane.setEditable(false);
            this.document = editorPane.getDocument();
            this.bodyOccurred = false;
            Element root = this.document.getDefaultRootElement();
            if (root != null) {
                this.processElement(styledText, root);
            }
            styledText.setGlobalAttributes(new HashMap<AttributedCharacterIterator.Attribute, Object>());
            return JRStyledTextParser.getInstance().write(styledText);
        }
        return srcText;
    }

    private void processElement(JRStyledText styledText, Element parentElement) {
        for (int i = 0; i < parentElement.getElementCount(); ++i) {
            Object object;
            Element element = parentElement.getElement(i);
            AttributeSet attrs = element.getAttributes();
            Object elementName = attrs.getAttribute("$ename");
            Object object2 = object = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
            if (!(object instanceof HTML.Tag)) continue;
            HTML.Tag htmlTag = (HTML.Tag)object;
            if (htmlTag == HTML.Tag.BODY) {
                this.bodyOccurred = true;
                this.processElement(styledText, element);
                continue;
            }
            if (htmlTag == HTML.Tag.BR) {
                styledText.append("\n");
                int startIndex = styledText.length();
                this.resizeRuns(styledText.getRuns(), startIndex, 1);
                this.processElement(styledText, element);
                styledText.addRun(new JRStyledText.Run(new HashMap<AttributedCharacterIterator.Attribute, Object>(), startIndex, styledText.length()));
                if (startIndex >= styledText.length()) continue;
                styledText.append("\n");
                this.resizeRuns(styledText.getRuns(), startIndex, 1);
                continue;
            }
            if (htmlTag == HTML.Tag.OL || htmlTag == HTML.Tag.UL) {
                Object type = attrs.getAttribute(HTML.Attribute.TYPE);
                Object start = attrs.getAttribute(HTML.Attribute.START);
                StyledTextListInfo htmlList = new StyledTextListInfo(htmlTag == HTML.Tag.OL, htmlTag == HTML.Tag.OL && type != null ? String.valueOf(type) : null, htmlTag == HTML.Tag.OL && start != null ? Integer.valueOf(start.toString()) : null, this.insideLi);
                htmlList.setAtLiStart(this.liStart);
                this.htmlListStack.push(htmlList);
                this.insideLi = false;
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                styleAttrs.put(JRTextAttribute.HTML_LIST, this.htmlListStack.toArray(new StyledTextListInfo[this.htmlListStack.size()]));
                styleAttrs.put(JRTextAttribute.HTML_LIST_ITEM, StyledTextListItemInfo.NO_LIST_ITEM_FILLER);
                int startIndex = styledText.length();
                this.processElement(styledText, element);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                this.justClosedList = this.htmlListStack.pop();
                continue;
            }
            if (htmlTag == HTML.Tag.LI) {
                HashMap<AttributedCharacterIterator.Attribute, Object> styleAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                StyledTextListInfo htmlList = null;
                boolean ulAdded = false;
                if (this.htmlListStack.size() == 0) {
                    htmlList = new StyledTextListInfo(false, null, null, false);
                    this.htmlListStack.push(htmlList);
                    styleAttrs.put(JRTextAttribute.HTML_LIST, this.htmlListStack.toArray(new StyledTextListInfo[this.htmlListStack.size()]));
                    styleAttrs.put(JRTextAttribute.HTML_LIST_ITEM, StyledTextListItemInfo.NO_LIST_ITEM_FILLER);
                    ulAdded = true;
                } else {
                    htmlList = this.htmlListStack.peek();
                }
                htmlList.setItemCount(htmlList.getItemCount() + 1);
                this.insideLi = true;
                this.liStart = true;
                this.justClosedList = null;
                styleAttrs.put(JRTextAttribute.HTML_LIST_ITEM, new StyledTextListItemInfo(htmlList.getItemCount() - 1));
                int startIndex = styledText.length();
                this.processElement(styledText, element);
                styledText.addRun(new JRStyledText.Run(styleAttrs, startIndex, styledText.length()));
                this.insideLi = false;
                this.liStart = false;
                if (this.justClosedList != null) {
                    this.justClosedList.setAtLiEnd(true);
                }
                if (!ulAdded) continue;
                this.htmlListStack.pop();
                continue;
            }
            if (element instanceof AbstractDocument.LeafElement) {
                HTMLDocument.RunElement runElement;
                AttributeSet attrSet;
                String chunk;
                block12: {
                    chunk = null;
                    try {
                        chunk = this.document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    }
                    catch (BadLocationException e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug("Error converting markup.", (Throwable)e);
                    }
                }
                if (chunk == null || "\n".equals(chunk)) continue;
                this.liStart = false;
                this.justClosedList = null;
                int startIndex = styledText.length();
                styledText.append(chunk);
                Map<AttributedCharacterIterator.Attribute, Object> styleAttributes = this.getAttributes(element.getAttributes());
                if (element instanceof HTMLDocument.RunElement && (attrSet = (AttributeSet)(runElement = (HTMLDocument.RunElement)element).getAttribute(HTML.Tag.A)) != null) {
                    JRBasePrintHyperlink hyperlink = new JRBasePrintHyperlink();
                    hyperlink.setHyperlinkType(HyperlinkTypeEnum.REFERENCE);
                    hyperlink.setHyperlinkReference((String)attrSet.getAttribute(HTML.Attribute.HREF));
                    hyperlink.setLinkTarget((String)attrSet.getAttribute(HTML.Attribute.TARGET));
                    styleAttributes.put(JRTextAttribute.HYPERLINK, hyperlink);
                }
                styledText.addRun(new JRStyledText.Run(styleAttributes, startIndex, styledText.length()));
                continue;
            }
            if (!this.bodyOccurred) continue;
            this.processElement(styledText, element);
        }
    }

    private void resizeRuns(List<JRStyledText.Run> runs, int startIndex, int count) {
        for (int j = 0; j < runs.size(); ++j) {
            JRStyledText.Run run = runs.get(j);
            if (run.startIndex > startIndex || run.endIndex <= startIndex - count) continue;
            run.endIndex += count;
        }
    }

    protected static String getOLBulletChars(int index, boolean isUpperCase) {
        if (index < 0 || index > 18277) {
            throw new JRRuntimeException("util.markup.processor.number.outside.bounds", index);
        }
        return JRStringUtil.getLetterNumeral(index, isUpperCase);
    }
}

